/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.pdf.annots;

import com.pdftron.common.PDFNetException;
import com.pdftron.helpers.ReachabilityHelper;
import com.pdftron.pdf.Annot;
import com.pdftron.pdf.Point;
import com.pdftron.pdf.QuadPoint;
import com.pdftron.pdf.Rect;
import com.pdftron.pdf.annots.Markup;
import com.pdftron.sdf.Doc;
import com.pdftron.sdf.Obj;

public class Redaction
extends Markup {
    public static final int e_LeftJustified = 0;
    public static final int e_Centered = 1;
    public static final int e_RightJustified = 2;
    public static final int e_None = 3;

    public Redaction(Obj obj) {
        super(obj);
    }

    public Redaction() {
    }

    Redaction(long l, Object object) {
        super(l, object);
    }

    public Redaction(Annot annot) throws PDFNetException {
        super(annot.getSDFObj());
    }

    public static Redaction create(Doc doc, Rect rect) throws PDFNetException {
        Redaction redaction = new Redaction(Redaction.Create(doc.__GetHandle(), rect.__GetHandle()), doc);
        ReachabilityHelper.ensureReachable(rect);
        return redaction;
    }

    public int getQuadPointCount() throws PDFNetException {
        return Redaction.GetQuadPointCount(this.__GetHandle());
    }

    public QuadPoint getQuadPoint(int n) throws PDFNetException {
        Point point = new Point(Redaction.GetQuadPointp1x(this.__GetHandle(), n), Redaction.GetQuadPointp1y(this.__GetHandle(), n));
        Point point2 = new Point(Redaction.GetQuadPointp2x(this.__GetHandle(), n), Redaction.GetQuadPointp2y(this.__GetHandle(), n));
        Point point3 = new Point(Redaction.GetQuadPointp3x(this.__GetHandle(), n), Redaction.GetQuadPointp3y(this.__GetHandle(), n));
        Point point4 = new Point(Redaction.GetQuadPointp4x(this.__GetHandle(), n), Redaction.GetQuadPointp4y(this.__GetHandle(), n));
        return new QuadPoint(point, point2, point3, point4);
    }

    public void setQuadPoint(int n, QuadPoint quadPoint) throws PDFNetException {
        Redaction.SetQuadPoint(this.__GetHandle(), n, quadPoint.p1.x, quadPoint.p1.y, quadPoint.p2.x, quadPoint.p2.y, quadPoint.p3.x, quadPoint.p3.y, quadPoint.p4.x, quadPoint.p4.y);
    }

    public Obj getAppFormXO() throws PDFNetException {
        return Obj.__Create(Redaction.GetAppFormXO(this.__GetHandle()), this.__GetRefHandle());
    }

    public void setAppFormXO(Obj obj) throws PDFNetException {
        Redaction.SetAppFormXO(this.__GetHandle(), obj.__GetHandle());
        ReachabilityHelper.ensureReachable(obj);
    }

    public String getOverlayText() throws PDFNetException {
        return Redaction.GetOverlayText(this.__GetHandle());
    }

    public void setOverlayText(String string) throws PDFNetException {
        Redaction.SetOverlayText(this.__GetHandle(), string);
    }

    public boolean getUseRepeat() throws PDFNetException {
        return Redaction.GetUseRepeat(this.__GetHandle());
    }

    public void setUseRepeat(boolean bl) throws PDFNetException {
        Redaction.SetUseRepeat(this.__GetHandle(), bl);
    }

    public String getOverlayTextAppearance() throws PDFNetException {
        return Redaction.GetOverlayTextAppearance(this.__GetHandle());
    }

    public void setOverlayTextAppearance(String string) throws PDFNetException {
        Redaction.SetOverlayTextAppearance(this.__GetHandle(), string);
    }

    public void SetOverlayTextFont(String string) throws PDFNetException {
        Redaction.SetOverlayTextFont(this.__GetHandle(), string);
    }

    public void SetOverlayTextFontSize(double d) throws PDFNetException {
        Redaction.SetOverlayTextFontSize(this.__GetHandle(), d);
    }

    public int getQuadForm() throws PDFNetException {
        return Redaction.GetQuadForm(this.__GetHandle());
    }

    public void setQuadForm(int n) throws PDFNetException {
        Redaction.SetQuadForm(this.__GetHandle(), n);
    }

    static native long Create(long var0, long var2);

    static native int GetQuadPointCount(long var0);

    static native long GetAppFormXO(long var0);

    static native void SetAppFormXO(long var0, long var2);

    static native String GetOverlayText(long var0);

    static native void SetOverlayText(long var0, String var2);

    static native boolean GetUseRepeat(long var0);

    static native void SetUseRepeat(long var0, boolean var2);

    static native String GetOverlayTextAppearance(long var0);

    static native void SetOverlayTextAppearance(long var0, String var2);

    static native void SetOverlayTextFont(long var0, String var2);

    static native void SetOverlayTextFontSize(long var0, double var2);

    static native int GetQuadForm(long var0);

    static native void SetQuadForm(long var0, int var2);

    static native double GetQuadPointp1x(long var0, int var2);

    static native double GetQuadPointp1y(long var0, int var2);

    static native double GetQuadPointp2x(long var0, int var2);

    static native double GetQuadPointp2y(long var0, int var2);

    static native double GetQuadPointp3x(long var0, int var2);

    static native double GetQuadPointp3y(long var0, int var2);

    static native double GetQuadPointp4x(long var0, int var2);

    static native double GetQuadPointp4y(long var0, int var2);

    static native void SetQuadPoint(long var0, int var2, double var3, double var5, double var7, double var9, double var11, double var13, double var15, double var17);
}

