function initApryseSearch() {
  var script = document.createElement('script');
  script.setAttribute('type', 'text/javascript');
  script.setAttribute('src', 'https://prod.global-search.apryse.com/apryse-search.umd.js');
  script.onload = function() {
    var ele = document.getElementById('MSearchField');
    ele.setAttribute('readonly', 'readonly');

    window.apryseSearch.loadSearchTool({
      targetSelector: '#MSearchField',
      searchConfig: {
        tabs: [
          {
            name: 'API',
            filters: [
              { attribute: 'language', title: 'Language', default: 'C++' },
              { attribute: 'product', title: 'Product', default: 'Server SDK' },
            ],
          },
          {
            name: 'Guides',
            filters: [{ attribute: 'product', title: 'Product' }],
          },
          
          {
            name: 'Forum posts',
            filters: [{ attribute: 'product', title: 'Product' }],
          },
        ],
        defaultProduct: 'core'
      }
    })
  }
  document.body.appendChild(script);
}

$(document).ready(initApryseSearch);