//---------------------------------------------------------------------------------------
// Copyright (c) 2001-2025 by Apryse Software Inc. All Rights Reserved.
// Consult legal.txt regarding legal and license information.
//---------------------------------------------------------------------------------------
// !Warning! This file is autogenerated, modify the .codegen file, not this one
// (any changes here will be wiped out during the autogen process)

#ifndef PDFTRON_H_CDigestAlgorithm
#define PDFTRON_H_CDigestAlgorithm

#ifdef __cplusplus
extern "C" {
#endif

#include <C/Common/TRN_Types.h>
#include <C/Common/TRN_Exception.h>


struct TRN_DigestAlgorithm_tag;
typedef struct TRN_DigestAlgorithm_tag* TRN_DigestAlgorithm;

/* enums:  */
enum TRN_DigestAlgorithm_Type {
	e_DigestAlgorithm_SHA1 = 0,
	e_DigestAlgorithm_SHA256 = 1,
	e_DigestAlgorithm_SHA384 = 2,
	e_DigestAlgorithm_SHA512 = 3,
	e_DigestAlgorithm_RIPEMD160 = 4,
	e_DigestAlgorithm_unknown_digest_algorithm = 5
};

TRN_API TRN_DigestAlgorithmCalculateDigest(enum TRN_DigestAlgorithm_Type in_algorithm, const TRN_UChar* in_buffer, const size_t in_buf_size, TRN_Vector* result);
TRN_API TRN_DigestAlgorithmSignDigest(const TRN_UChar* digest_buf, const TRN_Size digest_buf_size, const enum TRN_DigestAlgorithm_Type digest_algorithm_type, const TRN_UString pkcs12_keyfile_path, const TRN_UString pkcs12_password, TRN_Vector* result);
TRN_API TRN_DigestAlgorithmSignDigestWithKeyfileBuffer(const TRN_UChar* digest_buf, const TRN_Size digest_buf_size, const enum TRN_DigestAlgorithm_Type digest_algorithm_type, const TRN_UChar* pkcs12_buf, const TRN_Size pkcs12_buf_size, const TRN_UString pkcs12_password, TRN_Vector* result);

#ifdef __cplusplus
} // extern C
#endif

#endif /* PDFTRON_H_CDigestAlgorithm */
