// This file is autogenerated: please see the codegen template "Options"
namespace pdftron{ namespace PDF{ 

inline CADConvertOptions::CADConvertOptions()
	: m_obj_set()
	, m_dict()
{
	m_dict = m_obj_set.CreateDict();
}

inline CADConvertOptions::~CADConvertOptions()
{
}


inline bool CADConvertOptions::GetAllowThinLines()
{
	SDF::Obj found = m_dict.FindObj("Thin-lines");
	if(found.IsValid())
	{
		return (found.GetBool());
	}
	return (true);
}

inline CADConvertOptions& CADConvertOptions::SetAllowThinLines(bool value)
{
	PDF::OptionsBase::PutBool(m_dict, "Thin-lines", (value));
	return *this;
}


inline bool CADConvertOptions::GetAutoRotate()
{
	SDF::Obj found = m_dict.FindObj("Auto-rotate");
	if(found.IsValid())
	{
		return (found.GetBool());
	}
	return (false);
}

inline CADConvertOptions& CADConvertOptions::SetAutoRotate(bool value)
{
	PDF::OptionsBase::PutBool(m_dict, "Auto-rotate", (value));
	return *this;
}


inline ColorPt CADConvertOptions::GetBackgroundColor()
{
	SDF::Obj found = m_dict.FindObj("Background-color");
	if(found.IsValid())
	{
		return OptionsBase::ColorPtFromNumber(found.GetNumber());
	}
	return OptionsBase::ColorPtFromNumber(0xFFFFFFFF);
}

inline CADConvertOptions& CADConvertOptions::SetBackgroundColor(ColorPt value)
{
	PDF::OptionsBase::PutNumber(m_dict, "Background-color", OptionsBase::ColorPtToNumber(value));
	return *this;
}


inline UString CADConvertOptions::GetColorMode()
{
	SDF::Obj found = m_dict.FindObj("ColorMode");
	if(found.IsValid())
	{
		return (found.GetAsPDFText());
	}
	return ("Original");
}

inline CADConvertOptions& CADConvertOptions::SetColorMode(const UString& value)
{
	PDF::OptionsBase::PutText(m_dict, "ColorMode", (value));
	return *this;
}


inline bool CADConvertOptions::GetIncludeInvisibleLayers()
{
	SDF::Obj found = m_dict.FindObj("Include-invisible-layers");
	if (found.IsValid())
	{
		return (found.GetBool());
	}
	return (true);
}

inline CADConvertOptions& CADConvertOptions::SetIncludeInvisibleLayers(bool value)
{
	PDF::OptionsBase::PutBool(m_dict, "Include-invisible-layers", (value));
	return *this;
}


inline bool CADConvertOptions::GetIncludeModel()
{
	SDF::Obj found = m_dict.FindObj("IncludeModel");
	if(found.IsValid())
	{
		return (found.GetBool());
	}
	return (true);
}

inline CADConvertOptions& CADConvertOptions::SetIncludeModel(bool value)
{
	PDF::OptionsBase::PutBool(m_dict, "IncludeModel", (value));
	return *this;
}

inline bool CADConvertOptions::GetIncludeNonPlottableLayers()
{
	SDF::Obj found = m_dict.FindObj("Include-non-plottable-layers");
	if (found.IsValid())
	{
		return (found.GetBool());
	}
	return (false);
}

inline CADConvertOptions& CADConvertOptions::SetIncludeNonPlottableLayers(bool value)
{
	PDF::OptionsBase::PutBool(m_dict, "Include-non-plottable-layers", (value));
	return *this;
}

inline CADConvertOptions::LayoutSortOrder CADConvertOptions::GetLayoutSortOrder()
{
	SDF::Obj found = m_dict.FindObj("LayoutSortOrder");
	if(found.IsValid())
	{
		return (LayoutSortOrder)(int)(found.GetNumber());
	}
	return (LayoutSortOrder)(int)(0);
}

inline CADConvertOptions& CADConvertOptions::SetLayoutSortOrder(CADConvertOptions::LayoutSortOrder value)
{
	PDF::OptionsBase::PutNumber(m_dict, "LayoutSortOrder", (value));
	return *this;
}


inline UInt32 CADConvertOptions::GetMaxXrefDepth()
{
	SDF::Obj found = m_dict.FindObj("XRef-depth");
	if(found.IsValid())
	{
		return (UInt32)(found.GetNumber());
	}
	return (UInt32)(1000);
}

inline CADConvertOptions& CADConvertOptions::SetMaxXrefDepth(UInt32 value)
{
	PDF::OptionsBase::PutNumber(m_dict, "XRef-depth", (value));
	return *this;
}


inline double CADConvertOptions::GetPageHeight()
{
	SDF::Obj found = m_dict.FindObj("Page-height");
	if(found.IsValid())
	{
		return (found.GetNumber());
	}
	return (594.0);
}

inline CADConvertOptions& CADConvertOptions::SetPageHeight(double value)
{
	PDF::OptionsBase::PutNumber(m_dict, "Page-height", (value));
	return *this;
}


inline double CADConvertOptions::GetPageWidth()
{
	SDF::Obj found = m_dict.FindObj("Page-width");
	if(found.IsValid())
	{
		return (found.GetNumber());
	}
	return (840.0);
}

inline CADConvertOptions& CADConvertOptions::SetPageWidth(double value)
{
	PDF::OptionsBase::PutNumber(m_dict, "Page-width", (value));
	return *this;
}


inline double CADConvertOptions::GetRasterDPI()
{
	SDF::Obj found = m_dict.FindObj("Raster-dpi");
	if(found.IsValid())
	{
		return (found.GetNumber());
	}
	return (72.0);
}

inline CADConvertOptions& CADConvertOptions::SetRasterDPI(double value)
{
	PDF::OptionsBase::PutNumber(m_dict, "Raster-dpi", (value));
	return *this;
}


inline CADConvertOptions& CADConvertOptions::AddSheets(const UString& value)
{
	PDF::OptionsBase::PushBackText(m_dict, "Sheets", (value));
	return *this;
}

inline bool CADConvertOptions::GetUnderlineTextDataFields()
{
	SDF::Obj found = m_dict.FindObj("Underline-text-data-fields");
	if(found.IsValid())
	{
		return (found.GetBool());
	}
	return (false);
}

inline CADConvertOptions& CADConvertOptions::SetUnderlineTextDataFields(bool value)
{
	PDF::OptionsBase::PutBool(m_dict, "Underline-text-data-fields", (value));
	return *this;
}

inline bool CADConvertOptions::GetUseScaleFromDocument()
{
	SDF::Obj found = m_dict.FindObj("UseScaleFromDocument");
	if(found.IsValid())
	{
		return (found.GetBool());
	}
	return (false);
}

inline CADConvertOptions& CADConvertOptions::SetUseScaleFromDocument(bool value)
{
	PDF::OptionsBase::PutBool(m_dict, "UseScaleFromDocument", (value));
	return *this;
}


inline bool CADConvertOptions::GetZoomToExtents()
{
	SDF::Obj found = m_dict.FindObj("ZoomToExtents");
	if(found.IsValid())
	{
		return (found.GetBool());
	}
	return (true);
}

inline CADConvertOptions& CADConvertOptions::SetZoomToExtents(bool value)
{
	PDF::OptionsBase::PutBool(m_dict, "ZoomToExtents", (value));
	return *this;
}



inline const SDF::Obj& CADConvertOptions::GetInternalObj() const
{
	return m_dict;
}

inline SDF::Obj& CADConvertOptions::GetInternalObj()
{
	return m_dict;
}

}
}
