// This file is autogenerated: please see the codegen template "Options"
namespace pdftron{ namespace PDF{ 

inline OCROptions::OCROptions()
	: m_obj_set()
	, m_dict()
{
	m_dict = m_obj_set.CreateDict();
}

inline OCROptions::~OCROptions()
{
}


inline bool OCROptions::GetAutoRotate()
{
	SDF::Obj found = m_dict.FindObj("AutoRotate");
	if (found.IsValid())
	{
		return found.GetBool();
	}
	return false;
}

inline OCROptions& OCROptions::SetAutoRotate(bool value)
{
	OptionsBase::PutBool(m_dict, "AutoRotate", value);
	return *this;
}


inline int OCROptions::GetDPI()
{
	SDF::Obj found = m_dict.FindObj("DPI");
	if (found.IsValid())
	{
		return found.GetNumber();
	}
	return 0;
}

inline OCROptions& OCROptions::AddDPI(int dpi)
{
	OptionsBase::PutNumber(m_dict, "DPI", dpi);
	return *this;
}


inline bool OCROptions::GetIgnoreExistingText()
{
	SDF::Obj found = m_dict.FindObj("IncludeExistingText");
	if (found.IsValid())
	{
		return found.GetBool();
	}
	return true;
}

inline OCROptions& OCROptions::SetIgnoreExistingText(bool value)
{
	OptionsBase::PutBool(m_dict, "IncludeExistingText", value);
	return *this;
}


inline bool OCROptions::GetIncludeExistingText()
{
	SDF::Obj found = m_dict.FindObj("IncludeExistingText");
	if (found.IsValid())
	{
		return found.GetBool();
	}
	return true;
}


inline OCROptions& OCROptions::SetIncludeExistingText(bool value)
{
	OptionsBase::PutBool(m_dict, "IncludeExistingText", value);
	return *this;
}


inline OCROptions& OCROptions::AddIgnoreZonesForPage(const RectCollection& value, int page_num)
{
	OptionsBase::InsertRectCollection(m_dict, "IgnoreZones", value, page_num - 1);
	return *this;
}

inline OCROptions& OCROptions::AddLang(const UString& value)
{
	OptionsBase::PushBackText(m_dict, "Langs", value);
	return *this;
}

inline UString OCROptions::GetOCREngine()
{
	SDF::Obj found = m_dict.FindObj("OCREngine");
	if (found.IsValid())
	{
		return found.GetAsPDFText();
	}
	return "";
}

inline OCROptions& OCROptions::SetOCREngine(const UString& value)
{
	OptionsBase::PutText(m_dict, "OCREngine", value);
	return *this;
}


inline OCROptions& OCROptions::AddTextZonesForPage(const RectCollection& value, int page_num)
{
	OptionsBase::InsertRectCollection(m_dict, "TextZones", value, page_num - 1);
	return *this;
}

inline bool OCROptions::GetUsePDFPageCoords()
{
	SDF::Obj found = m_dict.FindObj("UsePDFPageCoords");
	if (found.IsValid())
	{
		return found.GetBool();
	}
	return false;
}

inline OCROptions& OCROptions::SetUsePDFPageCoords(bool value)
{
	OptionsBase::PutBool(m_dict, "UsePDFPageCoords", value);
	return *this;
}


inline SDF::Obj& OCROptions::GetInternalObj()
{
	return m_dict;
}


}
}
