// This file is autogenerated: please see the codegen template "Options"
#ifndef PDFTRON_H_CPPPDFOfficeToPDFOptions
#define PDFTRON_H_CPPPDFOfficeToPDFOptions

#include <PDF/ConversionOptions.h>

namespace pdftron{ namespace PDF{ 

class OfficeToPDFOptions : public ConversionOptions
{
public:
	/**
	* Level of detail for structure tags.
	*/
	enum StructureTagLevel
	{
		e_default = 0, ///< Default level of structure tags, good for accessibility.
		e_none = 1 ///< No structure tags.  This can be used to get smaller file sizes.
	};

	/**
	* Word document comment options.
	*/
	enum DisplayComments
	{
		e_off = 0, ///< Default value. Display no comments.
		e_annotations = 1 ///< Display comments as annotations.
	};

	/**
	* PowerPoint document speaker note options.
	*/
	enum DisplaySpeakerNotes
	{
		e_no_speaker_notes = 0, ///< Default value. Display no speaker notes.
		e_speaker_notes_annotations = 1 ///< Display speaker notes as annotations.
	};

	/**
	* Dynamic fields to be updated within the document. Enum values can be
	* bitwise OR-ed to define a specific combination of fields to be
	* updated.
	*/
	enum UpdateDynamicFields
	{
		e_update_all = -1, ///< Updates all dynamic fields within the document.
		e_update_none = 0, ///< Default value. Does not update dynamic fields within the document.
		e_update_doc_props = 1 ///< Updates document property fields within the document.
	};

	/**
	* PowerPoint document animation display options.
	*/
	enum AnimationMode
	{
		e_ignore = 0, ///< Default value. Displays the default (preview) slide layout and ignores any animations. The number of generated pages is equal to the number of slides.
		e_paginate = 1 ///< Follows PowerPoint's presentation mode where each click through the presentation will be generated as a new page. If a slide contains animations that show or hide content, each click through that slide is a new page.
	};

	OfficeToPDFOptions();
	~OfficeToPDFOptions();

	
	/**
	* Gets the value AnimationHandling from the options object.
	* Specifies the handling of animations present in the PowerPoint
	* document. By default, animations will be ignored and only the default
	* content of each slide will be displayed.
	* @return The current value for AnimationHandling.
	*/
	AnimationMode GetAnimationHandling();

	/**
	* Sets the value for AnimationHandling in the options object.
	* Specifies the handling of animations present in the PowerPoint
	* document. By default, animations will be ignored and only the default
	* content of each slide will be displayed.
	* @param value The new value for AnimationHandling.
	* @return This object, for call chaining.
	*/
	OfficeToPDFOptions& SetAnimationHandling(AnimationMode value);

	
	/**
	* Gets the value ApplyPageBreaksToSheet from the options object.
	* Whether we should split Excel worksheets into pages so that the output
	* resembles print output. If set to false (the default), Excel sheets
	* will be placed one per page, except in the case where the sheets are
	* very large.
	* @return The current value for ApplyPageBreaksToSheet.
	*/
	bool GetApplyPageBreaksToSheet();

	/**
	* Sets the value for ApplyPageBreaksToSheet in the options object.
	* Whether we should split Excel worksheets into pages so that the output
	* resembles print output. If set to false (the default), Excel sheets
	* will be placed one per page, except in the case where the sheets are
	* very large.
	* @param value The new value for ApplyPageBreaksToSheet.
	* @return This object, for call chaining.
	*/
	OfficeToPDFOptions& SetApplyPageBreaksToSheet(bool value);

	
	/**
	* Gets the value DisableExcelHeadersFooters from the options object.
	* Disables the conversion of Excel headers and footers. When this flag
	* is set to True, any headers or footers in the original Excel sheet
	* will be ignored in the output.
	* @return The current value for DisableExcelHeadersFooters.
	*/
	bool GetDisableExcelHeadersFooters();

	/**
	* Sets the value for DisableExcelHeadersFooters in the options object.
	* Disables the conversion of Excel headers and footers. When this flag
	* is set to True, any headers or footers in the original Excel sheet
	* will be ignored in the output.
	* @param value The new value for DisableExcelHeadersFooters.
	* @return This object, for call chaining.
	*/
	OfficeToPDFOptions& SetDisableExcelHeadersFooters(bool value);

	
	/**
	* Gets the value DisableExcelMargins from the options object.
	* Sets Excel page margins to zero. When this flag is set to True, the
	* output pages of the Excel conversion will have no margins.
	* @return The current value for DisableExcelMargins.
	*/
	bool GetDisableExcelMargins();

	/**
	* Sets the value for DisableExcelMargins in the options object.
	* Sets Excel page margins to zero. When this flag is set to True, the
	* output pages of the Excel conversion will have no margins.
	* @param value The new value for DisableExcelMargins.
	* @return This object, for call chaining.
	*/
	OfficeToPDFOptions& SetDisableExcelMargins(bool value);

	
	/**
	* Gets the value DisableSheetHeightLimit from the options object.
	* Removes the default sheet height limit of 12 feet, after which the
	* sheet would be divided into pages up to 4 feet long each. When this
	* flag is set to True and ApplyPageBreaksToSheet is set to False, each
	* page will contain the entire corresponding sheet.
	* @return The current value for DisableSheetHeightLimit.
	*/
	bool GetDisableSheetHeightLimit();

	/**
	* Sets the value for DisableSheetHeightLimit in the options object.
	* Removes the default sheet height limit of 12 feet, after which the
	* sheet would be divided into pages up to 4 feet long each. When this
	* flag is set to True and ApplyPageBreaksToSheet is set to False, each
	* page will contain the entire corresponding sheet.
	* @param value The new value for DisableSheetHeightLimit.
	* @return This object, for call chaining.
	*/
	OfficeToPDFOptions& SetDisableSheetHeightLimit(bool value);

	
	/**
	* Gets the value DisplayChangeTracking from the options object.
	* If this option is true, will display office change tracking markup
	* present in the document (i.e, red strikethrough of deleted content and
	* underlining of new content). Otherwise displays the resolved document
	* content, with no markup. Defaults to true.
	* @return The current value for DisplayChangeTracking.
	*/
	bool GetDisplayChangeTracking();

	/**
	* Sets the value for DisplayChangeTracking in the options object.
	* If this option is true, will display office change tracking markup
	* present in the document (i.e, red strikethrough of deleted content and
	* underlining of new content). Otherwise displays the resolved document
	* content, with no markup. Defaults to true.
	* @param value The new value for DisplayChangeTracking.
	* @return This object, for call chaining.
	*/
	OfficeToPDFOptions& SetDisplayChangeTracking(bool value);

	
	/**
	* Gets the value DisplayComments from the options object.
	* Specifies the display of comments that are present in the document. By
	* default, comments will not be displayed.
	* @return The current value for DisplayComments.
	*/
	DisplayComments GetDisplayComments();

	/**
	* Sets the value for DisplayComments in the options object.
	* Specifies the display of comments that are present in the document. By
	* default, comments will not be displayed.
	* @param value The new value for DisplayComments.
	* @return This object, for call chaining.
	*/
	OfficeToPDFOptions& SetDisplayComments(DisplayComments value);

	
	/**
	* Gets the value DisplayHiddenCells from the options object.
	* Display any hidden rows and columns present in the Excel sheet (i.e.,
	* rows/columns with visibility set as 'hidden'). By default, hidden
	* cells will not be displayed.
	* @return The current value for DisplayHiddenCells.
	*/
	bool GetDisplayHiddenCells();

	/**
	* Sets the value for DisplayHiddenCells in the options object.
	* Display any hidden rows and columns present in the Excel sheet (i.e.,
	* rows/columns with visibility set as 'hidden'). By default, hidden
	* cells will not be displayed.
	* @param value The new value for DisplayHiddenCells.
	* @return This object, for call chaining.
	*/
	OfficeToPDFOptions& SetDisplayHiddenCells(bool value);

	
	/**
	* Gets the value DisplayHiddenText from the options object.
	* Display any hidden text that is present in the document (i.e., text
	* that has been marked as 'Hidden' in the font style). By default,
	* hidden text will not be displayed.
	* @return The current value for DisplayHiddenText.
	*/
	bool GetDisplayHiddenText();

	/**
	* Sets the value for DisplayHiddenText in the options object.
	* Display any hidden text that is present in the document (i.e., text
	* that has been marked as 'Hidden' in the font style). By default,
	* hidden text will not be displayed.
	* @param value The new value for DisplayHiddenText.
	* @return This object, for call chaining.
	*/
	OfficeToPDFOptions& SetDisplayHiddenText(bool value);

	
	/**
	* Gets the value DisplaySpeakerNotes from the options object.
	* Specifies the display of speaker notes that are present in the
	* PowerPoint document. By default, speaker notes will not be displayed.
	* @return The current value for DisplaySpeakerNotes.
	*/
	DisplaySpeakerNotes GetDisplaySpeakerNotes();

	/**
	* Sets the value for DisplaySpeakerNotes in the options object.
	* Specifies the display of speaker notes that are present in the
	* PowerPoint document. By default, speaker notes will not be displayed.
	* @param value The new value for DisplaySpeakerNotes.
	* @return This object, for call chaining.
	*/
	OfficeToPDFOptions& SetDisplaySpeakerNotes(DisplaySpeakerNotes value);

	
	/**
	* Gets the value ExcelDefaultCellBorderWidth from the options object.
	* Cell border width for table cells that would normally be drawn with no
	* border. In units of points. Can be used to achieve a similar effect to
	* the "show gridlines" display option within Microsoft Excel.
	* @return The current value for ExcelDefaultCellBorderWidth.
	*/
	double GetExcelDefaultCellBorderWidth();

	/**
	* Sets the value for ExcelDefaultCellBorderWidth in the options object.
	* Cell border width for table cells that would normally be drawn with no
	* border. In units of points. Can be used to achieve a similar effect to
	* the "show gridlines" display option within Microsoft Excel.
	* @param value The new value for ExcelDefaultCellBorderWidth.
	* @return This object, for call chaining.
	*/
	OfficeToPDFOptions& SetExcelDefaultCellBorderWidth(double value);

	
	/**
	* Gets the value ExcelMaxAllowedCellCount from the options object.
	* Conversion will throw an exception if the number of cells in a
	* Microsoft Excel document is above the set MaxAllowedCellCount. Used
	* for early termination of resource intensive conversions. Setting this
	* value to 250000 will allow the vast majority of Excel documents to
	* convert without issue, while keeping RAM usage to a reasonable level.
	* By default there is no limit to the number of allowed cells.
	* @return The current value for ExcelMaxAllowedCellCount.
	*/
	UInt32 GetExcelMaxAllowedCellCount();

	/**
	* Sets the value for ExcelMaxAllowedCellCount in the options object.
	* Conversion will throw an exception if the number of cells in a
	* Microsoft Excel document is above the set MaxAllowedCellCount. Used
	* for early termination of resource intensive conversions. Setting this
	* value to 250000 will allow the vast majority of Excel documents to
	* convert without issue, while keeping RAM usage to a reasonable level.
	* By default there is no limit to the number of allowed cells.
	* @param value The new value for ExcelMaxAllowedCellCount.
	* @return This object, for call chaining.
	*/
	OfficeToPDFOptions& SetExcelMaxAllowedCellCount(UInt32 value);

	
	/**
	* Gets the value HideTotalNumberOfPages from the options object.
	* If the document has an element that displays the total number of pages
	* and the total number of pages is unknown beforehand, remove those
	* elements from the document.
	* @return The current value for HideTotalNumberOfPages.
	*/
	bool GetHideTotalNumberOfPages();

	/**
	* Sets the value for HideTotalNumberOfPages in the options object.
	* If the document has an element that displays the total number of pages
	* and the total number of pages is unknown beforehand, remove those
	* elements from the document.
	* @param value The new value for HideTotalNumberOfPages.
	* @return This object, for call chaining.
	*/
	OfficeToPDFOptions& SetHideTotalNumberOfPages(bool value);

	
	/**
	* Gets the value IncludeBookmarks from the options object.
	* When this option is set to false, Word document bookmarks will not be
	* converted into PDF bookmarks. However, Word headings will still be
	* automatically converted into PDF bookmarks. By default, both Word
	* bookmarks and headings are converted into PDF bookmarks, providing a
	* comprehensive navigation structure within the converted PDF.
	* @return The current value for IncludeBookmarks.
	*/
	bool GetIncludeBookmarks();

	/**
	* Sets the value for IncludeBookmarks in the options object.
	* When this option is set to false, Word document bookmarks will not be
	* converted into PDF bookmarks. However, Word headings will still be
	* automatically converted into PDF bookmarks. By default, both Word
	* bookmarks and headings are converted into PDF bookmarks, providing a
	* comprehensive navigation structure within the converted PDF.
	* @param value The new value for IncludeBookmarks.
	* @return This object, for call chaining.
	*/
	OfficeToPDFOptions& SetIncludeBookmarks(bool value);

	
	/**
	* Gets the value IncrementalSave from the options object.
	* If this option is true, the document will be saved incrementally
	* during the conversion, thus reducing the peak memory usage. Save an
	* empty PDFDoc to the target location before the conversion so the
	* incremental saving is done directly to the target location. Otherwise,
	* a temporary file will be used. PDFDoc.Save still has to be called
	* after the conversion is done to finalize the file. Doing PDFDoc.Save
	* with e_incremental flag will reduce the saving time but increase the
	* PDF file size.
	* @return The current value for IncrementalSave.
	*/
	bool GetIncrementalSave();

	/**
	* Sets the value for IncrementalSave in the options object.
	* If this option is true, the document will be saved incrementally
	* during the conversion, thus reducing the peak memory usage. Save an
	* empty PDFDoc to the target location before the conversion so the
	* incremental saving is done directly to the target location. Otherwise,
	* a temporary file will be used. PDFDoc.Save still has to be called
	* after the conversion is done to finalize the file. Doing PDFDoc.Save
	* with e_incremental flag will reduce the saving time but increase the
	* PDF file size.
	* @param value The new value for IncrementalSave.
	* @return This object, for call chaining.
	*/
	OfficeToPDFOptions& SetIncrementalSave(bool value);

	
	/**
	* Gets the value LayoutResourcesPluginPath from the options object
	* The path at which the pdftron-provided font resource plugin resides
	* @return a UString, the current value for LayoutResourcesPluginPath.
	*/
	UString GetLayoutResourcesPluginPath();

	/**
	* Sets the value for LayoutResourcesPluginPath in the options object
	* The path at which the pdftron-provided font resource plugin resides
	* @param value: the new value for LayoutResourcesPluginPath
	* @return this object, for call chaining
	*/
	OfficeToPDFOptions& SetLayoutResourcesPluginPath(const UString& value);

	
	/**
	* Gets the value Locale from the options object.
	* ISO 639-1 code of the locale to be applied during conversion. For
	* example: 'en-US', 'ar-SA', 'de-DE', etc. Currently only applied during
	* xls/xlsx conversions.
	* @return The current value for Locale.
	*/
	UString GetLocale();

	/**
	* Sets the value for Locale in the options object.
	* ISO 639-1 code of the locale to be applied during conversion. For
	* example: 'en-US', 'ar-SA', 'de-DE', etc. Currently only applied during
	* xls/xlsx conversions.
	* @param value The new value for Locale.
	* @return This object, for call chaining.
	*/
	OfficeToPDFOptions& SetLocale(const UString& value);

	
	/**
	* Gets the value Password from the options object.
	* Password used to decrypt password-protected office documents.
	* @return The current value for Password.
	*/
	UString GetPassword();

	/**
	* Sets the value for Password in the options object.
	* Password used to decrypt password-protected office documents.
	* @param value The new value for Password.
	* @return This object, for call chaining.
	*/
	OfficeToPDFOptions& SetPassword(const UString& value);

	
	/**
	* Gets the value ResourceDocPath from the options object
	* The path at which a .docx resource document resides
	* @return a UString, the current value for ResourceDocPath.
	*/
	UString GetResourceDocPath();

	/**
	* Sets the value for ResourceDocPath in the options object
	* The path at which a .docx resource document resides
	* @param value: the new value for ResourceDocPath
	* @return this object, for call chaining
	*/
	OfficeToPDFOptions& SetResourceDocPath(const UString& value);

	
	/**
	* Gets the value SmartSubstitutionPluginPath from the options object
	* The path at which the pdftron-provided font resource plugin resides
	* @return a UString, the current value for SmartSubstitutionPluginPath.
	*/
	UString GetSmartSubstitutionPluginPath();

	/**
	* Sets the value for SmartSubstitutionPluginPath in the options object
	* The path at which the pdftron-provided font resource plugin resides
	* @param value: the new value for SmartSubstitutionPluginPath
	* @return this object, for call chaining
	*/
	OfficeToPDFOptions& SetSmartSubstitutionPluginPath(const UString& value);

	
	/**
	* Gets the value ShowExcelGridlines from the options object.
	* Forces Excel gridlines to appear in the output when they are not
	* enabled in the original sheet.
	* @return The current value for ShowExcelGridlines.
	*/
	bool GetShowExcelGridlines();

	/**
	* Sets the value for ShowExcelGridlines in the options object.
	* Forces Excel gridlines to appear in the output when they are not
	* enabled in the original sheet.
	* @param value The new value for ShowExcelGridlines.
	* @return This object, for call chaining.
	*/
	OfficeToPDFOptions& SetShowExcelGridlines(bool value);

	
	/**
	* Gets the value StructureTagLevel from the options object.
	* Specifies the level of document structure tags to include in the PDF
	* for accessibility purposes.
	* @return The current value for StructureTagLevel.
	*/
	StructureTagLevel GetStructureTagLevel();

	/**
	* Sets the value for StructureTagLevel in the options object.
	* Specifies the level of document structure tags to include in the PDF
	* for accessibility purposes.
	* @param value The new value for StructureTagLevel.
	* @return This object, for call chaining.
	*/
	OfficeToPDFOptions& SetStructureTagLevel(StructureTagLevel value);

	
	/**
	* Gets the value TemplateLeftDelimiter from the options object.
	* Left delimiter for template tags.  Defaults to '{{'.
	* @return The current value for TemplateLeftDelimiter.
	*/
	UString GetTemplateLeftDelimiter();

	/**
	* Sets the value for TemplateLeftDelimiter in the options object.
	* Left delimiter for template tags.  Defaults to '{{'.
	* @param value The new value for TemplateLeftDelimiter.
	* @return This object, for call chaining.
	*/
	OfficeToPDFOptions& SetTemplateLeftDelimiter(const UString& value);

	
	/**
	* Gets the value TemplateParamsJson from the options object.
	* JSON string representing the data to be merged into a PDFTron office
	* template.  For a more featureful template API, see
	* CreateOfficeTemplate.
	* @return The current value for TemplateParamsJson.
	*/
	UString GetTemplateParamsJson();

	/**
	* Sets the value for TemplateParamsJson in the options object.
	* JSON string representing the data to be merged into a PDFTron office
	* template.  For a more featureful template API, see
	* CreateOfficeTemplate.
	* @param value The new value for TemplateParamsJson.
	* @return This object, for call chaining.
	*/
	OfficeToPDFOptions& SetTemplateParamsJson(const UString& value);

	
	/**
	* Gets the value TemplateRightDelimiter from the options object.
	* Right delimiter for template tags.  Defaults to '}}'.
	* @return The current value for TemplateRightDelimiter.
	*/
	UString GetTemplateRightDelimiter();

	/**
	* Sets the value for TemplateRightDelimiter in the options object.
	* Right delimiter for template tags.  Defaults to '}}'.
	* @param value The new value for TemplateRightDelimiter.
	* @return This object, for call chaining.
	*/
	OfficeToPDFOptions& SetTemplateRightDelimiter(const UString& value);

	
	/**
	* Gets the value TemplateStrictMode from the options object.
	* If "Strict Mode" is enabled, when a template key is missing from the
	* json data an exception will be thrown.  If "Strict Mode" is disabled
	* (default), the tag will be replaced with no content.
	* @return The current value for TemplateStrictMode.
	*/
	bool GetTemplateStrictMode();

	/**
	* Sets the value for TemplateStrictMode in the options object.
	* If "Strict Mode" is enabled, when a template key is missing from the
	* json data an exception will be thrown.  If "Strict Mode" is disabled
	* (default), the tag will be replaced with no content.
	* @param value The new value for TemplateStrictMode.
	* @return This object, for call chaining.
	*/
	OfficeToPDFOptions& SetTemplateStrictMode(bool value);

	
	/**
	* Gets the value UpdateDynamicFields from the options object.
	* Specifies which dynamic fields should be updated within the document.
	* By default, dynamic fields will display cached field values, which is
	* consistent with the PDF export behaviour of Word. This option allows
	* fine-tuning which types of dynamic fields are updated, which would
	* otherwise have to be done manually in Word. Updating dynamic fields
	* can improve the accuracy of field content, though it may increase
	* conversion time. Some dynamic fields such as page numbers are always
	* updated regardless of this setting.
	* @return The current value for UpdateDynamicFields.
	*/
	UpdateDynamicFields GetUpdateDynamicFields();

	/**
	* Sets the value for UpdateDynamicFields in the options object.
	* Specifies which dynamic fields should be updated within the document.
	* By default, dynamic fields will display cached field values, which is
	* consistent with the PDF export behaviour of Word. This option allows
	* fine-tuning which types of dynamic fields are updated, which would
	* otherwise have to be done manually in Word. Updating dynamic fields
	* can improve the accuracy of field content, though it may increase
	* conversion time. Some dynamic fields such as page numbers are always
	* updated regardless of this setting.
	* @param value The new value for UpdateDynamicFields.
	* @return This object, for call chaining.
	*/
	OfficeToPDFOptions& SetUpdateDynamicFields(UpdateDynamicFields value);

	
	/**
	* Gets the value UpdateTableOfContents from the options object.
	* Updates the table of contents in the document so it matches the actual
	* locations of headings/bookmarks. By default, the table of contents is
	* not updated. Enabling this option may negatively affect conversion
	* speed.
	* @return The current value for UpdateTableOfContents.
	*/
	bool GetUpdateTableOfContents();

	/**
	* Sets the value for UpdateTableOfContents in the options object.
	* Updates the table of contents in the document so it matches the actual
	* locations of headings/bookmarks. By default, the table of contents is
	* not updated. Enabling this option may negatively affect conversion
	* speed.
	* @param value The new value for UpdateTableOfContents.
	* @return This object, for call chaining.
	*/
	OfficeToPDFOptions& SetUpdateTableOfContents(bool value);

	
};

}
}

#include "../Impl/OfficeToPDFOptions.inl"
#endif // PDFTRON_H_CPPPDFOfficeToPDFOptions
