//---------------------------------------------------------------------------------------
// Copyright (c) 2001-2025 by Apryse Software Inc. All Rights Reserved.
// Consult legal.txt regarding legal and license information.
//---------------------------------------------------------------------------------------
// !Warning! This file is autogenerated, modify the .codegen file, not this one
// (any changes here will be wiped out during the autogen process)

#ifndef PDFTRON_H_CPPPDFPDFUAPDFUAConformance
#define PDFTRON_H_CPPPDFPDFUAPDFUAConformance
#include <C/PDF/PDFUA/TRN_PDFUAConformance.h>

#include <Common/BasicTypes.h>
#include <Common/UString.h>
#include <PDF/PDFDoc.h>

namespace pdftron { namespace PDF { namespace PDFUA { 
class PDFUAOptions;

/**
 * The class PDFUAConformance.
 * PDFUAConformance class is used to process PDF documents for PDF/UA (ISO 14289-1) compliance,
 * including converting existing PDF files to PDF/UA compliant documents.
 *
 * Note: This feature is currently experimental and subject to change.
 */
class PDFUAConformance
{
public:
	enum Level
	{
		e_UA_Level1 = 0 
	};
	PDFUAConformance();
	PDFUAConformance(const PDFUAConformance& other);
	PDFUAConformance& operator= (const PDFUAConformance& other);
	~PDFUAConformance();
	void Destroy();

	/**
	 * Converts the input pdf to PDF/UA, will auto-gen required structure analysis JSON, requires DataExtractionModule (with Doc Structure engine) to be properly configured.
	 *
	 * @param src_file The path to the PDF file to convert.
	 * @param dest_file The path to output the converted file.
	 * @note This function is experimental and is subject to change.
	 */
	void AutoConvert(const UString& src_file, const UString& dest_file);
	/**
	 * Converts the input pdf to PDF/UA, will auto-gen required structure analysis JSON, requires DataExtractionModule (with Doc Structure engine) to be properly configured.
	 * 
	 * @param src_file The path to the PDF file to convert.
	 * @param dest_file The path to output the converted file.
	 * @param options The options to use when converting/validating, see PDFUAOptions for details.
	 * @note This function is experimental and is subject to change.
	 */
	void AutoConvert(const UString& src_file, const UString& dest_file, const PDFUAOptions& options);

	//for xamarin use only
	static PDFUAConformance* CreateInternal(ptrdiff_t impl);
	ptrdiff_t GetHandleInternal();


#ifndef SWIGHIDDEN
	TRN_PDFUAConformance m_impl;
	PDFUAConformance(TRN_PDFUAConformance impl);
#endif

private:

#ifndef SWIGHIDDEN
	mutable bool m_owner; 
#endif
};

} //end pdftron
} //end PDF
} //end PDFUA

#include <PDF/PDFUA/PDFUAOptions.h> // Required for PDFUAConformance.inl
#include <Impl/PDFUAConformance.inl>

#endif //PDFTRON_H_CPPPDFPDFUAPDFUAConformance
