//---------------------------------------------------------------------------------------
// Copyright (c) 2001-2025 by Apryse Software Inc. All Rights Reserved.
// Consult legal.txt regarding legal and license information.
//---------------------------------------------------------------------------------------
// !Warning! This file is autogenerated, modify the .codegen file, not this one
// (any changes here will be wiped out during the autogen process)

#ifndef PDFTRON_H_CPPPDFTransPDF
#define PDFTRON_H_CPPPDFTransPDF
#include <C/PDF/TRN_TransPDF.h>

#include <Common/BasicTypes.h>
#include <Common/UString.h>
#include <PDF/PDFDoc.h>
#include <PDF/TransPDFOptions.h>

namespace pdftron { namespace PDF { 


/**
 * The class TransPDF.
 * static interface to TransPDF xliff extraction and importing
 */
class TransPDF
{
public:
		
	/**
	 * Extract the XLIFF and tag a PDF for translation.
	 * 
	 * @param input_output_pdf The pdf to be processed.
	 * @param output_stream_for_xliff The XLIFF extracted.
	 * @param options TransPDF options (optional).
	 */
	static void ExtractXLIFFWithFilter(PDFDoc& input_output_pdf, Filters::Filter& output_stream_for_xliff, const TransPDFOptions& options = TransPDFOptions());
	
	/**
	 * Import translated XLIFF into a tagged PDF.
	 * 
	 * @param input The pdf to be processed.
	 * @param incoming_xliff The XLIFF to import.
	 * @param options TransPDF options (optional).
	 */
	static void ApplyXLIFFWithFilter(PDFDoc& input, Filters::Filter& incoming_xliff, const TransPDFOptions& options = TransPDFOptions());
	
	/**
	 * Extract the XLIFF and tag a PDF for translation.
	 * 
	 * @param input_output_pdf The pdf to be processed.
	 * @param output_xliff Path to the extracted XLIFF.
	 * @param options TransPDF options (optional).
	 */
	static void ExtractXLIFF(PDFDoc& input_output_pdf, const UString& output_xliff, const TransPDFOptions& options = TransPDFOptions());
	
	/**
	 * Import translated XLIFF into a tagged PDF.
	 * 
	 * @param input The pdf to be processed.
	 * @param incoming_xliff Path to the XLIFF to import.
	 * @param options TransPDF options (optional).
	 */
	static void ApplyXLIFF(PDFDoc& input, const UString& incoming_xliff, const TransPDFOptions& options = TransPDFOptions());

};

#include <Impl/TransPDF.inl>
} //end pdftron
} //end PDF


#endif //PDFTRON_H_CPPPDFTransPDF
