//---------------------------------------------------------------------------------------
// Copyright (c) 2001-2025 by Apryse Software Inc. All Rights Reserved.
// Consult legal.txt regarding legal and license information.
//---------------------------------------------------------------------------------------
// !Warning! This file is autogenerated, modify the .codegen file, not this one
// (any changes here will be wiped out during the autogen process)

#ifndef PDFTRON_H_CPPSDFResultSnapshot
#define PDFTRON_H_CPPSDFResultSnapshot
#include <C/SDF/TRN_ResultSnapshot.h>

#include <Common/BasicTypes.h>
#include <Common/UString.h>
#include <PDF/PDFDoc.h>

namespace pdftron { namespace SDF { 


/**
 * The class ResultSnapshot.
 * Represents a transition between two document states.
 */
class ResultSnapshot
{
public:
	ResultSnapshot(const ResultSnapshot& other);
	ResultSnapshot(TRN_ResultSnapshot impl);
	ResultSnapshot& operator= (const ResultSnapshot& other);
	~ResultSnapshot();
	
	void Destroy();

	//methods:
	
	/**
	 * Retrieves the document state to which this transition has transitioned.
	 * 
	 * @return The current document state.
	 */
	DocSnapshot CurrentState() const;
	
	/**
	 * Retrieves the document state from which this transition has transitioned.
	 * 
	 * @return The previous document state.
	 */
	DocSnapshot PreviousState() const;
	
	/**
	 * Returns whether this transition is valid or a null transition.
	 * 
	 * @return Whether this transition is valid or a null transition.
	 */
	bool IsOk() const;
	
	/**
	 * Returns whether this transition is a null transition.
	 * 
	 * @return Whether this transition is a null transition.
	 */
	bool IsNullTransition() const;

#ifndef SWIGHIDDEN
	TRN_ResultSnapshot m_impl;
#endif

	// Internal use only
	ResultSnapshot();

private:

#ifndef SWIGHIDDEN
	mutable bool m_owner; 
#endif
};

#include <Impl/ResultSnapshot.inl>
} //end pdftron
} //end SDF


#endif //PDFTRON_H_CPPSDFResultSnapshot
