//---------------------------------------------------------------------------------------
// Copyright (c) 2001-2025 by Apryse Software Inc. All Rights Reserved.
// Consult legal.txt regarding legal and license information.
//---------------------------------------------------------------------------------------
// !Warning! This file is autogenerated, modify the .codegen file, not this one
// (any changes here will be wiped out during the autogen process)

#ifndef PDFTRON_H_CPPSDFUndoManager
#define PDFTRON_H_CPPSDFUndoManager
#include <C/SDF/TRN_UndoManager.h>
#include <SDF/DocSnapshot.h>
#include <SDF/ResultSnapshot.h>

#include <Common/BasicTypes.h>
#include <Common/UString.h>
#include <PDF/PDFDoc.h>

namespace pdftron { namespace SDF { 


/**
 * The class UndoManager.
 * Undo-redo interface; one-to-one mapped to document
 */
class UndoManager
{
public:
	UndoManager(const UndoManager& other);
	UndoManager(TRN_UndoManager impl);
	UndoManager& operator= (const UndoManager& other);
	~UndoManager();
	
	void Destroy();

	//methods:
	
	/**
	 * Forget all changes in this manager (without changing the document).
	 * 
	 * @return An invalid DocSnapshot.
	 */
	DocSnapshot DiscardAllSnapshots();
	
	/**
	 * Restores to the previous snapshot point, if there is one.
	 * 
	 * @return The resulting snapshot id.
	 */
	ResultSnapshot Undo();
	
	/**
	 * Returns whether it is possible to undo from the current snapshot.
	 * 
	 * @return Whether it is possible to undo from the current snapshot.
	 */
	bool CanUndo() const;
	
	/**
	 * Gets the previous state of the document. This state may be invalid if it is impossible to undo.
	 * 
	 * @return The previous state of the document. This state may be invalid if it is impossible to undo.
	 */
	DocSnapshot GetNextUndoSnapshot() const;
	
	/**
	 * Restores to the next snapshot, if there is one.
	 * 
	 * @return A representation of the transition to the next snapshot, if there is one.
	 */
	ResultSnapshot Redo();
	
	/**
	 * Returns a boolean indicating whether it is possible to redo from the current snapshot.
	 * 
	 * @return A boolean indicating whether it is possible to redo from the current snapshot.
	 */
	bool CanRedo() const;
	
	/**
	 * Gets the next state of the document. This state may be invalid if it is impossible to redo.
	 * 
	 * @return The next state of the document. This state may be invalid if it is impossible to redo.
	 */
	DocSnapshot GetNextRedoSnapshot() const;
	
	/**
	 * Creates a snapshot of document state, transitions to the new snapshot.
	 * 
	 * @return A representation of the transition.
	 */
	ResultSnapshot TakeSnapshot();

#ifdef SWIG
	UndoManager();
#endif

#ifndef SWIGHIDDEN
	TRN_UndoManager m_impl;
#endif

private:

#ifndef SWIGHIDDEN
	mutable bool m_owner; 
#endif
};

#include <Impl/UndoManager.inl>
} //end pdftron
} //end SDF


#endif //PDFTRON_H_CPPSDFUndoManager
