//
// Copyright (c) 2001-2023 by Apryse Software Inc. All Rights Reserved.
//

using System;
using System.IO;
using pdftron;
using pdftron.Common;
using pdftron.Filters;
using pdftron.SDF;
using pdftron.PDF;
using pdftron.FDF;

// The following sample illustrates how to find and replace text in a document
namespace FindReplaceTestCS
{
	class Class1
	{
		private static pdftron.PDFNetLoader pdfNetLoader = pdftron.PDFNetLoader.Instance();
		static Class1() {}
		
		[STAThread]
		static void Main(string[] args)
		{
			PDFNet.Initialize(PDFTronLicense.Key);

			// Relative path to the folder containing test files.
			string input_path =  "../../TestFiles/";
			string output_path = "../../TestFiles/Output/";

			try  
			{
				// Read a PDF document from a stream or pass-in a memory buffer...
				FileStream istm = new FileStream(input_path + "find-replace-test.pdf", FileMode.Open, FileAccess.Read);
				
				using (PDFDoc doc = new PDFDoc(istm))
				{
					FindReplaceOptions options = new FindReplaceOptions();

					// Set some find/replace options
					options.SetWholeWords(true);
					options.SetMatchCase(true);
					options.SetMatchMode(FindReplaceOptions.MatchType.e_exact);
					options.SetReflowMode(FindReplaceOptions.ReflowType.e_para);
					options.SetAlignment(FindReplaceOptions.HorizAlignment.e_left);

					// Perform a Find/Replace finding "the" with "THE INCREDIBLE"
					FindReplace.FindReplaceText(doc, "the", "THE INCREDIBLE", options);

					// Save the edited PDF
					doc.Save(output_path + "find-replace-test-replaced.pdf", SDFDoc.SaveOptions.e_linearized);
					doc.Close();
				}
			}
			catch (PDFNetException e)
			{
				Console.WriteLine(e.Message);
			}
			PDFNet.Terminate();
		}
	}
}
