/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.crypto;

import com.pdftron.common.PDFNetException;
import java.util.HashMap;

public enum DigestAlgorithm {
    e_sha1(0),
    e_sha256(1),
    e_sha384(2),
    e_sha512(3),
    e_ripemd160(4),
    e_unknown_digest_algorithm(5);

    public final int value;
    private static HashMap<Integer, DigestAlgorithm> digest_algorithm_map;

    private DigestAlgorithm(int n2) {
        this.value = n2;
    }

    public static DigestAlgorithm valueToEnum(int n) {
        return digest_algorithm_map.get(n);
    }

    public static byte[] calculateDigest(DigestAlgorithm digestAlgorithm, byte[] byArray) throws PDFNetException {
        return DigestAlgorithm.CalculateDigest(digestAlgorithm.value, byArray);
    }

    public static byte[] signDigest(byte[] byArray, DigestAlgorithm digestAlgorithm, String string, String string2) throws PDFNetException {
        return DigestAlgorithm.SignDigest(byArray, digestAlgorithm.value, string, string2);
    }

    public static byte[] signDigest(byte[] byArray, DigestAlgorithm digestAlgorithm, byte[] byArray2, String string) throws PDFNetException {
        return DigestAlgorithm.SignDigestWithKeyfileBuffer(byArray, digestAlgorithm.value, byArray2, string);
    }

    static native byte[] CalculateDigest(int var0, byte[] var1);

    static native byte[] SignDigest(byte[] var0, int var1, String var2, String var3);

    static native byte[] SignDigestWithKeyfileBuffer(byte[] var0, int var1, byte[] var2, String var3);

    static {
        digest_algorithm_map = new HashMap();
        for (DigestAlgorithm digestAlgorithm : DigestAlgorithm.values()) {
            digest_algorithm_map.put(digestAlgorithm.value, digestAlgorithm);
        }
    }
}

