/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.crypto;

import com.pdftron.common.PDFNetException;
import com.pdftron.crypto.AlgorithmIdentifier;
import com.pdftron.crypto.AlgorithmParams;
import com.pdftron.helpers.ReachabilityHelper;

public class RSASSAPSSParams
extends AlgorithmParams {
    public AlgorithmIdentifier getDigestAlgorithm() throws PDFNetException {
        return new AlgorithmIdentifier(RSASSAPSSParams.GetDigestAlgorithm(this.__GetHandle()));
    }

    public AlgorithmIdentifier getMaskGenAlgorithm() throws PDFNetException {
        return new AlgorithmIdentifier(RSASSAPSSParams.GetMaskGenAlgorithm(this.__GetHandle()));
    }

    public int getSaltLength() throws PDFNetException {
        return RSASSAPSSParams.GetSaltLength(this.__GetHandle());
    }

    public int getTrailerField() throws PDFNetException {
        return RSASSAPSSParams.GetTrailerField(this.__GetHandle());
    }

    public void setDigestAlgorithm(AlgorithmIdentifier algorithmIdentifier) throws PDFNetException {
        RSASSAPSSParams.SetDigestAlgorithm(this.__GetHandle(), algorithmIdentifier.__GetHandle());
        ReachabilityHelper.ensureReachable(algorithmIdentifier);
    }

    public void setMaskGenAlgorithm(AlgorithmIdentifier algorithmIdentifier) throws PDFNetException {
        RSASSAPSSParams.SetMaskGenAlgorithm(this.__GetHandle(), algorithmIdentifier.__GetHandle());
        ReachabilityHelper.ensureReachable(algorithmIdentifier);
    }

    public void setSaltLength(int n) throws PDFNetException {
        RSASSAPSSParams.SetSaltLength(this.__GetHandle(), n);
    }

    public void setTrailerField(int n) throws PDFNetException {
        RSASSAPSSParams.SetTrailerField(this.__GetHandle(), n);
    }

    public RSASSAPSSParams() throws PDFNetException {
        super(RSASSAPSSParams.Create());
    }

    public RSASSAPSSParams(AlgorithmIdentifier algorithmIdentifier, int n) throws PDFNetException {
        super(RSASSAPSSParams.CreateFromAlgoIdAndSaltLen(algorithmIdentifier.__GetHandle(), n));
        ReachabilityHelper.ensureReachable(algorithmIdentifier);
    }

    static native long GetDigestAlgorithm(long var0);

    static native long GetMaskGenAlgorithm(long var0);

    static native int GetSaltLength(long var0);

    static native int GetTrailerField(long var0);

    static native void SetDigestAlgorithm(long var0, long var2);

    static native void SetMaskGenAlgorithm(long var0, long var2);

    static native void SetSaltLength(long var0, int var2);

    static native void SetTrailerField(long var0, int var2);

    static native long Create();

    static native long CreateFromAlgoIdAndSaltLen(long var0, int var2);
}

