/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.filters;

import com.pdftron.common.PDFNetException;

public class Filter
implements AutoCloseable {
    static final int e_begin = 0;
    static final int e_end = 2;
    static final int e_cur = 1;
    protected long impl;
    protected Filter attached;
    protected Object ref;

    public void destroy() throws PDFNetException {
        if (this.attached == null && this.ref == null && this.impl != 0L) {
            Filter.Destroy(this.impl);
            this.impl = 0L;
        }
    }

    protected void finalize() throws Throwable {
        this.destroy();
    }

    public void attachFilter(Filter filter) throws PDFNetException {
        if (filter != null) {
            Filter.AttachFilter(this.impl, filter.impl);
            filter.attached = this;
        }
    }

    public Filter releaseAttachedFilter() throws PDFNetException {
        long l = Filter.ReleaseAttachedFilter(this.impl);
        if (l == 0L) {
            return null;
        }
        return new Filter(l, null);
    }

    public Filter getAttachedFilter() throws PDFNetException {
        return new Filter(Filter.GetAttachedFilter(this.impl), this);
    }

    public Filter getSourceFilter() throws PDFNetException {
        long l = Filter.GetSourceFilter(this.impl);
        Filter filter = this;
        while (filter.attached != null) {
            filter = filter.attached;
        }
        return new Filter(l, filter);
    }

    public String getName() throws PDFNetException {
        return Filter.GetName(this.impl);
    }

    public String getDecodeName() throws PDFNetException {
        return Filter.GetDecodeName(this.impl);
    }

    public void setStreamLength(long l) throws PDFNetException {
        Filter.SetStreamLength(this.impl, l);
    }

    public void flush() throws PDFNetException {
        Filter.Flush(this.impl);
    }

    public void flushAll() throws PDFNetException {
        Filter.FlushAll(this.impl);
    }

    public boolean isInputFilter() throws PDFNetException {
        return Filter.IsInputFilter(this.impl);
    }

    public boolean canSeek() throws PDFNetException {
        return Filter.CanSeek(this.impl);
    }

    public void seek(long l, int n) throws PDFNetException {
        Filter.Seek(this.impl, l, n);
    }

    public long size() throws PDFNetException {
        return Filter.Size(this.impl);
    }

    public long tell() throws PDFNetException {
        return Filter.Tell(this.impl);
    }

    public Filter createInputIterator() throws PDFNetException {
        return new Filter(Filter.CreateInputIterator(this.impl), null);
    }

    public String getFilePath() throws PDFNetException {
        return Filter.GetFilePath(this.impl);
    }

    public void writeToFile(String string, boolean bl) {
        Filter.WriteToFile(this.impl, string, bl);
    }

    protected Filter(long l, Filter filter) {
        this.impl = l;
        this.attached = filter;
    }

    public static Filter __Create(long l, Filter filter) {
        return new Filter(l, filter);
    }

    public long __GetHandle() {
        return this.impl;
    }

    public void __SetRefHandle(Object object) {
        this.ref = object;
    }

    @Override
    public void close() throws PDFNetException {
        this.destroy();
    }

    static native void Destroy(long var0);

    static native void AttachFilter(long var0, long var2);

    static native long ReleaseAttachedFilter(long var0);

    static native long GetAttachedFilter(long var0);

    static native long GetSourceFilter(long var0);

    static native String GetName(long var0);

    static native String GetDecodeName(long var0);

    static native void SetStreamLength(long var0, long var2);

    static native void Flush(long var0);

    static native void FlushAll(long var0);

    static native boolean IsInputFilter(long var0);

    static native boolean CanSeek(long var0);

    static native void Seek(long var0, long var2, int var4);

    static native long Size(long var0);

    static native long Tell(long var0);

    static native long CreateInputIterator(long var0);

    static native String GetFilePath(long var0);

    static native void WriteToFile(long var0, String var2, boolean var3);
}

