/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.pdf;

import com.pdftron.common.PDFNetException;
import com.pdftron.helpers.ReachabilityHelper;
import com.pdftron.pdf.ColorPt;
import com.pdftron.pdf.Date;
import com.pdftron.pdf.Page;
import com.pdftron.pdf.Rect;
import com.pdftron.pdf.RefreshOptions;
import com.pdftron.sdf.Doc;
import com.pdftron.sdf.Obj;

public class Annot {
    public static final int e_Text = 0;
    public static final int e_Link = 1;
    public static final int e_FreeText = 2;
    public static final int e_Line = 3;
    public static final int e_Square = 4;
    public static final int e_Circle = 5;
    public static final int e_Polygon = 6;
    public static final int e_Polyline = 7;
    public static final int e_Highlight = 8;
    public static final int e_Underline = 9;
    public static final int e_Squiggly = 10;
    public static final int e_StrikeOut = 11;
    public static final int e_Stamp = 12;
    public static final int e_Caret = 13;
    public static final int e_Ink = 14;
    public static final int e_Popup = 15;
    public static final int e_FileAttachment = 16;
    public static final int e_Sound = 17;
    public static final int e_Movie = 18;
    public static final int e_Widget = 19;
    public static final int e_Screen = 20;
    public static final int e_PrinterMark = 21;
    public static final int e_TrapNet = 22;
    public static final int e_Watermark = 23;
    public static final int e_3D = 24;
    public static final int e_Redact = 25;
    public static final int e_Projection = 26;
    public static final int e_RichMedia = 27;
    public static final int e_Unknown = 28;
    public static final int e_action_trigger_activate = 0;
    public static final int e_action_trigger_annot_enter = 1;
    public static final int e_action_trigger_annot_exit = 2;
    public static final int e_action_trigger_annot_down = 3;
    public static final int e_action_trigger_annot_up = 4;
    public static final int e_action_trigger_annot_focus = 5;
    public static final int e_action_trigger_annot_blur = 6;
    public static final int e_action_trigger_annot_page_open = 7;
    public static final int e_action_trigger_annot_page_close = 8;
    public static final int e_action_trigger_annot_page_visible = 9;
    public static final int e_action_trigger_annot_page_invisible = 10;
    public static final int e_invisible = 0;
    public static final int e_hidden = 1;
    public static final int e_print = 2;
    public static final int e_no_zoom = 3;
    public static final int e_no_rotate = 4;
    public static final int e_no_view = 5;
    public static final int e_read_only = 6;
    public static final int e_locked = 7;
    public static final int e_toggle_no_view = 8;
    public static final int e_locked_contents = 9;
    public static final int e_normal = 0;
    public static final int e_rollover = 1;
    public static final int e_down = 2;
    long impl;
    Object ref;

    public static Annot create(Doc doc, int n, Rect rect) throws PDFNetException {
        Annot annot = new Annot(Annot.Create(doc.__GetHandle(), n, rect.impl), doc);
        ReachabilityHelper.ensureReachable(doc);
        ReachabilityHelper.ensureReachable(rect);
        return annot;
    }

    public Annot(Obj obj) {
        this.impl = obj.__GetHandle();
        this.ref = obj.__GetRefHandle();
    }

    public Annot() {
        this.impl = 0L;
        this.ref = null;
    }

    public Obj getTriggerAction(int n) throws PDFNetException {
        return Obj.__Create(Annot.GetTriggerAction(this.impl, n), this.ref);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Annot) {
            return this.impl == ((Annot)object).impl;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.impl;
    }

    public boolean isValid() throws PDFNetException {
        return Annot.IsValid(this.impl);
    }

    public Obj getSDFObj() throws PDFNetException {
        return Obj.__Create(this.impl, this.ref);
    }

    public int getType() throws PDFNetException {
        return Annot.GetType(this.impl);
    }

    public boolean isMarkup() throws PDFNetException {
        return Annot.IsMarkup(this.impl);
    }

    public String getContents() throws PDFNetException {
        return Annot.GetContents(this.impl);
    }

    public void setContents(String string) throws PDFNetException {
        Annot.SetContents(this.impl, string);
    }

    public Rect getRect() throws PDFNetException {
        return new Rect(Annot.GetRect(this.impl));
    }

    public Rect getVisibleContentBox() throws PDFNetException {
        return new Rect(Annot.GetVisibleContentBox(this.impl));
    }

    public void setRect(Rect rect) throws PDFNetException {
        Annot.SetRect(this.impl, rect.impl);
        ReachabilityHelper.ensureReachable(rect);
    }

    public Page getPage() throws PDFNetException {
        return new Page(Annot.GetPage(this.impl), this.ref);
    }

    public void setPage(Page page) throws PDFNetException {
        Annot.SetPage(this.impl, page.impl);
        ReachabilityHelper.ensureReachable(page);
    }

    public Obj getUniqueID() throws PDFNetException {
        return Obj.__Create(Annot.GetUniqueID(this.impl), this.ref);
    }

    public void setUniqueID(String string) throws PDFNetException {
        Annot.SetUniqueID(this.impl, string);
    }

    public Date getDate() throws PDFNetException {
        return new Date(Annot.GetDate(this.impl));
    }

    public void setDate(Date date) throws PDFNetException {
        Annot.SetDate(this.impl, date.impl);
        ReachabilityHelper.ensureReachable(date);
    }

    public void setDateToNow() throws PDFNetException {
        Annot.SetDateToNow(this.impl);
    }

    public boolean getFlag(int n) throws PDFNetException {
        return Annot.GetFlag(this.impl, n);
    }

    public void setFlag(int n, boolean bl) throws PDFNetException {
        Annot.SetFlag(this.impl, n, bl);
    }

    public BorderStyle getBorderStyle() throws PDFNetException {
        return new BorderStyle(Annot.GetBorderStyle(this.impl));
    }

    public void setBorderStyle(BorderStyle borderStyle) throws PDFNetException {
        Annot.SetBorderStyle(this.impl, borderStyle.impl);
        ReachabilityHelper.ensureReachable(borderStyle);
    }

    public Obj getAppearance() throws PDFNetException {
        return Obj.__Create(Annot.GetAppearance(this.impl, 0, null), this.ref);
    }

    public Obj getAppearance(int n) throws PDFNetException {
        return Obj.__Create(Annot.GetAppearance(this.impl, n, null), this.ref);
    }

    public Obj getAppearance(int n, String string) throws PDFNetException {
        return Obj.__Create(Annot.GetAppearance(this.impl, n, string), this.ref);
    }

    public void setAppearance(Obj obj) throws PDFNetException {
        Annot.SetAppearance(this.impl, obj.__GetHandle(), 0, null);
        ReachabilityHelper.ensureReachable(obj);
    }

    public void removeAppearance() throws PDFNetException {
        Annot.RemoveAppearance(this.impl, 0, null);
    }

    public void removeAppearance(int n, String string) throws PDFNetException {
        Annot.RemoveAppearance(this.impl, n, string);
    }

    public void setAppearance(Obj obj, int n) throws PDFNetException {
        Annot.SetAppearance(this.impl, obj.__GetHandle(), n, null);
        ReachabilityHelper.ensureReachable(obj);
    }

    public void setAppearance(Obj obj, int n, String string) throws PDFNetException {
        Annot.SetAppearance(this.impl, obj.__GetHandle(), n, string);
        ReachabilityHelper.ensureReachable(obj);
    }

    public void flatten(Page page) throws PDFNetException {
        Annot.Flatten(this.impl, page.impl);
        ReachabilityHelper.ensureReachable(page);
    }

    public String getActiveAppearanceState() throws PDFNetException {
        return Annot.GetActiveAppearanceState(this.impl);
    }

    public void setActiveAppearanceState(String string) throws PDFNetException {
        Annot.SetActiveAppearanceState(this.impl, string);
    }

    public ColorPt getColorAsRGB() throws PDFNetException {
        return new ColorPt(Annot.GetColorAsRGB(this.impl));
    }

    public ColorPt getColorAsCMYK() throws PDFNetException {
        return new ColorPt(Annot.GetColorAsCMYK(this.impl));
    }

    public ColorPt getColorAsGray() throws PDFNetException {
        return new ColorPt(Annot.GetColorAsGray(this.impl));
    }

    public int getColorCompNum() throws PDFNetException {
        return Annot.GetColorCompNum(this.impl);
    }

    public void setColor(ColorPt colorPt) throws PDFNetException {
        this.setColor(colorPt, 3);
    }

    public void setColor(ColorPt colorPt, int n) throws PDFNetException {
        Annot.SetColor(this.impl, colorPt.impl, n);
        ReachabilityHelper.ensureReachable(colorPt);
    }

    public int GetStructParent() throws PDFNetException {
        return Annot.GetStructParent(this.impl);
    }

    public void setStructParent(int n) throws PDFNetException {
        Annot.SetStructParent(this.impl, n);
    }

    public Obj getOptionalContent() throws PDFNetException {
        return Obj.__Create(Annot.GetOptionalContent(this.impl), this.ref);
    }

    public void setOptionalContent(Obj obj) throws PDFNetException {
        Annot.SetOptionalContent(this.impl, obj.__GetHandle());
        ReachabilityHelper.ensureReachable(obj);
    }

    public int getRotation() throws PDFNetException {
        return Annot.GetRotation(this.impl);
    }

    public void setRotation(int n) throws PDFNetException {
        Annot.SetRotation(this.impl, n);
    }

    public void refreshAppearance() throws PDFNetException {
        Annot.RefreshAppearance(this.impl);
    }

    public void refreshAppearance(RefreshOptions refreshOptions) throws PDFNetException {
        Annot.RefreshAppearanceRefreshOptions(this.impl, refreshOptions != null ? refreshOptions.getObjHandle() : 0L);
        ReachabilityHelper.ensureReachable(refreshOptions);
    }

    public String getCustomData(String string) throws PDFNetException {
        return Annot.GetCustomData(this.impl, string);
    }

    public void setCustomData(String string, String string2) throws PDFNetException {
        Annot.SetCustomData(this.impl, string, string2);
    }

    public void deleteCustomData(String string) throws PDFNetException {
        Annot.DeleteCustomData(this.impl, string);
    }

    public void resize(Rect rect) throws PDFNetException {
        Annot.Resize(this.impl, rect.impl);
        ReachabilityHelper.ensureReachable(rect);
    }

    protected Annot(long l, Object object) {
        this.impl = l;
        this.ref = object;
    }

    public static Annot __Create(long l, Object object) {
        if (l == 0L) {
            return null;
        }
        return new Annot(l, object);
    }

    public long __GetHandle() {
        return this.impl;
    }

    public Object __GetRefHandle() {
        return this.ref;
    }

    static native long GetTriggerAction(long var0, int var2);

    static native long Create(long var0, int var2, long var3);

    static native boolean IsValid(long var0);

    static native int GetType(long var0);

    static native long GetRect(long var0);

    static native long GetVisibleContentBox(long var0);

    static native boolean IsMarkup(long var0);

    static native void SetRect(long var0, long var2);

    static native String GetContents(long var0);

    static native void SetContents(long var0, String var2);

    static native long GetPage(long var0);

    static native long SetPage(long var0, long var2);

    static native boolean GetFlag(long var0, int var2);

    static native void SetFlag(long var0, int var2, boolean var3);

    static native long GetDate(long var0);

    static native void SetDate(long var0, long var2);

    static native void SetDateToNow(long var0);

    static native long GetUniqueID(long var0);

    static native void SetUniqueID(long var0, String var2);

    static native long GetColorAsRGB(long var0);

    static native long GetColorAsCMYK(long var0);

    static native long GetColorAsGray(long var0);

    static native int GetColorCompNum(long var0);

    static native void SetColor(long var0, long var2, int var4);

    static native int GetStructParent(long var0);

    static native void SetStructParent(long var0, int var2);

    static native long GetOptionalContent(long var0);

    static native void SetOptionalContent(long var0, long var2);

    static native int GetRotation(long var0);

    static native void SetRotation(long var0, int var2);

    static native void RefreshAppearance(long var0);

    static native void RefreshAppearanceRefreshOptions(long var0, long var2);

    static native void Resize(long var0, long var2);

    static native long BorderStyleCreate(int var0, int var1, int var2, int var3);

    static native long BorderStyleCreate(int var0, int var1, int var2, int var3, double[] var4);

    static native void BorderStyleDestroy(long var0);

    static native int BSGetStyle(long var0);

    static native void BSSetStyle(long var0, int var2);

    static native int BSGetHR(long var0);

    static native void BSSetHR(long var0, int var2);

    static native int BSGetVR(long var0);

    static native void BSSetVR(long var0, int var2);

    static native double BSGetWidth(long var0);

    static native void BSSetWidth(long var0, double var2);

    static native double[] BSGetDash(long var0);

    static native void BSSetDash(long var0, double[] var2);

    static native long GetBorderStyle(long var0);

    static native void SetBorderStyle(long var0, long var2);

    static native long GetAppearance(long var0, int var2, String var3);

    static native void SetAppearance(long var0, long var2, int var4, String var5);

    static native void RemoveAppearance(long var0, int var2, String var3);

    static native void Flatten(long var0, long var2);

    static native String GetActiveAppearanceState(long var0);

    static native void SetActiveAppearanceState(long var0, String var2);

    static native String GetCustomData(long var0, String var2);

    static native void SetCustomData(long var0, String var2, String var3);

    static native void DeleteCustomData(long var0, String var2);

    static native boolean IsHidden(long var0, long var2);

    public static class BorderStyle
    implements AutoCloseable {
        public static final int e_solid = 0;
        public static final int e_dashed = 1;
        public static final int e_beveled = 2;
        public static final int e_inset = 3;
        public static final int e_underline = 4;
        long impl;

        public BorderStyle(int n, int n2, int n3, int n4) throws PDFNetException {
            this.impl = Annot.BorderStyleCreate(n, n2, n3, n4);
        }

        public BorderStyle(int n, int n2, int n3, int n4, double[] dArray) throws PDFNetException {
            this.impl = Annot.BorderStyleCreate(n, n2, n3, n4, dArray);
        }

        public void destroy() throws PDFNetException {
            if (this.impl != 0L) {
                Annot.BorderStyleDestroy(this.impl);
                this.impl = 0L;
            }
        }

        protected void finalize() throws Throwable {
            this.destroy();
        }

        public int getStyle() throws PDFNetException {
            return Annot.BSGetStyle(this.impl);
        }

        public void setStyle(int n) throws PDFNetException {
            Annot.BSSetStyle(this.impl, n);
        }

        public int getHR() throws PDFNetException {
            return Annot.BSGetHR(this.impl);
        }

        public void setHR(int n) throws PDFNetException {
            Annot.BSSetHR(this.impl, n);
        }

        public int getVR() throws PDFNetException {
            return Annot.BSGetVR(this.impl);
        }

        public void setVR(int n) throws PDFNetException {
            Annot.BSSetVR(this.impl, n);
        }

        public double getWidth() throws PDFNetException {
            return Annot.BSGetWidth(this.impl);
        }

        public void setWidth(double d) throws PDFNetException {
            Annot.BSSetWidth(this.impl, d);
        }

        public double[] getDash() throws PDFNetException {
            return Annot.BSGetDash(this.impl);
        }

        public void setDash(double[] dArray) throws PDFNetException {
            Annot.BSSetDash(this.impl, dArray);
        }

        BorderStyle(long l) {
            this.impl = l;
        }

        @Override
        public void close() throws PDFNetException {
            this.destroy();
        }
    }
}

