/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.pdf;

import com.pdftron.common.PDFNetException;
import com.pdftron.pdf.ColorPt;
import com.pdftron.pdf.OptionsBase;
import com.pdftron.sdf.Obj;
import java.util.HashMap;

public class CADConvertOptions
extends OptionsBase {
    public CADConvertOptions() throws PDFNetException {
    }

    public CADConvertOptions(String string) throws PDFNetException {
        super(string);
    }

    @Override
    long getObjHandle() throws PDFNetException {
        return this.mDict.__GetHandle();
    }

    public boolean getAllowThinLines() throws PDFNetException {
        Obj obj = this.mDict.findObj("Thin-lines");
        if (obj != null && !obj.isNull()) {
            return obj.getBool();
        }
        return true;
    }

    public CADConvertOptions setAllowThinLines(boolean bl) throws PDFNetException {
        this.putBool("Thin-lines", bl);
        return this;
    }

    public boolean getAutoRotate() throws PDFNetException {
        Obj obj = this.mDict.findObj("Auto-rotate");
        if (obj != null && !obj.isNull()) {
            return obj.getBool();
        }
        return false;
    }

    public CADConvertOptions setAutoRotate(boolean bl) throws PDFNetException {
        this.putBool("Auto-rotate", bl);
        return this;
    }

    public ColorPt getBackgroundColor() throws PDFNetException {
        Obj obj = this.mDict.findObj("Background-color");
        if (obj != null && !obj.isNull()) {
            return CADConvertOptions.colorPtFromNumber(obj.getNumber());
        }
        return CADConvertOptions.colorPtFromNumber(-1.0);
    }

    public CADConvertOptions setBackgroundColor(ColorPt colorPt) throws PDFNetException {
        this.putNumber("Background-color", CADConvertOptions.colorPtToNumber(colorPt));
        return this;
    }

    public String getColorMode() throws PDFNetException {
        Obj obj = this.mDict.findObj("ColorMode");
        if (obj != null && !obj.isNull()) {
            return obj.getAsPDFText();
        }
        return "Original";
    }

    public CADConvertOptions setColorMode(String string) throws PDFNetException {
        this.putText("ColorMode", string);
        return this;
    }

    public boolean getIncludeInvisibleLayers() throws PDFNetException {
        Obj obj = this.mDict.findObj("Include-invisible-layers");
        if (obj != null && !obj.isNull()) {
            return obj.getBool();
        }
        return true;
    }

    public CADConvertOptions setIncludeInvisibleLayers(boolean bl) throws PDFNetException {
        this.putBool("Include-invisible-layers", bl);
        return this;
    }

    public boolean getIncludeModel() throws PDFNetException {
        Obj obj = this.mDict.findObj("IncludeModel");
        if (obj != null && !obj.isNull()) {
            return obj.getBool();
        }
        return true;
    }

    public CADConvertOptions setIncludeModel(boolean bl) throws PDFNetException {
        this.putBool("IncludeModel", bl);
        return this;
    }

    public boolean getIncludeNonPlottableLayers() throws PDFNetException {
        Obj obj = this.mDict.findObj("Include-non-plottable-layers");
        if (obj != null && !obj.isNull()) {
            return obj.getBool();
        }
        return false;
    }

    public CADConvertOptions setIncludeNonPlottableLayers(boolean bl) throws PDFNetException {
        this.putBool("Include-non-plottable-layers", bl);
        return this;
    }

    public LayoutSortOrder getLayoutSortOrder() throws PDFNetException {
        Obj obj = this.mDict.findObj("LayoutSortOrder");
        if (obj != null && !obj.isNull()) {
            return LayoutSortOrder.valueToEnum((int)obj.getNumber());
        }
        return LayoutSortOrder.valueToEnum(0);
    }

    public CADConvertOptions setLayoutSortOrder(LayoutSortOrder layoutSortOrder) throws PDFNetException {
        this.putNumber("LayoutSortOrder", layoutSortOrder.value);
        return this;
    }

    public int getMaxXrefDepth() throws PDFNetException {
        Obj obj = this.mDict.findObj("XRef-depth");
        if (obj != null && !obj.isNull()) {
            return (int)obj.getNumber();
        }
        return 1000;
    }

    public CADConvertOptions setMaxXrefDepth(int n) throws PDFNetException {
        this.putNumber("XRef-depth", n);
        return this;
    }

    public double getPageHeight() throws PDFNetException {
        Obj obj = this.mDict.findObj("Page-height");
        if (obj != null && !obj.isNull()) {
            return obj.getNumber();
        }
        return 594.0;
    }

    public CADConvertOptions setPageHeight(double d) throws PDFNetException {
        this.putNumber("Page-height", d);
        return this;
    }

    public double getPageWidth() throws PDFNetException {
        Obj obj = this.mDict.findObj("Page-width");
        if (obj != null && !obj.isNull()) {
            return obj.getNumber();
        }
        return 840.0;
    }

    public CADConvertOptions setPageWidth(double d) throws PDFNetException {
        this.putNumber("Page-width", d);
        return this;
    }

    public double getRasterDPI() throws PDFNetException {
        Obj obj = this.mDict.findObj("Raster-dpi");
        if (obj != null && !obj.isNull()) {
            return obj.getNumber();
        }
        return 72.0;
    }

    public CADConvertOptions setRasterDPI(double d) throws PDFNetException {
        this.putNumber("Raster-dpi", d);
        return this;
    }

    public CADConvertOptions addSheets(String string) throws PDFNetException {
        this.pushBackText("Sheets", string);
        return this;
    }

    public boolean getUnderlineTextDataFields() throws PDFNetException {
        Obj obj = this.mDict.findObj("Underline-text-data-fields");
        if (obj != null && !obj.isNull()) {
            return obj.getBool();
        }
        return false;
    }

    public CADConvertOptions setUnderlineTextDataFields(boolean bl) throws PDFNetException {
        this.putBool("Underline-text-data-fields", bl);
        return this;
    }

    public boolean getUseScaleFromDocument() throws PDFNetException {
        Obj obj = this.mDict.findObj("UseScaleFromDocument");
        if (obj != null && !obj.isNull()) {
            return obj.getBool();
        }
        return false;
    }

    public CADConvertOptions setUseScaleFromDocument(boolean bl) throws PDFNetException {
        this.putBool("UseScaleFromDocument", bl);
        return this;
    }

    public boolean getZoomToExtents() throws PDFNetException {
        Obj obj = this.mDict.findObj("ZoomToExtents");
        if (obj != null && !obj.isNull()) {
            return obj.getBool();
        }
        return true;
    }

    public CADConvertOptions setZoomToExtents(boolean bl) throws PDFNetException {
        this.putBool("ZoomToExtents", bl);
        return this;
    }

    public static enum LayoutSortOrder {
        e_default_order(0),
        e_alphabetic_order(1),
        e_alphanumeric_order(2);

        final int value;
        private static HashMap<Integer, LayoutSortOrder> layout_sort_order_map;

        private LayoutSortOrder(int n2) {
            this.value = n2;
        }

        static LayoutSortOrder valueToEnum(int n) {
            return layout_sort_order_map.get(n);
        }

        static {
            layout_sort_order_map = new HashMap();
            for (LayoutSortOrder layoutSortOrder : LayoutSortOrder.values()) {
                layout_sort_order_map.put(layoutSortOrder.value, layoutSortOrder);
            }
        }
    }
}

