/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.pdf;

import com.pdftron.common.PDFNetException;
import com.pdftron.pdf.OptionsBase;
import com.pdftron.sdf.Obj;
import java.util.HashMap;

public class FindReplaceOptions
extends OptionsBase {
    public FindReplaceOptions() throws PDFNetException {
    }

    public FindReplaceOptions(String string) throws PDFNetException {
        super(string);
    }

    @Override
    long getObjHandle() throws PDFNetException {
        return this.mDict.__GetHandle();
    }

    public HorizAlignment getAlignment() throws PDFNetException {
        Obj obj = this.mDict.findObj("Alignment");
        if (obj != null && !obj.isNull()) {
            return HorizAlignment.valueToEnum((int)obj.getNumber());
        }
        return HorizAlignment.valueToEnum(1);
    }

    public FindReplaceOptions setAlignment(HorizAlignment horizAlignment) throws PDFNetException {
        this.putNumber("Alignment", horizAlignment.value);
        return this;
    }

    public int getBatchSize() throws PDFNetException {
        Obj obj = this.mDict.findObj("BatchSize");
        if (obj != null && !obj.isNull()) {
            return (int)obj.getNumber();
        }
        return 20;
    }

    public FindReplaceOptions setBatchSize(int n) throws PDFNetException {
        this.putNumber("BatchSize", n);
        return this;
    }

    public boolean getMatchCase() throws PDFNetException {
        Obj obj = this.mDict.findObj("MatchCase");
        if (obj != null && !obj.isNull()) {
            return obj.getBool();
        }
        return false;
    }

    public FindReplaceOptions setMatchCase(boolean bl) throws PDFNetException {
        this.putBool("MatchCase", bl);
        return this;
    }

    public MatchType getMatchMode() throws PDFNetException {
        Obj obj = this.mDict.findObj("MatchMode");
        if (obj != null && !obj.isNull()) {
            return MatchType.valueToEnum((int)obj.getNumber());
        }
        return MatchType.valueToEnum(1);
    }

    public FindReplaceOptions setMatchMode(MatchType matchType) throws PDFNetException {
        this.putNumber("MatchMode", matchType.value);
        return this;
    }

    public String getPages() throws PDFNetException {
        Obj obj = this.mDict.findObj("Pages");
        if (obj != null && !obj.isNull()) {
            return obj.getAsPDFText();
        }
        return "";
    }

    public FindReplaceOptions setPages(String string) throws PDFNetException {
        this.putText("Pages", string);
        return this;
    }

    public ReflowType getReflowMode() throws PDFNetException {
        Obj obj = this.mDict.findObj("ReflowMode");
        if (obj != null && !obj.isNull()) {
            return ReflowType.valueToEnum((int)obj.getNumber());
        }
        return ReflowType.valueToEnum(3);
    }

    public FindReplaceOptions setReflowMode(ReflowType reflowType) throws PDFNetException {
        this.putNumber("ReflowMode", reflowType.value);
        return this;
    }

    public boolean getWholeWords() throws PDFNetException {
        Obj obj = this.mDict.findObj("WholeWords");
        if (obj != null && !obj.isNull()) {
            return obj.getBool();
        }
        return false;
    }

    public FindReplaceOptions setWholeWords(boolean bl) throws PDFNetException {
        this.putBool("WholeWords", bl);
        return this;
    }

    public static enum MatchType {
        e_exact(1),
        e_wildcards(2),
        e_regex(3);

        final int value;
        private static HashMap<Integer, MatchType> match_type_map;

        private MatchType(int n2) {
            this.value = n2;
        }

        static MatchType valueToEnum(int n) {
            return match_type_map.get(n);
        }

        static {
            match_type_map = new HashMap();
            for (MatchType matchType : MatchType.values()) {
                match_type_map.put(matchType.value, matchType);
            }
        }
    }

    public static enum ReflowType {
        e_text(1),
        e_line(2),
        e_para(3);

        final int value;
        private static HashMap<Integer, ReflowType> reflow_type_map;

        private ReflowType(int n2) {
            this.value = n2;
        }

        static ReflowType valueToEnum(int n) {
            return reflow_type_map.get(n);
        }

        static {
            reflow_type_map = new HashMap();
            for (ReflowType reflowType : ReflowType.values()) {
                reflow_type_map.put(reflowType.value, reflowType);
            }
        }
    }

    public static enum HorizAlignment {
        e_left(1),
        e_center(2),
        e_right(3),
        e_full(4);

        final int value;
        private static HashMap<Integer, HorizAlignment> horiz_alignment_map;

        private HorizAlignment(int n2) {
            this.value = n2;
        }

        static HorizAlignment valueToEnum(int n) {
            return horiz_alignment_map.get(n);
        }

        static {
            horiz_alignment_map = new HashMap();
            for (HorizAlignment horizAlignment : HorizAlignment.values()) {
                horiz_alignment_map.put(horizAlignment.value, horizAlignment);
            }
        }
    }
}

