/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.pdf;

import com.pdftron.common.PDFNetException;
import com.pdftron.fdf.FDFDoc;
import com.pdftron.filters.FileDescriptorFilter;
import com.pdftron.filters.FileDescriptorReadOnlyFilter;
import com.pdftron.filters.Filter;
import com.pdftron.filters.FilterReader;
import com.pdftron.filters.SecondaryFileFilter;
import com.pdftron.helpers.ReachabilityHelper;
import com.pdftron.pdf.Action;
import com.pdftron.pdf.Annot;
import com.pdftron.pdf.Bookmark;
import com.pdftron.pdf.DiffOptions;
import com.pdftron.pdf.DigitalSignatureField;
import com.pdftron.pdf.DigitalSignatureFieldIterator;
import com.pdftron.pdf.Field;
import com.pdftron.pdf.FieldIterator;
import com.pdftron.pdf.FileSpec;
import com.pdftron.pdf.MergeXFDFOptions;
import com.pdftron.pdf.PDFDocInfo;
import com.pdftron.pdf.PDFDocViewPrefs;
import com.pdftron.pdf.Page;
import com.pdftron.pdf.PageIterator;
import com.pdftron.pdf.PageLabel;
import com.pdftron.pdf.PageSet;
import com.pdftron.pdf.ProgressMonitor;
import com.pdftron.pdf.Rect;
import com.pdftron.pdf.RefreshOptions;
import com.pdftron.pdf.TextDiffOptions;
import com.pdftron.pdf.VerificationOptions;
import com.pdftron.pdf.ViewerOptimizedOptions;
import com.pdftron.pdf.ocg.Config;
import com.pdftron.pdf.struct.STree;
import com.pdftron.sdf.Doc;
import com.pdftron.sdf.Obj;
import com.pdftron.sdf.SDFDoc;
import com.pdftron.sdf.SecurityHandler;
import com.pdftron.sdf.SignatureHandler;
import com.pdftron.sdf.UndoManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;

public class PDFDoc
extends Doc
implements AutoCloseable {
    public static final int e_none = 0;
    public static final int e_insert_bookmark = 1;
    public static final int e_forms_only = 0;
    public static final int e_annots_only = 1;
    public static final int e_both = 2;
    public static final int e_annots_only_no_links = 5;
    public static final int e_flatten_forms_only = 1;
    public static final int e_flatten_annots_only = 2;
    public static final int e_flatten_link_only = 4;
    public static final int e_flatten_all = 8;
    public Filter mCustomFilter = null;
    private String mFilepath = null;
    public static final int e_action_trigger_doc_will_close = 17;
    public static final int e_action_trigger_doc_will_save = 18;
    public static final int e_action_trigger_doc_did_save = 19;
    public static final int e_action_trigger_doc_will_print = 20;
    public static final int e_action_trigger_doc_did_print = 21;

    public PDFDoc() throws PDFNetException {
        this.impl = PDFDoc.PDFDocCreate();
    }

    public PDFDoc(SDFDoc sDFDoc) throws PDFNetException {
        if (sDFDoc.__GetRefHandle() != null) {
            throw new PDFNetException("false", 78L, "PDFDoc.java", "PDFDoc(SDFDoc)", "SDFDoc is already owned by another document.");
        }
        this.impl = sDFDoc.__GetHandle();
        sDFDoc.__SetRef(this);
    }

    public PDFDoc(String string) throws PDFNetException {
        this.mFilepath = string;
        this.impl = PDFDoc.PDFDocCreate(string);
    }

    public PDFDoc(Filter filter) throws PDFNetException {
        this.mCustomFilter = filter;
        filter.__SetRefHandle(this);
        this.impl = PDFDoc.PDFDocCreateFilter(filter.__GetHandle());
        ReachabilityHelper.ensureReachable(filter);
    }

    public PDFDoc(byte[] byArray) throws PDFNetException {
        if (byArray == null) {
            throw new PDFNetException("", 0L, "PDFDoc.java", "PDFDoc(byte[])", "Memory buffer is null.");
        }
        this.impl = PDFDoc.PDFDocCreate(byArray);
    }

    public PDFDoc(InputStream inputStream) throws PDFNetException, IOException {
        this(inputStream, 0x100000);
    }

    public PDFDoc(InputStream inputStream, int n) throws PDFNetException, IOException {
        long l = 0L;
        try {
            int n2;
            l = PDFDoc.MemStreamCreateMemFilt(inputStream.available());
            byte[] byArray = new byte[n];
            while ((n2 = inputStream.read(byArray)) != -1) {
                PDFDoc.MemStreamWriteData(l, byArray, n2);
            }
            long l2 = l;
            l = 0L;
            this.impl = PDFDoc.MemStreamCreateDoc(l2);
        }
        catch (PDFNetException pDFNetException) {
            Filter filter = Filter.__Create(l, null);
            filter.destroy();
            throw pDFNetException;
        }
        catch (IOException iOException) {
            Filter filter = Filter.__Create(l, null);
            filter.destroy();
            throw iOException;
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    @Override
    public void close() throws PDFNetException {
        if (this.impl != 0L) {
            PDFDoc.Close(this.impl);
            this.impl = 0L;
            this.closeFilter();
            this.mCustomFilter = null;
            this.mFilepath = null;
        }
    }

    private void closeFilter() throws PDFNetException {
        if (this.mCustomFilter != null) {
            if (this.mCustomFilter instanceof FileDescriptorFilter) {
                ((FileDescriptorFilter)this.mCustomFilter).close();
            } else if (this.mCustomFilter instanceof FileDescriptorReadOnlyFilter) {
                ((FileDescriptorReadOnlyFilter)this.mCustomFilter).close();
            } else if (this.mCustomFilter instanceof SecondaryFileFilter) {
                ((SecondaryFileFilter)this.mCustomFilter).close();
            }
        }
    }

    public Obj getTriggerAction(int n) throws PDFNetException {
        return Obj.__Create(PDFDoc.GetTriggerAction(this.impl, n), this);
    }

    public Obj getTriggerAction(ActionTriggerMode actionTriggerMode) throws PDFNetException {
        return Obj.__Create(PDFDoc.GetTriggerAction(this.impl, actionTriggerMode.getValue()), this);
    }

    public boolean isEncrypted() throws PDFNetException {
        return PDFDoc.IsEncrypted(this.impl);
    }

    public boolean initSecurityHandler() throws PDFNetException {
        return PDFDoc.InitSecurityHandler(this.impl, null);
    }

    public boolean initSecurityHandler(Object object) throws PDFNetException {
        return PDFDoc.InitSecurityHandler(this.impl, object);
    }

    public boolean initStdSecurityHandler(String string) throws PDFNetException {
        return PDFDoc.InitStdSecurityHandler(this.impl, string);
    }

    public boolean initStdSecurityHandler(byte[] byArray) throws PDFNetException {
        return PDFDoc.InitStdSecurityHandlerBuffer(this.impl, byArray);
    }

    public SecurityHandler getSecurityHandler() {
        SecurityHandler securityHandler = SecurityHandler.__Create(PDFDoc.GetSecurityHandler(this.impl), this);
        if (securityHandler.__GetHandle() == 0L) {
            return null;
        }
        return securityHandler;
    }

    public void setSecurityHandler(SecurityHandler securityHandler) {
        PDFDoc.SetSecurityHandler(this.impl, securityHandler.__GetHandle());
        securityHandler.__SetRefHandle(this);
    }

    public PDFDocInfo getDocInfo() throws PDFNetException {
        return new PDFDocInfo(PDFDoc.GetDocInfo(this.impl), this);
    }

    public PDFDocViewPrefs getViewPrefs() throws PDFNetException {
        return new PDFDocViewPrefs(PDFDoc.GetViewPrefs(this.impl), this);
    }

    public boolean isModified() throws PDFNetException {
        return PDFDoc.IsModified(this.impl);
    }

    public boolean hasChangesSinceSnapshot() throws PDFNetException {
        return PDFDoc.HasChangesSinceSnapshot(this.impl);
    }

    public boolean hasRepairedXRef() throws PDFNetException {
        return PDFDoc.HasRepairedXRef(this.impl);
    }

    public boolean isLinearized() throws PDFNetException {
        return PDFDoc.IsLinearized(this.impl);
    }

    public void save(String string, long l, ProgressMonitor progressMonitor) throws PDFNetException {
        PDFDoc.Save(this.impl, string, l, progressMonitor);
    }

    public void save(String string, SDFDoc.SaveMode saveMode, ProgressMonitor progressMonitor) throws PDFNetException {
        this.save(string, (long)saveMode.getValue(), progressMonitor);
    }

    public void save(String string, SDFDoc.SaveMode[] saveModeArray, ProgressMonitor progressMonitor) throws PDFNetException {
        long l = 0L;
        if (saveModeArray != null) {
            for (SDFDoc.SaveMode saveMode : saveModeArray) {
                l |= (long)saveMode.getValue();
            }
        }
        this.save(string, l, progressMonitor);
    }

    public byte[] save(long l, ProgressMonitor progressMonitor) throws PDFNetException {
        return PDFDoc.Save(this.impl, l, progressMonitor);
    }

    public byte[] save(SDFDoc.SaveMode saveMode, ProgressMonitor progressMonitor) throws PDFNetException {
        return this.save(saveMode.getValue(), progressMonitor);
    }

    public byte[] save(SDFDoc.SaveMode[] saveModeArray, ProgressMonitor progressMonitor) throws PDFNetException {
        long l = 0L;
        if (saveModeArray != null) {
            for (SDFDoc.SaveMode saveMode : saveModeArray) {
                l |= (long)saveMode.getValue();
            }
        }
        return this.save(l, progressMonitor);
    }

    public void save(OutputStream outputStream, long l, ProgressMonitor progressMonitor) throws PDFNetException, IOException {
        this.save(outputStream, l, progressMonitor, 0x100000);
    }

    public void save(OutputStream outputStream, SDFDoc.SaveMode saveMode, ProgressMonitor progressMonitor) throws PDFNetException, IOException {
        this.save(outputStream, saveMode.getValue(), progressMonitor, 0x100000);
    }

    public void save(OutputStream outputStream, SDFDoc.SaveMode[] saveModeArray, ProgressMonitor progressMonitor) throws PDFNetException, IOException {
        long l = 0L;
        if (saveModeArray != null) {
            for (SDFDoc.SaveMode saveMode : saveModeArray) {
                l |= (long)saveMode.getValue();
            }
        }
        this.save(outputStream, l, progressMonitor, 0x100000);
    }

    public void save(OutputStream outputStream, long l, ProgressMonitor progressMonitor, int n) throws PDFNetException, IOException {
        long l2;
        long[] lArray = PDFDoc.SaveStream(this.impl, l, progressMonitor);
        long l3 = lArray[1];
        byte[] byArray = new byte[n];
        long l4 = l3 - (long)n;
        for (l2 = lArray[0]; l2 < l4; l2 += (long)n) {
            PDFDoc.ReadData(byArray, n, l2);
            outputStream.write(byArray);
        }
        int n2 = (int)(l3 - l2);
        if (n2 > 0) {
            PDFDoc.ReadData(byArray, n2, l2);
            outputStream.write(byArray, 0, n2);
        }
    }

    public void save(OutputStream outputStream, SDFDoc.SaveMode saveMode, ProgressMonitor progressMonitor, int n) throws PDFNetException, IOException {
        this.save(outputStream, saveMode.getValue(), progressMonitor, n);
    }

    public void save(OutputStream outputStream, SDFDoc.SaveMode[] saveModeArray, ProgressMonitor progressMonitor, int n) throws PDFNetException, IOException {
        long l = 0L;
        if (saveModeArray != null) {
            for (SDFDoc.SaveMode saveMode : saveModeArray) {
                l |= (long)saveMode.getValue();
            }
        }
        this.save(outputStream, l, progressMonitor, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Filter filter, long l) throws PDFNetException, IOException {
        if (filter instanceof FileDescriptorFilter && filter.isInputFilter() && ((FileDescriptorFilter)filter).canWriteOnInputFilter()) {
            FileDescriptorFilter fileDescriptorFilter = ((FileDescriptorFilter)filter).createOutputIterator();
            if (fileDescriptorFilter != null && !fileDescriptorFilter.isInputFilter()) {
                PDFDoc.SaveCustomFilter(this.impl, fileDescriptorFilter.__GetHandle(), l);
            }
            ReachabilityHelper.ensureReachable(fileDescriptorFilter);
            this.closeFilter();
            this.mCustomFilter = filter;
            filter.__SetRefHandle(this);
        } else if (filter instanceof SecondaryFileFilter && filter.isInputFilter()) {
            SecondaryFileFilter secondaryFileFilter = ((SecondaryFileFilter)filter).createOutputIterator();
            if (secondaryFileFilter != null && !secondaryFileFilter.isInputFilter()) {
                try {
                    PDFDoc.SaveCustomFilter(this.impl, secondaryFileFilter.__GetHandle(), l);
                }
                finally {
                    secondaryFileFilter.close();
                }
            }
        } else if (!filter.isInputFilter()) {
            PDFDoc.SaveCustomFilter(this.impl, filter.__GetHandle(), l);
            ReachabilityHelper.ensureReachable(filter);
        } else {
            throw new PDFNetException("false", 568L, "PDFDoc.java", "PDFDoc(save)", "The filter is not an output filter.");
        }
    }

    public void save(Filter filter, SDFDoc.SaveMode saveMode) throws PDFNetException, IOException {
        this.save(filter, saveMode.getValue());
    }

    public void save(Filter filter, SDFDoc.SaveMode[] saveModeArray) throws PDFNetException, IOException {
        long l = 0L;
        if (saveModeArray != null) {
            for (SDFDoc.SaveMode saveMode : saveModeArray) {
                l |= (long)saveMode.getValue();
            }
        }
        this.save(filter, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void save(long l) throws PDFNetException, IOException {
        if (l != 32769L) {
            throw new PDFNetException("false", 1082L, "PDFDoc.java", "PDFDoc(save)", "This flag is not supported.");
        }
        if (this.mCustomFilter != null && this.mCustomFilter instanceof FileDescriptorFilter) {
            FileDescriptorFilter fileDescriptorFilter = ((FileDescriptorFilter)this.mCustomFilter).createOutputIterator();
            if (fileDescriptorFilter == null || fileDescriptorFilter.isInputFilter()) throw new PDFNetException("false", 1092L, "PDFDoc.java", "PDFDoc.save(long)", "The filter is not an output filter.");
            long l2 = PDFDoc.SaveCustomFilter2(this.impl, fileDescriptorFilter.__GetHandle(), l);
            this.mCustomFilter = FileDescriptorFilter.__Create(l2, fileDescriptorFilter);
            return;
        }
        if (this.mCustomFilter == null || !(this.mCustomFilter instanceof SecondaryFileFilter)) throw new PDFNetException("false", 1110L, "PDFDoc.java", "PDFDoc(save)", "Custom filter is not valid.");
        SecondaryFileFilter secondaryFileFilter = ((SecondaryFileFilter)this.mCustomFilter).createOutputIterator();
        if (secondaryFileFilter == null || secondaryFileFilter.isInputFilter()) throw new PDFNetException("false", 1105L, "PDFDoc.java", "PDFDoc.save(long)", "The filter is not an output filter.");
        try {
            PDFDoc.SaveCustomFilter2(this.impl, secondaryFileFilter.__GetHandle(), l);
            return;
        }
        finally {
            secondaryFileFilter.close();
        }
    }

    public void save() throws PDFNetException, IOException {
        if (this.mFilepath != null) {
            PDFDoc.Save(this.impl, this.mFilepath, 1L, null);
        } else {
            this.save(32769L);
        }
    }

    public boolean saveIncrementalData(String string) throws PDFNetException {
        return PDFDoc.SaveIncrementalData(this.impl, string);
    }

    public void saveCustomSignature(byte[] byArray, DigitalSignatureField digitalSignatureField, String string) throws PDFNetException, IOException {
        PDFDoc.SaveCustomSignaturePath(this.impl, byArray, digitalSignatureField.__GetHandle(), string);
        ReachabilityHelper.ensureReachable(digitalSignatureField);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveCustomSignature(byte[] byArray, DigitalSignatureField digitalSignatureField, Filter filter) throws PDFNetException, IOException {
        if (filter instanceof FileDescriptorFilter && filter.isInputFilter() && ((FileDescriptorFilter)filter).canWriteOnInputFilter()) {
            FileDescriptorFilter fileDescriptorFilter = ((FileDescriptorFilter)filter).createOutputIterator();
            if (fileDescriptorFilter != null && !fileDescriptorFilter.isInputFilter()) {
                PDFDoc.SaveCustomSignatureCustomFilter(this.impl, byArray, digitalSignatureField.__GetHandle(), fileDescriptorFilter.__GetHandle());
            }
            ReachabilityHelper.ensureReachable(fileDescriptorFilter);
            this.closeFilter();
            this.mCustomFilter = filter;
            filter.__SetRefHandle(this);
        } else if (filter instanceof SecondaryFileFilter && filter.isInputFilter()) {
            SecondaryFileFilter secondaryFileFilter = ((SecondaryFileFilter)filter).createOutputIterator();
            if (secondaryFileFilter != null && !secondaryFileFilter.isInputFilter()) {
                try {
                    PDFDoc.SaveCustomSignatureCustomFilter(this.impl, byArray, digitalSignatureField.__GetHandle(), secondaryFileFilter.__GetHandle());
                }
                finally {
                    secondaryFileFilter.close();
                }
            }
        } else if (!filter.isInputFilter()) {
            PDFDoc.SaveCustomSignatureCustomFilter(this.impl, byArray, digitalSignatureField.__GetHandle(), filter.__GetHandle());
            ReachabilityHelper.ensureReachable(filter);
        } else {
            throw new PDFNetException("false", 1204L, "PDFDoc.java", "PDFDoc(saveCustomSignature)", "The filter is not an output filter.");
        }
        ReachabilityHelper.ensureReachable(digitalSignatureField);
    }

    public PageIterator getPageIterator() throws PDFNetException {
        return new PageIterator(PDFDoc.GetPageIteratorBegin(this.impl), this);
    }

    public PageIterator getPageIterator(int n) throws PDFNetException {
        return new PageIterator(PDFDoc.GetPageIterator(this.impl, n), this);
    }

    public Page getPage(int n) throws PDFNetException {
        long l = PDFDoc.GetPage(this.impl, n);
        if (l != 0L) {
            return new Page(l, this);
        }
        return null;
    }

    public void pageRemove(PageIterator pageIterator) throws PDFNetException {
        PDFDoc.PageRemove(this.impl, pageIterator.__GetHandle());
        ReachabilityHelper.ensureReachable(pageIterator);
    }

    public void pageInsert(PageIterator pageIterator, Page page) throws PDFNetException {
        PDFDoc.PageInsert(this.impl, pageIterator.__GetHandle(), page.impl);
        ReachabilityHelper.ensureReachable(pageIterator);
        ReachabilityHelper.ensureReachable(page);
    }

    public void insertPages(int n, PDFDoc pDFDoc, int n2, int n3, int n4, ProgressMonitor progressMonitor) throws PDFNetException {
        PageSet pageSet = new PageSet();
        pageSet.addRange(n2, n3);
        this.insertPages(n, pDFDoc, pageSet, n4, progressMonitor);
        pageSet.destroy();
    }

    public void insertPages(int n, PDFDoc pDFDoc, int n2, int n3, InsertBookmarkMode insertBookmarkMode, ProgressMonitor progressMonitor) throws PDFNetException {
        this.insertPages(n, pDFDoc, n2, n3, insertBookmarkMode.getValue(), progressMonitor);
    }

    public void insertPages(int n, PDFDoc pDFDoc, PageSet pageSet, int n2, ProgressMonitor progressMonitor) throws PDFNetException {
        PDFDoc.InsertPageSet(this.impl, n, pDFDoc.impl, pageSet.impl, n2, progressMonitor);
        ReachabilityHelper.ensureReachable(pageSet);
        ReachabilityHelper.ensureReachable(pDFDoc);
    }

    public void insertPages(int n, PDFDoc pDFDoc, PageSet pageSet, InsertBookmarkMode insertBookmarkMode, ProgressMonitor progressMonitor) throws PDFNetException {
        this.insertPages(n, pDFDoc, pageSet, insertBookmarkMode.getValue(), progressMonitor);
    }

    public void movePages(int n, PDFDoc pDFDoc, int n2, int n3, int n4, ProgressMonitor progressMonitor) throws PDFNetException {
        PageSet pageSet = new PageSet();
        pageSet.addRange(n2, n3);
        this.movePages(n, pDFDoc, pageSet, n4, progressMonitor);
        pageSet.destroy();
    }

    public void movePages(int n, PDFDoc pDFDoc, int n2, int n3, InsertBookmarkMode insertBookmarkMode, ProgressMonitor progressMonitor) throws PDFNetException {
        this.movePages(n, pDFDoc, n2, n3, insertBookmarkMode.getValue(), progressMonitor);
    }

    public void movePages(int n, PDFDoc pDFDoc, PageSet pageSet, int n2, ProgressMonitor progressMonitor) throws PDFNetException {
        PDFDoc.MovePageSet(this.impl, n, pDFDoc.impl, pageSet.impl, n2, progressMonitor);
        ReachabilityHelper.ensureReachable(pageSet);
        ReachabilityHelper.ensureReachable(pDFDoc);
    }

    public void movePages(int n, PDFDoc pDFDoc, PageSet pageSet, InsertBookmarkMode insertBookmarkMode, ProgressMonitor progressMonitor) throws PDFNetException {
        PDFDoc.MovePageSet(this.impl, n, pDFDoc.impl, pageSet.impl, insertBookmarkMode.getValue(), progressMonitor);
        ReachabilityHelper.ensureReachable(pageSet);
        ReachabilityHelper.ensureReachable(pDFDoc);
    }

    public void pagePushFront(Page page) throws PDFNetException {
        PDFDoc.PagePushFront(this.impl, page.impl);
        ReachabilityHelper.ensureReachable(page);
    }

    public void pagePushBack(Page page) throws PDFNetException {
        PDFDoc.PagePushBack(this.impl, page.impl);
        ReachabilityHelper.ensureReachable(page);
    }

    public Page[] importPages(Page[] pageArray) throws PDFNetException {
        return this.importPages(pageArray, false);
    }

    public Page[] importPages(Page[] pageArray, boolean bl) throws PDFNetException {
        long[] lArray = new long[pageArray.length];
        for (int i = 0; i < pageArray.length; ++i) {
            lArray[i] = pageArray[i].impl;
        }
        long[] lArray2 = PDFDoc.ImportPages(this.impl, lArray, bl);
        Page[] pageArray2 = new Page[lArray2.length];
        for (int i = 0; i < lArray2.length; ++i) {
            pageArray2[i] = new Page(lArray2[i], this);
        }
        ReachabilityHelper.ensureReachable(pageArray);
        return pageArray2;
    }

    public int appendTextDiff(Page page, Page page2) throws PDFNetException {
        int n = PDFDoc.AppendTextDiffPage(this.impl, page.impl, page2.impl);
        ReachabilityHelper.ensureReachable(page);
        ReachabilityHelper.ensureReachable(page2);
        return n;
    }

    public int appendTextDiff(PDFDoc pDFDoc, PDFDoc pDFDoc2) throws PDFNetException {
        int n = PDFDoc.AppendTextDiffDoc(this.impl, pDFDoc.__GetHandle(), pDFDoc2.__GetHandle(), 0L);
        ReachabilityHelper.ensureReachable(pDFDoc);
        ReachabilityHelper.ensureReachable(pDFDoc2);
        return n;
    }

    public int appendTextDiff(PDFDoc pDFDoc, PDFDoc pDFDoc2, TextDiffOptions textDiffOptions) throws PDFNetException {
        int n = PDFDoc.AppendTextDiffDoc(this.impl, pDFDoc.__GetHandle(), pDFDoc2.__GetHandle(), textDiffOptions == null ? 0L : textDiffOptions.getObjHandle());
        ReachabilityHelper.ensureReachable(pDFDoc);
        ReachabilityHelper.ensureReachable(pDFDoc2);
        ReachabilityHelper.ensureReachable(textDiffOptions);
        return n;
    }

    public static int highlightTextDiff(PDFDoc pDFDoc, PDFDoc pDFDoc2, TextDiffOptions textDiffOptions) throws PDFNetException {
        int n = PDFDoc.HighlightTextDiff(pDFDoc.__GetHandle(), pDFDoc2.__GetHandle(), textDiffOptions == null ? 0L : textDiffOptions.getObjHandle());
        ReachabilityHelper.ensureReachable(pDFDoc);
        ReachabilityHelper.ensureReachable(pDFDoc2);
        ReachabilityHelper.ensureReachable(textDiffOptions);
        return n;
    }

    public Page pageCreate() throws PDFNetException {
        return this.pageCreate(new Rect(0.0, 0.0, 612.0, 792.0));
    }

    public Page pageCreate(Rect rect) throws PDFNetException {
        Page page = new Page(PDFDoc.PageCreate(this.impl, rect.impl), this);
        ReachabilityHelper.ensureReachable(rect);
        return page;
    }

    public Bookmark getFirstBookmark() throws PDFNetException {
        return new Bookmark(PDFDoc.GetFirstBookmark(this.impl), this);
    }

    public void addRootBookmark(Bookmark bookmark) throws PDFNetException {
        PDFDoc.AddRootBookmark(this.impl, bookmark.impl);
        ReachabilityHelper.ensureReachable(bookmark);
    }

    public Obj getTrailer() throws PDFNetException {
        return Obj.__Create(PDFDoc.GetTrailer(this.impl), this);
    }

    public Obj getRoot() throws PDFNetException {
        return Obj.__Create(PDFDoc.GetRoot(this.impl), this);
    }

    public void initializeJSContext() throws PDFNetException {
        PDFDoc.JSContextInitialize(this.impl);
    }

    public Obj getPages() throws PDFNetException {
        return Obj.__Create(PDFDoc.GetPages(this.impl), this);
    }

    public int getPageCount() throws PDFNetException {
        return PDFDoc.GetPagesCount(this.impl);
    }

    public FieldIterator getFieldIterator() throws PDFNetException {
        return new FieldIterator(PDFDoc.GetFieldIteratorBegin(this.impl), this);
    }

    public FieldIterator getFieldIterator(String string) throws PDFNetException {
        return new FieldIterator(PDFDoc.GetFieldIterator(this.impl, string), this);
    }

    public Field getField(String string) throws PDFNetException {
        long l = PDFDoc.GetField(this.impl, string);
        if (l != 0L) {
            return new Field(l, this);
        }
        return null;
    }

    public Field fieldCreate(String string, int n) throws PDFNetException {
        return new Field(PDFDoc.FieldCreate(this.impl, string, n, 0L, 0L), this);
    }

    public Field fieldCreate(String string, int n, Obj obj) throws PDFNetException {
        Field field = new Field(PDFDoc.FieldCreate(this.impl, string, n, obj.__GetHandle(), 0L), this);
        ReachabilityHelper.ensureReachable(obj);
        return field;
    }

    public Field fieldCreate(String string, int n, Obj obj, Obj obj2) throws PDFNetException {
        Field field = new Field(PDFDoc.FieldCreate(this.impl, string, n, obj.__GetHandle(), obj2.__GetHandle()), this);
        ReachabilityHelper.ensureReachable(obj);
        ReachabilityHelper.ensureReachable(obj2);
        return field;
    }

    public Field fieldCreate(String string, int n, String string2, String string3) throws PDFNetException {
        return new Field(PDFDoc.FieldCreate(this.impl, string, n, string2, string3), this);
    }

    public Field fieldCreate(String string, int n, String string2) throws PDFNetException {
        return new Field(PDFDoc.FieldCreate(this.impl, string, n, string2, ""), this);
    }

    public void refreshFieldAppearances() throws PDFNetException {
        PDFDoc.RefreshFieldAppearances(this.impl);
    }

    public void refreshAnnotAppearances() throws PDFNetException {
        PDFDoc.RefreshAnnotAppearances(this.impl, 0L);
    }

    public void refreshAnnotAppearances(RefreshOptions refreshOptions) throws PDFNetException {
        PDFDoc.RefreshAnnotAppearances(this.impl, refreshOptions != null ? refreshOptions.getObjHandle() : 0L);
        ReachabilityHelper.ensureReachable(refreshOptions);
    }

    public void flattenAnnotations(boolean bl) throws PDFNetException {
        PDFDoc.FlattenAnnotations(this.impl, bl);
    }

    public void flattenAnnotations() throws PDFNetException {
        PDFDoc.FlattenAnnotations(this.impl, false);
    }

    public void flattenAnnotationsAdvanced(long l) throws PDFNetException {
        PDFDoc.FlattenAnnotationsAdvanced(this.impl, l);
    }

    public void flattenAnnotationsAdvanced(FlattenMode[] flattenModeArray) throws PDFNetException {
        long l = 0L;
        if (flattenModeArray != null) {
            for (FlattenMode flattenMode : flattenModeArray) {
                l |= (long)flattenMode.getValue();
            }
        }
        PDFDoc.FlattenAnnotationsAdvanced(this.impl, l);
    }

    public Obj getAcroForm() throws PDFNetException {
        return Obj.__Create(PDFDoc.GetAcroForm(this.impl), this);
    }

    public FDFDoc fdfExtract() throws PDFNetException {
        return FDFDoc.__Create(PDFDoc.FDFExtract(this.impl, 0));
    }

    public FDFDoc fdfExtract(int n) throws PDFNetException {
        return FDFDoc.__Create(PDFDoc.FDFExtract(this.impl, n));
    }

    public FDFDoc fdfExtract(PageSet pageSet, int n) throws PDFNetException {
        FDFDoc fDFDoc = FDFDoc.__Create(PDFDoc.FDFExtract(this.impl, pageSet.impl, n));
        ReachabilityHelper.ensureReachable(pageSet);
        return fDFDoc;
    }

    public FDFDoc fdfExtract(ArrayList<Annot> arrayList) throws PDFNetException {
        long[] lArray = new long[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            Annot annot = arrayList.get(i);
            lArray[i] = annot.getSDFObj().__GetHandle();
        }
        FDFDoc fDFDoc = FDFDoc.__Create(PDFDoc.FDFExtract(this.impl, lArray));
        ReachabilityHelper.ensureReachable(arrayList);
        return fDFDoc;
    }

    public FDFDoc fdfExtract(Annot[] annotArray) throws PDFNetException {
        long[] lArray = new long[annotArray.length];
        for (int i = 0; i < annotArray.length; ++i) {
            lArray[i] = annotArray[i].getSDFObj().__GetHandle();
        }
        FDFDoc fDFDoc = FDFDoc.__Create(PDFDoc.FDFExtract(this.impl, lArray));
        ReachabilityHelper.ensureReachable(annotArray);
        return fDFDoc;
    }

    public FDFDoc fdfExtract(ArrayList<Annot> arrayList, ArrayList<Annot> arrayList2, ArrayList<Annot> arrayList3) throws PDFNetException {
        if (arrayList == null) {
            arrayList = new ArrayList(0);
        }
        if (arrayList2 == null) {
            arrayList2 = new ArrayList(0);
        }
        if (arrayList3 == null) {
            arrayList3 = new ArrayList(0);
        }
        long[] lArray = new long[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            Annot annot = arrayList.get(i);
            lArray[i] = annot.getSDFObj().__GetHandle();
        }
        long[] lArray2 = new long[arrayList2.size()];
        for (int i = 0; i < arrayList2.size(); ++i) {
            Annot annot = arrayList2.get(i);
            lArray2[i] = annot.getSDFObj().__GetHandle();
        }
        long[] lArray3 = new long[arrayList3.size()];
        for (int i = 0; i < arrayList3.size(); ++i) {
            Annot annot = arrayList3.get(i);
            lArray3[i] = annot.getSDFObj().__GetHandle();
        }
        FDFDoc fDFDoc = FDFDoc.__Create(PDFDoc.FDFExtract(this.impl, lArray, lArray2, lArray3));
        ReachabilityHelper.ensureReachable(arrayList);
        ReachabilityHelper.ensureReachable(arrayList2);
        ReachabilityHelper.ensureReachable(arrayList3);
        return fDFDoc;
    }

    public void fdfMerge(FDFDoc fDFDoc) throws PDFNetException {
        PDFDoc.FDFMerge(this.impl, fDFDoc.__GetHandle());
        ReachabilityHelper.ensureReachable(fDFDoc);
    }

    public void fdfUpdate(FDFDoc fDFDoc) throws PDFNetException {
        PDFDoc.FDFUpdate(this.impl, fDFDoc.__GetHandle());
        ReachabilityHelper.ensureReachable(fDFDoc);
    }

    public void mergeXFDF(Filter filter, String string) throws PDFNetException {
        PDFDoc.MergeXFDF_old(this.impl, filter.__GetHandle(), string);
        ReachabilityHelper.ensureReachable(filter);
    }

    public void mergeXFDF(Filter filter, MergeXFDFOptions mergeXFDFOptions) throws PDFNetException {
        PDFDoc.MergeXFDF(this.impl, filter.__GetHandle(), mergeXFDFOptions != null ? mergeXFDFOptions.getObjHandle() : 0L);
        ReachabilityHelper.ensureReachable(mergeXFDFOptions);
        ReachabilityHelper.ensureReachable(filter);
    }

    public void mergeXFDFString(String string, String string2) throws PDFNetException {
        PDFDoc.MergeXFDFString_old(this.impl, string, string2);
    }

    public void mergeXFDFString(String string, MergeXFDFOptions mergeXFDFOptions) throws PDFNetException {
        PDFDoc.MergeXFDFString(this.impl, string, mergeXFDFOptions != null ? mergeXFDFOptions.getObjHandle() : 0L);
        ReachabilityHelper.ensureReachable(mergeXFDFOptions);
    }

    public Action getOpenAction() throws PDFNetException {
        return new Action(PDFDoc.GetOpenAction(this.impl), this);
    }

    public void setOpenAction(Action action) throws PDFNetException {
        PDFDoc.SetOpenAction(this.impl, action.impl);
        ReachabilityHelper.ensureReachable(action);
    }

    public void addFileAttachment(String string, FileSpec fileSpec) throws PDFNetException {
        PDFDoc.AddFileAttachment(this.impl, string, fileSpec.impl);
        ReachabilityHelper.ensureReachable(fileSpec);
    }

    public PageLabel getPageLabel(int n) throws PDFNetException {
        return new PageLabel(PDFDoc.GetPageLabel(this.impl, n), this);
    }

    public void setPageLabel(int n, PageLabel pageLabel) throws PDFNetException {
        PDFDoc.SetPageLabel(this.impl, n, pageLabel.impl);
        ReachabilityHelper.ensureReachable(pageLabel);
    }

    public void removePageLabel(int n) throws PDFNetException {
        PDFDoc.RemovePageLabel(this.impl, n);
    }

    public STree getStructTree() throws PDFNetException {
        return STree.__Create(PDFDoc.GetStructTree(this.impl), this);
    }

    public boolean hasOC() throws PDFNetException {
        return PDFDoc.HasOC(this.impl);
    }

    public Obj getOCGs() throws PDFNetException {
        return Obj.__Create(PDFDoc.GetOCGs(this.impl), this);
    }

    public Config getOCGConfig() throws PDFNetException {
        return Config.__Create(PDFDoc.GetOCGConfig(this.impl), this);
    }

    public Obj createIndirectName(String string) throws PDFNetException {
        return Obj.__Create(PDFDoc.CreateIndirectName(this.impl, string), this);
    }

    public Obj createIndirectArray() throws PDFNetException {
        return Obj.__Create(PDFDoc.CreateIndirectArray(this.impl), this);
    }

    public Obj createIndirectBool(boolean bl) throws PDFNetException {
        return Obj.__Create(PDFDoc.CreateIndirectBool(this.impl, bl), this);
    }

    public Obj createIndirectDict() throws PDFNetException {
        return Obj.__Create(PDFDoc.CreateIndirectDict(this.impl), this);
    }

    public Obj createIndirectNull() throws PDFNetException {
        return Obj.__Create(PDFDoc.CreateIndirectNull(this.impl), this);
    }

    public Obj createIndirectNumber(double d) throws PDFNetException {
        return Obj.__Create(PDFDoc.CreateIndirectNumber(this.impl, d), this);
    }

    public Obj createIndirectString(byte[] byArray) throws PDFNetException {
        return Obj.__Create(PDFDoc.CreateIndirectString(this.impl, byArray), this);
    }

    public Obj createIndirectString(String string) throws PDFNetException {
        return Obj.__Create(PDFDoc.CreateIndirectString(this.impl, string), this);
    }

    public Obj createIndirectStream(FilterReader filterReader) throws PDFNetException {
        Obj obj = Obj.__Create(PDFDoc.CreateIndirectStream(this.impl, filterReader.__GetHandle(), 0L), this);
        ReachabilityHelper.ensureReachable(filterReader);
        return obj;
    }

    public Obj createIndirectStream(FilterReader filterReader, Filter filter) throws PDFNetException {
        if (filter != null) {
            filter.__SetRefHandle(this);
        }
        Obj obj = Obj.__Create(PDFDoc.CreateIndirectStream(this.impl, filterReader.__GetHandle(), filter.__GetHandle()), this);
        ReachabilityHelper.ensureReachable(filterReader);
        ReachabilityHelper.ensureReachable(filter);
        return obj;
    }

    public Obj createIndirectStream(byte[] byArray) throws PDFNetException {
        return Obj.__Create(PDFDoc.CreateIndirectStream(this.impl, byArray, 0L), this);
    }

    public Obj createIndirectStream(byte[] byArray, Filter filter) throws PDFNetException {
        if (filter != null) {
            filter.__SetRefHandle(this);
        }
        Obj obj = Obj.__Create(PDFDoc.CreateIndirectStream(this.impl, byArray, filter.__GetHandle()), this);
        ReachabilityHelper.ensureReachable(filter);
        return obj;
    }

    public SDFDoc getSDFDoc() {
        return SDFDoc.__Create(this.impl, this);
    }

    public void lock() throws PDFNetException {
        PDFDoc.Lock(this.impl);
    }

    public void unlock() throws PDFNetException {
        PDFDoc.Unlock(this.impl);
    }

    public boolean tryLock() throws PDFNetException {
        return PDFDoc.TryLock(this.impl, 0);
    }

    public boolean timedLock(int n) throws PDFNetException {
        return PDFDoc.TryLock(this.impl, n);
    }

    public void lockRead() throws PDFNetException {
        PDFDoc.LockRead(this.impl);
    }

    public void unlockRead() throws PDFNetException {
        PDFDoc.UnlockRead(this.impl);
    }

    public boolean tryLockRead() throws PDFNetException {
        return PDFDoc.TryLockRead(this.impl, 0);
    }

    public boolean timedLockRead(int n) throws PDFNetException {
        return PDFDoc.TryLockRead(this.impl, n);
    }

    public String getFileName() throws PDFNetException {
        return PDFDoc.GetFileName(this.impl);
    }

    public void generateThumbnails(long l) throws PDFNetException {
        PDFDoc.GenerateThumbnails(this.impl, l);
    }

    public void appendVisualDiff(Page page, Page page2, DiffOptions diffOptions) throws PDFNetException {
        PDFDoc.AppendVisualDiff(this.impl, page != null ? page.impl : 0L, page2 != null ? page2.impl : 0L, diffOptions != null ? diffOptions.getObjHandle() : 0L);
        ReachabilityHelper.ensureReachable(diffOptions);
        ReachabilityHelper.ensureReachable(page);
        ReachabilityHelper.ensureReachable(page2);
    }

    public long getDownloadedByteCount() throws PDFNetException {
        return PDFDoc.GetDownloadedByteCount(this.impl);
    }

    public long getTotalRemoteByteCount() throws PDFNetException {
        return PDFDoc.GetTotalRemoteByteCount(this.impl);
    }

    public boolean hasDownloader() throws PDFNetException {
        return PDFDoc.HasDownloader(this.impl);
    }

    public UndoManager getUndoManager() throws PDFNetException {
        return new UndoManager(PDFDoc.GetUndoManager(this.impl));
    }

    public void removeSecurity() {
        PDFDoc.RemoveSecurity(this.impl);
    }

    public void addHighlights(String string) {
        PDFDoc.AddHighlights(this.impl, string);
    }

    public boolean isTagged() {
        return PDFDoc.IsTagged(this.impl);
    }

    public boolean hasSignatures() {
        return PDFDoc.HasSignatures(this.impl);
    }

    public long addSignatureHandler(SignatureHandler signatureHandler) throws PDFNetException {
        return PDFDoc.AddSignatureHandler(this.impl, signatureHandler);
    }

    public long addStdSignatureHandler(String string, String string2) throws PDFNetException {
        return PDFDoc.AddStdSignatureHandlerFromFile(this.impl, string, string2);
    }

    public long addStdSignatureHandler(byte[] byArray, String string) throws PDFNetException {
        return PDFDoc.AddStdSignatureHandlerFromBuffer(this.impl, byArray, string);
    }

    public void removeSignatureHandler(long l) throws PDFNetException {
        PDFDoc.RemoveSignatureHandler(this.impl, l);
    }

    public SignatureHandler getSignatureHandler(long l) throws PDFNetException {
        return PDFDoc.GetSignatureHandler(this.impl, l);
    }

    public DigitalSignatureField createDigitalSignatureField(String string) throws PDFNetException {
        return new DigitalSignatureField(PDFDoc.CreateDigitalSignatureField(this.impl, string), this);
    }

    public DigitalSignatureField createDigitalSignatureField() throws PDFNetException {
        return new DigitalSignatureField(PDFDoc.CreateDigitalSignatureField(this.impl), this);
    }

    public DigitalSignatureFieldIterator getDigitalSignatureFieldIterator() throws PDFNetException {
        return new DigitalSignatureFieldIterator(PDFDoc.GetDigitalSignatureFieldIteratorBegin(this.impl), this);
    }

    public DigitalSignatureField.DocumentPermissions getDigitalSignaturePermissions() throws PDFNetException {
        return DigitalSignatureField.DocumentPermissions.valueToEnum(PDFDoc.GetDigitalSignaturePermissions(this.impl));
    }

    public void saveViewerOptimized(String string, ViewerOptimizedOptions viewerOptimizedOptions) throws PDFNetException {
        PDFDoc.SaveViewerOptimized(this.impl, string, viewerOptimizedOptions.m_obj.__GetHandle());
        ReachabilityHelper.ensureReachable(viewerOptimizedOptions);
    }

    public byte[] saveViewerOptimized(ViewerOptimizedOptions viewerOptimizedOptions) throws PDFNetException {
        byte[] byArray = PDFDoc.SaveViewerOptimizedBuffer(this.impl, viewerOptimizedOptions.m_obj.__GetHandle());
        ReachabilityHelper.ensureReachable(viewerOptimizedOptions);
        return byArray;
    }

    public SignaturesVerificationStatus verifySignedDigitalSignatures(VerificationOptions verificationOptions) throws PDFNetException {
        SignaturesVerificationStatus signaturesVerificationStatus = SignaturesVerificationStatus.valueToEnum(PDFDoc.VerifySignedDigitalSignatures(this.impl, verificationOptions.__GetHandle()));
        ReachabilityHelper.ensureReachable(verificationOptions);
        return signaturesVerificationStatus;
    }

    PDFDoc(long l) {
        this.impl = l;
    }

    public static PDFDoc __Create(long l) {
        return new PDFDoc(l);
    }

    @Override
    public long __GetHandle() {
        return this.impl;
    }

    static native long PDFDocCreate();

    static native long PDFDocCreate(String var0);

    static native long PDFDocCreateFilter(long var0);

    static native long PDFDocCreate(byte[] var0);

    static native long GetTriggerAction(long var0, int var2);

    static native long MemStreamCreateMemFilt(long var0) throws PDFNetException;

    static native void MemStreamWriteData(long var0, byte[] var2, int var3);

    static native long MemStreamCreateDoc(long var0);

    static native void Close(long var0);

    static native boolean IsEncrypted(long var0);

    static native boolean InitSecurityHandler(long var0, Object var2);

    static native boolean InitStdSecurityHandler(long var0, String var2);

    static native boolean InitStdSecurityHandlerBuffer(long var0, byte[] var2);

    static native long GetSecurityHandler(long var0);

    static native void SetSecurityHandler(long var0, long var2);

    static native long GetDocInfo(long var0);

    static native long GetViewPrefs(long var0);

    static native boolean IsModified(long var0);

    static native boolean HasChangesSinceSnapshot(long var0);

    static native boolean HasRepairedXRef(long var0);

    static native boolean IsLinearized(long var0);

    static native boolean SaveIncrementalData(long var0, String var2);

    static native void Save(long var0, String var2, long var3, ProgressMonitor var5);

    static native byte[] Save(long var0, long var2, ProgressMonitor var4);

    static native long[] SaveStream(long var0, long var2, ProgressMonitor var4);

    static native void SaveCustomFilter(long var0, long var2, long var4);

    static native long SaveCustomFilter2(long var0, long var2, long var4);

    static native void SaveCustomSignaturePath(long var0, byte[] var2, long var3, String var5);

    static native void SaveCustomSignatureCustomFilter(long var0, byte[] var2, long var3, long var5);

    static native void ReadData(byte[] var0, int var1, long var2);

    static native void RemoveSecurity(long var0);

    static native long GetPageIteratorBegin(long var0);

    static native long GetPageIterator(long var0, int var2);

    static native long GetPage(long var0, int var2);

    static native void PageRemove(long var0, long var2);

    static native void PageInsert(long var0, long var2, long var4);

    static native void InsertPageSet(long var0, int var2, long var3, long var5, int var7, ProgressMonitor var8);

    static native void MovePageSet(long var0, int var2, long var3, long var5, int var7, ProgressMonitor var8);

    static native void PagePushFront(long var0, long var2);

    static native void PagePushBack(long var0, long var2);

    static native long[] ImportPages(long var0, long[] var2, boolean var3);

    static native int AppendTextDiffPage(long var0, long var2, long var4);

    static native int AppendTextDiffDoc(long var0, long var2, long var4, long var6);

    static native int HighlightTextDiff(long var0, long var2, long var4);

    static native long PageCreate(long var0, long var2);

    static native long GetFirstBookmark(long var0);

    static native void AddRootBookmark(long var0, long var2);

    static native long GetTrailer(long var0);

    static native long GetRoot(long var0);

    static native void JSContextInitialize(long var0);

    static native long GetPages(long var0);

    static native int GetPagesCount(long var0);

    static native long GetFieldIteratorBegin(long var0);

    static native long GetFieldIterator(long var0, String var2);

    static native long GetField(long var0, String var2);

    static native long FieldCreate(long var0, String var2, int var3, long var4, long var6);

    static native long FieldCreate(long var0, String var2, int var3, String var4, String var5);

    static native void RefreshFieldAppearances(long var0);

    static native void RefreshAnnotAppearances(long var0, long var2);

    static native void FlattenAnnotations(long var0, boolean var2);

    static native void FlattenAnnotationsAdvanced(long var0, long var2);

    static native long GetAcroForm(long var0);

    static native long FDFExtract(long var0, long var2, int var4);

    static native long FDFExtract(long var0, int var2);

    static native long FDFExtract(long var0, long[] var2);

    static native long FDFExtract(long var0, long[] var2, long[] var3, long[] var4);

    static native void FDFMerge(long var0, long var2);

    static native void FDFUpdate(long var0, long var2);

    static native void MergeXFDF_old(long var0, long var2, String var4);

    static native void MergeXFDFString_old(long var0, String var2, String var3);

    static native void MergeXFDF(long var0, long var2, long var4);

    static native void MergeXFDFString(long var0, String var2, long var3);

    static native long GetOpenAction(long var0);

    static native void SetOpenAction(long var0, long var2);

    static native void AddFileAttachment(long var0, String var2, long var3);

    static native long GetPageLabel(long var0, int var2);

    static native void SetPageLabel(long var0, int var2, long var3);

    static native void RemovePageLabel(long var0, int var2);

    static native long GetStructTree(long var0);

    static native boolean HasOC(long var0);

    static native long GetOCGs(long var0);

    static native long GetOCGConfig(long var0);

    static native long CreateIndirectName(long var0, String var2);

    static native long CreateIndirectArray(long var0);

    static native long CreateIndirectBool(long var0, boolean var2);

    static native long CreateIndirectDict(long var0);

    static native long CreateIndirectNull(long var0);

    static native long CreateIndirectNumber(long var0, double var2);

    static native long CreateIndirectString(long var0, byte[] var2);

    static native long CreateIndirectString(long var0, String var2);

    static native long CreateIndirectStream(long var0, long var2, long var4);

    static native long CreateIndirectStream(long var0, byte[] var2, long var3);

    static native void Lock(long var0);

    static native void Unlock(long var0);

    static native boolean TryLock(long var0, int var2);

    static native void LockRead(long var0);

    static native void UnlockRead(long var0);

    static native boolean TryLockRead(long var0, int var2);

    static native void AddHighlights(long var0, String var2);

    static native boolean IsTagged(long var0);

    static native String GetFileName(long var0);

    static native void GenerateThumbnails(long var0, long var2);

    static native void AppendVisualDiff(long var0, long var2, long var4, long var6);

    static native long GetDownloadedByteCount(long var0);

    static native long GetTotalRemoteByteCount(long var0);

    static native boolean HasDownloader(long var0);

    static native long GetUndoManager(long var0);

    static native boolean HasSignatures(long var0);

    static native long AddSignatureHandler(long var0, SignatureHandler var2);

    static native long AddStdSignatureHandlerFromFile(long var0, String var2, String var3);

    static native long AddStdSignatureHandlerFromBuffer(long var0, byte[] var2, String var3);

    static native SignatureHandler RemoveSignatureHandler(long var0, long var2);

    static native SignatureHandler GetSignatureHandler(long var0, long var2);

    static native long CreateDigitalSignatureField(long var0, String var2);

    static native long CreateDigitalSignatureField(long var0);

    static native long GetDigitalSignatureFieldIteratorBegin(long var0);

    static native int GetDigitalSignaturePermissions(long var0);

    static native void SaveViewerOptimized(long var0, String var2, long var3);

    static native byte[] SaveViewerOptimizedBuffer(long var0, long var2);

    static native int VerifySignedDigitalSignatures(long var0, long var2);

    public static enum SignaturesVerificationStatus {
        e_unsigned(0),
        e_failure(1),
        e_untrusted(2),
        e_unsupported(3),
        e_verified(4);

        final int value;
        private static HashMap<Integer, SignaturesVerificationStatus> SignaturesVerificationStatus_map;

        private SignaturesVerificationStatus(int n2) {
            this.value = n2;
        }

        static SignaturesVerificationStatus valueToEnum(int n) {
            return SignaturesVerificationStatus_map.get(n);
        }

        static {
            SignaturesVerificationStatus_map = new HashMap();
            for (SignaturesVerificationStatus signaturesVerificationStatus : SignaturesVerificationStatus.values()) {
                SignaturesVerificationStatus_map.put(signaturesVerificationStatus.value, signaturesVerificationStatus);
            }
        }
    }

    public static enum ActionTriggerMode {
        DOC_WILL_CLOSE(17),
        DOC_WILL_SAVE(18),
        DOC_DID_SAVE(19),
        DOC_WILL_PRINT(20),
        DOC_DID_PRINT(21);

        private final int mode;

        private ActionTriggerMode(int n2) {
            this.mode = n2;
        }

        public int getValue() {
            return this.mode;
        }
    }

    public static enum FlattenMode {
        FORMS(1),
        ANNOTS(2),
        LINK(4),
        ALL(8);

        private final int mode;

        private FlattenMode(int n2) {
            this.mode = n2;
        }

        public int getValue() {
            return this.mode;
        }
    }

    public static enum InsertBookmarkMode {
        NONE(0),
        INSERT(1),
        INSERT_GOTO(2);

        private final int mode;

        private InsertBookmarkMode(int n2) {
            this.mode = n2;
        }

        public int getValue() {
            return this.mode;
        }
    }
}

