/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.pdf;

import com.pdftron.common.PDFNetException;
import com.pdftron.crypto.DigestAlgorithm;
import com.pdftron.pdf.DigitalSignatureField;
import com.pdftron.pdf.DisallowedChange;
import com.pdftron.pdf.TrustVerificationResult;
import java.util.HashMap;

public class VerificationResult
implements AutoCloseable {
    private Object ref;
    private long mImpl;

    public void destroy() throws PDFNetException {
        if (this.mImpl != 0L) {
            VerificationResult.Destroy(this.mImpl);
            this.mImpl = 0L;
        }
    }

    protected void finalize() throws Throwable {
        this.destroy();
    }

    public VerificationResult(long l, Object object) {
        this.mImpl = l;
        this.ref = object;
    }

    public DigitalSignatureField getDigitalSignatureField() throws PDFNetException {
        return DigitalSignatureField.__Create(VerificationResult.GetDigitalSignatureField(this.__GetHandle()), this.__GetRefHandle());
    }

    public boolean getVerificationStatus() throws PDFNetException {
        return VerificationResult.GetVerificationStatus(this.mImpl);
    }

    public DocumentStatus getDocumentStatus() throws PDFNetException {
        return DocumentStatus.valueToEnum(VerificationResult.GetDocumentStatus(this.mImpl));
    }

    public DigestStatus getDigestStatus() throws PDFNetException {
        return DigestStatus.valueToEnum(VerificationResult.GetDigestStatus(this.mImpl));
    }

    public TrustStatus getTrustStatus() throws PDFNetException {
        return TrustStatus.valueToEnum(VerificationResult.GetTrustStatus(this.mImpl));
    }

    public ModificationPermissionsStatus getPermissionsStatus() throws PDFNetException {
        return ModificationPermissionsStatus.valueToEnum(VerificationResult.GetPermissionsStatus(this.mImpl));
    }

    public boolean hasTrustVerificationResult() throws PDFNetException {
        return VerificationResult.HasTrustVerificationResult(this.mImpl);
    }

    public TrustVerificationResult getTrustVerificationResult() throws PDFNetException {
        return new TrustVerificationResult(VerificationResult.GetTrustVerificationResult(this.mImpl));
    }

    public DisallowedChange[] getDisallowedChanges() throws PDFNetException {
        long[] lArray = VerificationResult.GetDisallowedChanges(this.mImpl);
        DisallowedChange[] disallowedChangeArray = new DisallowedChange[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            disallowedChangeArray[i] = new DisallowedChange(lArray[i]);
        }
        return disallowedChangeArray;
    }

    public DigestAlgorithm getDigestAlgorithm() throws PDFNetException {
        return DigestAlgorithm.valueToEnum(VerificationResult.GetDigestAlgorithm(this.mImpl));
    }

    public String getDocumentStatusAsString() throws PDFNetException {
        return VerificationResult.GetDocumentStatusAsString(this.mImpl);
    }

    public String getDigestStatusAsString() throws PDFNetException {
        return VerificationResult.GetDigestStatusAsString(this.mImpl);
    }

    public String getTrustStatusAsString() throws PDFNetException {
        return VerificationResult.GetTrustStatusAsString(this.mImpl);
    }

    public String getPermissionsStatusAsString() throws PDFNetException {
        return VerificationResult.GetPermissionsStatusAsString(this.mImpl);
    }

    public String[] getUnsupportedFeatures() throws PDFNetException {
        return VerificationResult.GetUnsupportedFeatures(this.mImpl);
    }

    public long __GetHandle() {
        return this.mImpl;
    }

    public Object __GetRefHandle() {
        return this.ref;
    }

    @Override
    public void close() throws PDFNetException {
        this.destroy();
    }

    static native void Destroy(long var0);

    static native long GetDigitalSignatureField(long var0);

    static native boolean GetVerificationStatus(long var0);

    static native int GetDocumentStatus(long var0);

    static native int GetDigestStatus(long var0);

    static native int GetTrustStatus(long var0);

    static native int GetPermissionsStatus(long var0);

    static native boolean HasTrustVerificationResult(long var0);

    static native long GetTrustVerificationResult(long var0);

    static native long[] GetDisallowedChanges(long var0);

    static native int GetDigestAlgorithm(long var0);

    static native String GetDocumentStatusAsString(long var0);

    static native String GetDigestStatusAsString(long var0);

    static native String GetTrustStatusAsString(long var0);

    static native String GetPermissionsStatusAsString(long var0);

    static native String[] GetUnsupportedFeatures(long var0);

    public static enum ModificationPermissionsStatus {
        e_invalidated_by_disallowed_changes(0),
        e_has_allowed_changes(1),
        e_unmodified(2),
        e_permissions_verification_disabled(3),
        e_no_permissions_status(4),
        e_unsupported_permissions_features(5);

        final int value;
        private static HashMap<Integer, ModificationPermissionsStatus> mdp_status_map;

        private ModificationPermissionsStatus(int n2) {
            this.value = n2;
        }

        static ModificationPermissionsStatus valueToEnum(int n) {
            return mdp_status_map.get(n);
        }

        static {
            mdp_status_map = new HashMap();
            for (ModificationPermissionsStatus modificationPermissionsStatus : ModificationPermissionsStatus.values()) {
                mdp_status_map.put(modificationPermissionsStatus.value, modificationPermissionsStatus);
            }
        }
    }

    public static enum TrustStatus {
        e_trust_verified(0),
        e_untrusted(1),
        e_trust_verification_disabled(2),
        e_no_trust_status(3),
        e_unsupported_trust_features(4);

        final int value;
        private static HashMap<Integer, TrustStatus> trust_status_map;

        private TrustStatus(int n2) {
            this.value = n2;
        }

        static TrustStatus valueToEnum(int n) {
            return trust_status_map.get(n);
        }

        static {
            trust_status_map = new HashMap();
            for (TrustStatus trustStatus : TrustStatus.values()) {
                trust_status_map.put(trustStatus.value, trustStatus);
            }
        }
    }

    public static enum DigestStatus {
        e_digest_invalid(0),
        e_digest_verified(1),
        e_digest_verification_disabled(2),
        e_weak_digest_algorithm_but_digest_verifiable(3),
        e_no_digest_status(4),
        e_unsupported_encoding(5),
        e_unsupported_digest_algorithm(6);

        final int value;
        private static HashMap<Integer, DigestStatus> digest_status_map;

        private DigestStatus(int n2) {
            this.value = n2;
        }

        static DigestStatus valueToEnum(int n) {
            return digest_status_map.get(n);
        }

        static {
            digest_status_map = new HashMap();
            for (DigestStatus digestStatus : DigestStatus.values()) {
                digest_status_map.put(digestStatus.value, digestStatus);
            }
        }
    }

    public static enum DocumentStatus {
        e_no_error(0),
        e_corrupt_file(1),
        e_unsigned(2),
        e_bad_byteranges(3),
        e_corrupt_cryptographic_contents(4);

        final int value;
        private static HashMap<Integer, DocumentStatus> document_status_map;

        private DocumentStatus(int n2) {
            this.value = n2;
        }

        static DocumentStatus valueToEnum(int n) {
            return document_status_map.get(n);
        }

        static {
            document_status_map = new HashMap();
            for (DocumentStatus documentStatus : DocumentStatus.values()) {
                document_status_map.put(documentStatus.value, documentStatus);
            }
        }
    }
}

