/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.sdf;

import com.pdftron.common.PDFNetException;
import com.pdftron.helpers.ReachabilityHelper;
import com.pdftron.sdf.DictIterator;
import com.pdftron.sdf.NumberTreeIterator;
import com.pdftron.sdf.Obj;

public class NumberTree {
    long impl;
    Object ref;

    public NumberTree(Obj obj) {
        this.impl = obj.impl;
        this.ref = obj.ref;
    }

    public boolean isValid() throws PDFNetException {
        return this.impl != 0L;
    }

    public DictIterator getIterator(long l) throws PDFNetException {
        return new NumberTreeIterator(NumberTree.GetIterator(this.impl, l), this.ref);
    }

    public Obj getValue(long l) throws PDFNetException {
        return Obj.__Create(NumberTree.GetValue(this.impl, l), this.ref);
    }

    public DictIterator getIterator() throws PDFNetException {
        return new NumberTreeIterator(NumberTree.GetIterator(this.impl), this.ref);
    }

    public void put(long l, Obj obj) throws PDFNetException {
        NumberTree.Put(this.impl, l, obj.impl);
        ReachabilityHelper.ensureReachable(obj);
    }

    public void erase(long l) throws PDFNetException {
        NumberTree.Erase(this.impl, l);
    }

    public void erase(DictIterator dictIterator) throws PDFNetException {
        NumberTree.EraseIt(this.impl, dictIterator.impl);
        ReachabilityHelper.ensureReachable(dictIterator);
    }

    public Obj getSDFObj() {
        return Obj.__Create(this.impl, this.ref);
    }

    static native long NumberTreeCreate(long var0);

    static native boolean IsValid(long var0);

    static native long GetIterator(long var0, long var2);

    static native long GetValue(long var0, long var2);

    static native long GetIterator(long var0);

    static native void Put(long var0, long var2, long var4);

    static native void Erase(long var0, long var2);

    static native void EraseIt(long var0, long var2);
}

