//---------------------------------------------------------------------------------------
// Copyright (c) 2001-2025 by Apryse Software Inc. All Rights Reserved.
// Consult legal.txt regarding legal and license information.
//---------------------------------------------------------------------------------------
// !Warning! This file is autogenerated, modify the .codegen file, not this one
// (any changes here will be wiped out during the autogen process)

#ifndef PDFTRON_H_CPPPDFCubicCurveBuilder
#define PDFTRON_H_CPPPDFCubicCurveBuilder
#include <C/PDF/TRN_CubicCurveBuilder.h>
#include <Common/BasicTypes.h>
#include <Common/UString.h>
#include <PDF/PDFDoc.h>

namespace pdftron { namespace PDF { 


/**
 * The class CubicCurveBuilder.
 * Creates Cubic Curves from linear points
 *
 * DocumentConversion instances are created through methods belonging to
 * the Convert class. See Convert.WordToPDFConversion for an example.
 */
class CubicCurveBuilder
{
public:
		CubicCurveBuilder();
	CubicCurveBuilder(const CubicCurveBuilder& other);
	CubicCurveBuilder(TRN_CubicCurveBuilder impl);
	CubicCurveBuilder& operator= (const CubicCurveBuilder& other);
	~CubicCurveBuilder();
	
	void Destroy();

	//methods:
	
	/**
	 * Number of source points.
	 * 
	 * @return Indicates that the conversion succeeded, failed, or was cancelled.
	 */
	UInt32 NumSourcePoints();
	
	/**
	 * Add a source xy point.
	 * 
	 * @param x -- the x coordinate.
	 * @param y -- the y coordinate.
	 */
	void AddSourcePoint(double x, double y);
	
	/**
	 * Number of generated cubic points.
	 * 
	 * @return Indicates that the conversion succeeded, failed, or was cancelled.
	 */
	UInt32 NumCubicPoints();
	
	/**
	 * Get the cubic X coordinate.
	 * 
	 * @param index -- the index of the coordinate. Must be less than NumCubicPoints().
	 * @return X coordinate of the indicated point on the cubic curve.
	 */
	double GetCubicXCoord(UInt32 index);
	
	/**
	 * Get the cubic Y coordinate.
	 * 
	 * @param index -- the index of the coordinate. Must be less than NumCubicPoints().
	 * @return Y coordinate of the indicated point on the cubic curve.
	 */
	double GetCubicYCoord(UInt32 index);

#ifndef SWIGHIDDEN
	TRN_CubicCurveBuilder m_impl;
#endif

private:

#ifndef SWIGHIDDEN
	mutable bool m_owner; 
#endif
};

#include <Impl/CubicCurveBuilder.inl>
} //end pdftron
} //end PDF


#endif //PDFTRON_H_CPPPDFCubicCurveBuilder
