// This file is autogenerated: please see the codegen template "Options"
#ifndef PDFTRON_H_CPPPDFFindReplaceOptions
#define PDFTRON_H_CPPPDFFindReplaceOptions

#include <PDF/OptionsBase.h>

namespace pdftron{ namespace PDF{ 

class FindReplaceOptions : public OptionsBase
{
public:
	/**
	* An enumeration used to specify the horizontal alignment of the new
	* text added.
	*/
	enum HorizAlignment
	{
		e_left = 1, ///< Apply left alignment to the new text.
		e_center = 2, ///< Apply center alignment to the new text.
		e_right = 3, ///< Apply right alignment to the new text.
		e_full = 4 ///< Apply full alignment to the new text.
	};

	/**
	* An enumeration used to specify the mode used to reflow the replaced
	* text.
	*/
	enum ReflowType
	{
		e_text = 1, ///< Reflow just the changed text.
		e_line = 2, ///< Reflow the whole line of the changed text.
		e_para = 3 ///< Reflow the whole paragraph of changed text.
	};

	/**
	* An enumeration used to specify the mode used to match text.
	*/
	enum MatchType
	{
		e_exact = 1, ///< Exactly match the text.
		e_wildcards = 2, ///< Use of wildcards to match the text is allowed.
		e_regex = 3 ///< Use of regular expressions to match the text is allowed.
	};

	FindReplaceOptions();
	~FindReplaceOptions();

	
	/**
	* Gets the value Alignment from the options object.
	* Specifies the horizontal alignment of the new text added.
	* @return The current value for Alignment.
	*/
	HorizAlignment GetAlignment();

	/**
	* Sets the value for Alignment in the options object.
	* Specifies the horizontal alignment of the new text added.
	* @param value The new value for Alignment.
	* @return This object, for call chaining.
	*/
	FindReplaceOptions& SetAlignment(HorizAlignment value);

	
	/**
	* Gets the value BatchSize from the options object.
	* The number of pages to process before saving an intermediate PDF to
	* free resources. A greater number of pages will increase memory usage,
	* and a smaller number will increase processing time. Default is 20.
	* @return The current value for BatchSize.
	*/
	UInt32 GetBatchSize();

	/**
	* Sets the value for BatchSize in the options object.
	* The number of pages to process before saving an intermediate PDF to
	* free resources. A greater number of pages will increase memory usage,
	* and a smaller number will increase processing time. Default is 20.
	* @param value The new value for BatchSize.
	* @return This object, for call chaining.
	*/
	FindReplaceOptions& SetBatchSize(UInt32 value);

	
	/**
	* Gets the value MatchCase from the options object.
	* Specifies whether the case of the 'from' string should be exactly
	* matched when finding text to replace. Ignored if MatchType is regex.
	* @return The current value for MatchCase.
	*/
	bool GetMatchCase();

	/**
	* Sets the value for MatchCase in the options object.
	* Specifies whether the case of the 'from' string should be exactly
	* matched when finding text to replace.
	* @param value The new value for MatchCase.
	* @return This object, for call chaining.
	*/
	FindReplaceOptions& SetMatchCase(bool value);

	
	/**
	* Gets the MatchMode value from the options object.
	* Specifies the mode used to match the text. the types of match are
	* exact matching, wildcard matching and regular expression matching.
	* @return The current value for MatchMode.
	*/
	MatchType GetMatchMode();

	/**
	* Sets MatchMode value in the options object.
	* Specifies the mode used to match the text. the types of match are
	* exact matching, wildcard matching and regular expression matching.
	* @param value The new value for MatchMode.
	* @return This object, for call chaining.
	*/
	FindReplaceOptions& SetMatchMode(MatchType value);

	
	/**
	* Gets the value Pages from the options object.
	* Specifies a set of pages to process, such as "1-5", or "1-3,5,7-10".
	* Open ended ranges are supported, e.g., "3-". By default all pages are
	* processed. The first page is page number 1.
	* @return The current value for Pages.
	*/
	UString GetPages();

	/**
	* Sets the value for Pages in the options object.
	* Specifies a set of pages to process, such as "1-5", or "1-3,5,7-10".
	* Open ended ranges are supported, e.g., "3-". By default all pages are
	* processed. The first page is page number 1.
	* @param value The new value for Pages.
	* @return This object, for call chaining.
	*/
	FindReplaceOptions& SetPages(const UString& value);

	
	/**
	* Gets the value ReflowMode from the options object.
	* Specifies the mode used to reflow the replaced text.
	* @return The current value for ReflowMode.
	*/
	ReflowType GetReflowMode();

	/**
	* Sets the value for ReflowMode in the options object.
	* Specifies the mode used to reflow the replaced text.
	* @param value The new value for ReflowMode.
	* @return This object, for call chaining.
	*/
	FindReplaceOptions& SetReflowMode(ReflowType value);

	
	/**
	* Gets the value WholeWords from the options object.
	* Specifies whether whole words should be matched when finding text to
	* replace. Ignored if MatchType is regex.
	* @return The current value for WholeWords.
	*/
	bool GetWholeWords();

	/**
	* Sets the value for WholeWords in the options object.
	* Specifies whether whole words should be matched when finding text to
	* replace. Ignored if MatchType is regex.
	* @param value The new value for WholeWords.
	* @return This object, for call chaining.
	*/
	FindReplaceOptions& SetWholeWords(bool value);

	
};

}
}

#include "../Impl/FindReplaceOptions.inl"
#endif // PDFTRON_H_CPPPDFFindReplaceOptions
