// This file is autogenerated: please see the codegen template "Options"
#ifndef PDFTRON_H_CPPPDFOCROptions
#define PDFTRON_H_CPPPDFOCROptions

#include <PDF/OptionsBase.h>
#include <Common/UString.h>

namespace pdftron{ namespace PDF{ 

class OCROptions
{
public:
	OCROptions();
	~OCROptions();

	
	/**
	* Gets the value AutoRotate from the options object.
	* <p>
	* Default value is false. Setting to true will deskew the image before conducting OCR.
	* </p><p>
	* <b>Note</b>: This function doesn't apply to IRIS OCR module.</p>
	* @return The current value for AutoRotate.
	*/
	bool GetAutoRotate();

	/**
	* Sets the value for AutoRotate in the options object.
	* <p>
	* Default value is false. Setting to true will deskew the image before conducting OCR.
	* </p><p>
	* <b>Note</b>: This function doesn't apply to IRIS OCR module.</p>
	* @param value The new value for AutoRotate.
	* @return This object, for call chaining.
	*/
	OCROptions& SetAutoRotate(bool value);

	
	/**
	* Gets the value DPI from the options object.
	* <p>
	* Knowing proper image resolution is important, as it enables
	* the OCR engine to translate pixel heights of characters to their respective font sizes.
	* </p><p>
	* We do our best to retrieve resolution information from the input's metadata, however it
	* occasionally can be corrupt or missing. Hence we allow manual override of source's resolution,
	* which supersedes any metadata found (both explicit as in image metadata and implicit as in PDF).
	* </p><p>
	* If input is a PDF file, the SDK will render PDF page for OCR as a raster image
	* with 300 DPI resolution. Otherwise, if input is an image, SDK will pass to OCR
	* raster image in original resolution. Exceptionally, if the user, by using this
	* method, suggests the resolution (say 300 DPI), the SDK will try do as suggested.
	* </p><p>
	* Here, some restrictions apply:
	* <ul>
	* <li>New image size in pixels (Width X Height) cannot exceed 75 MP (Mega Pixels)</li>
	* <li>Each image side (Width or Height), in pixels, cannot exceed 16 bits (65,535)</li>
	* </ul>
	* </p><p>
	* To achieve that, SDK will iteratively scale down the DPI till both conditions are met.</p>
	* @return The current value for DPI.
	*/
	int GetDPI();

	/**
	* Sets the value for DPI in the options object.
	* <p>
	* Knowing proper image resolution is important, as it enables
	* the OCR engine to translate pixel heights of characters to their respective font sizes.
	* </p><p>
	* We do our best to retrieve resolution information from the input's metadata, however it
	* occasionally can be corrupt or missing. Hence we allow manual override of source's resolution,
	* which supersedes any metadata found (both explicit as in image metadata and implicit as in PDF).
	* </p><p>
	* If input is a PDF file, the SDK will render PDF page for OCR as a raster image
	* with 300 DPI resolution. Otherwise, if input is an image, SDK will pass to OCR
	* raster image in original resolution. Exceptionally, if the user, by using this
	* method, suggests the resolution (say 300 DPI), the SDK will try do as suggested.
	* </p><p>
	* Here, some restrictions apply:
	* <ul>
	* <li>New image size in pixels (Width X Height) cannot exceed 75 MP (Mega Pixels)</li>
	* <li>Each image side (Width or Height), in pixels, cannot exceed 16 bits (65,535)</li>
	* </ul>
	* </p><p>
	* To achieve that, SDK will iteratively scale down the DPI till both conditions are met.</p>
	* @param dpi The new value for DPI.
	* @return This object, for call chaining.
	*/
	OCROptions& AddDPI(int dpi);

	
	/**
	* Gets the value IgnoreExistingText from the options object.
	* <p>
	* Default value is false, so that areas with existing text will be
	* automatically skipped during OCR. Setting to true will cause a
	* pre-existing text to be duplicated with the OCR-ed ones in the PDF
	* document or in GetOCRJsonFromPDF() and GetOCRXmlFromPDF() results.</p>
	* <p><b>Deprecated!</b> Use <b>GetIncludeExistingText</b> instead.</p>
	* @return The current value for IgnoreExistingText.
	*/
	bool GetIgnoreExistingText();

	/**
	* Sets the value for IgnoreExistingText in the options object.
	* <p>
	* Default value is false, so that areas with existing text will be
	* automatically skipped during OCR. Setting to true will cause a
	* pre-existing text to be duplicated with the OCR-ed ones in the PDF
	* document or in GetOCRJsonFromPDF() and GetOCRXmlFromPDF() results.</p>
	* <p><b>Deprecated!</b> Use <b>SetIncludeExistingText</b> instead.</p>
	* @param value The new value for IgnoreExistingText.
	* @return This object, for call chaining.
	*/
	OCROptions& SetIgnoreExistingText(bool value);

	
	/**
	* Gets the value IncludeExistingText from the options object.
	* <p>
	* Default value is false, so that areas with existing text will be
	* automatically skipped during OCR. Setting to true will cause a
	* pre-existing text to be duplicated with the OCR-ed ones in the PDF
	* document or in GetOCRJsonFromPDF() and GetOCRXmlFromPDF() results.</p>
	* @return The current value for IncludeExistingText.
	*/
	bool GetIncludeExistingText();

	/**
	* Sets the value for IncludeExistingText in the options object.
	* <p>
	* Default value is false, so that areas with existing text will be
	* automatically skipped during OCR. Setting to true will cause a
	* pre-existing text to be duplicated with the OCR-ed ones in the PDF
	* document or in GetOCRJsonFromPDF() and GetOCRXmlFromPDF() results.</p>
	* @param value The new value for IncludeExistingText.
	* @return This object, for call chaining.
	*/
	OCROptions& SetIncludeExistingText(bool value);


	/**
	* Adds the zones to the IgnoreZones array.
	* <p>
	* It is an optional list of areas that will be excluded from analysis.
	* </p><p>
	* The meaning and handling of the passed region coordinates will vary depending on:
	* </p>
	* <ul>
	* <li>Whether input is PDF (rather than an image), and</li>
	* <li>Whether SetUsePDFPageCoords() is called with value true.</li>
	* </ul>
	* <p>
	* If either of above is true, then the region coordinates have to be given in
	* PDF Points and coodinate space origin at <b>bottom</b>-left.
	* </p><p>
	* Otherwise:
	* <ul>
	* <li>The input is a raster image,</li>
	* <li>The coordinates has to be given in pixel units and with coordinate space origin at <b>top</b>-left</li>
	* </ul>
	* </p><p>
	* <b>See also</b>: ProcessPDF() ImageToPDF() SetUsePDFPageCoords() AddTextZonesForPage().</p>
	* @param regions The new zones to be added to IgnoreZonesForPage.
	* @param page_num The page number the added regions belong to.
	* @return This object, for call chaining.
	*/
	OCROptions& AddIgnoreZonesForPage(const RectCollection& regions, int page_num);

	

	/**
	* Adds the language to the Langs array.
	* <p>
	* OCR engine is prepared for recognition of a predefined set of language scripts.
	* Various scripts have differences in glyphs and it is recommended that OCR engine is
	* instructed to use a correct glyph set to match the appropriate Unicode. At this moment,
	* there are two avaliable engines for use. Let we refer them by their executable names:
	* OCRModule and OCRModuleIRIS.
	* </p><p>
	* Here is a list of supported languages by their codes that may be passed as a parameter.
	* One language per call to AddLang(). Use multiple calls to AddLang()
	* to add additional languages.
	* </p><p>
	* <b>Warning</b>: Be aware that adding too many language codes at once may lead to
	* wrong altertnatives regarding Latin characters with accents.
	* </p>
	* <table>
	* <tr><th>Language </th><th>Code</th><th>Language      </th><th>Code   </th></tr>
	* <tr><td>English  </td><td>eng </td><td>Chinese Simpl.</td><td>chi_sim</td></tr>
	* <tr><td>French   </td><td>fra </td><td>Chinese Trad. </td><td>chi_tra</td></tr>
	* <tr><td>German   </td><td>deu </td><td>Japanese      </td><td>jpn    </td></tr>
	* <tr><td>Italian  </td><td>ita </td><td>Korean        </td><td>kor    </td></tr>
	* <tr><td>Russian  </td><td>rus </td><td>              </td><td>       </td></tr>
	* <tr><td>Spanish  </td><td>spa </td><td>              </td><td>       </td></tr>
	* </table>
	* <p>Here are the languages supported out of the box per engine:
	* </p><table>
	* <tr><th>Executable Name</th><th>Supported Codes                                </th></tr>
	* <tr><td>OCRModule      </td><td>eng fra deu ita spa rus                        </td></tr>
	* <tr><td>OCRModuleIRIS  </td><td>eng fra deu ita spa rus chi_sim chi_tra jpn kor</td></tr>
	* </table>
	* <p><b>Note</b>: OCRModuleIRIS allows mix of a single Asian language and just English.</p>
	* @param lang The new language to be added to Langs.
	* @return This object, for call chaining.
	*/
	OCROptions& AddLang(const UString& lang);

	
	/**
	* Gets the value OCREngine from the options object.
	* <p>
	* Options include 'default' or 'iris'.
	* Chosen module must be present and correctly licensed.</p>
	* @return The current value for OCREngine.
	*/
	UString GetOCREngine();

	/**
	* Sets the value for OCREngine in the options object.
	* <p>
	* Options include 'default' or 'iris'.
	* Chosen module must be present and correctly licensed.</p>
	* @param value The new value for OCREngine.
	* @return This object, for call chaining.
	*/
	OCROptions& SetOCREngine(const UString& value);

	

	/**
	* Adds the zones to the TextZones array.
	* <p>
	* It is as an optional list of known text zones that will be used to
	* improve OCR quality.
	* </p><p>
	* <b>See also</b>: AddIgnoreZonesForPage().</p>
	* @param regions The new zones to be added to TextZonesForPage.
	* @param page_num The page number the added regions belong to.
	* @return This object, for call chaining.
	*/
	OCROptions& AddTextZonesForPage(const RectCollection& regions, int page_num);

	
	/**
	* Gets the value UsePDFPageCoords from the options object.
	* <p>
	* Defines the coordinate system, scaling and units.
	* SDK and OCRModule will refer to this setting while dealing with potential input
	* zone rectangle(s) (ignorable or text) and with the output result as well.
	* The default value is false which corresponds to raster image input.
	* </p><p>
	* Here are the meanings for value:
	* </p>
	* <table>
	* <tr><th>Value</th><th>Origin     </th><th>+Y axis dir.</th><th>Unit </th><th>Size        </th><th>Expected input</th></tr>
	* <tr><td>false</td><td>top-left   </td><td>Downwards   </td><td>Pixel</td><td>1/DPI inches</td><td>Image         </td></tr>
	* <tr><td>true </td><td>bottom-left</td><td>Upwards     </td><td>Point</td><td>1/72 inches </td><td>PDF           </td></tr>
	* </table>
	* <p>
	* Note that, OCRModule backend has no notion about the SDK's real input. So, if
	* not explicitelly instructed via this call and value, it will work
	* by default and will report the coordinates as for false. This is important to know
	* for cases when the call for OCR service comes from GetOCRJsonFromPDF() or
	* GetOCRXmlFromPDF() where the results should be correct in JSON or XML
	* format - and removes the need for user to do additional adjustments.
	* </p><p>
	* <b>See also</b>: AddIgnoreZonesForPage() AddTextZonesForPage() AddDPI() GetOCRJsonFromImage() GetOCRXmlFromImage().</p>
	* @return The current value for UsePDFPageCoords.
	*/
	bool GetUsePDFPageCoords();

	/**
	* Sets the value for UsePDFPageCoords in the options object.
	* <p>
	* Defines the coordinate system, scaling and units.
	* SDK and OCRModule will refer to this setting while dealing with potential input
	* zone rectangle(s) (ignorable or text) and with the output result as well.
	* The default value is false which corresponds to raster image input.
	* </p><p>
	* Here are the meanings for value:
	* </p>
	* <table>
	* <tr><th>Value</th><th>Origin     </th><th>+Y axis dir.</th><th>Unit </th><th>Size        </th><th>Expected input</th></tr>
	* <tr><td>false</td><td>top-left   </td><td>Downwards   </td><td>Pixel</td><td>1/DPI inches</td><td>Image         </td></tr>
	* <tr><td>true </td><td>bottom-left</td><td>Upwards     </td><td>Point</td><td>1/72 inches </td><td>PDF           </td></tr>
	* </table>
	* <p>
	* Note that, OCRModule backend has no notion about the SDK's real input. So, if
	* not explicitelly instructed via this call and value, it will work
	* by default and will report the coordinates as for false. This is important to know
	* for cases when the call for OCR service comes from GetOCRJsonFromPDF() or
	* GetOCRXmlFromPDF() where the results should be correct in JSON or XML
	* format - and removes the need for user to do additional adjustments.
	* </p><p>
	* <b>See also</b>: AddIgnoreZonesForPage() AddTextZonesForPage() AddDPI() GetOCRJsonFromImage() GetOCRXmlFromImage().</p>
	* @param value The new value for UsePDFPageCoords.
	* @return This object, for call chaining.
	*/
	OCROptions& SetUsePDFPageCoords(bool value);

	// @cond PRIVATE_DOC
	#ifndef SWIGHIDDEN
	SDF::Obj& GetInternalObj();

private:
	
	SDF::ObjSet m_obj_set;
	SDF::Obj m_dict;
	#endif
	// @endcond
};

}
}

#include "../Impl/OCROptions.inl"
#endif // PDFTRON_H_CPPPDFOCROptions
