#!/bin/sh
TEST_NAME=ContentReplacerTest
ver=$(dotnet --version)
net="0"
if [ $(echo $ver | grep -E "9\..*") ]; then net="net9\.0";
elif [ $(echo $ver | grep -E "8\..*") ]; then net="net8\.0";
elif [ $(echo $ver | grep -E "7\..*") ]; then net="net7\.0";
elif [ $(echo $ver | grep -E  "6\..*") ]; then net="net6\.0";
elif [ $(echo $ver | grep -E  "5\..*") ]; then net="net5\.0";
elif [ $(echo $ver | grep -E  "3\..*") ]; then net="netcoreapp2\.1";
elif [ $(echo $ver | grep -E  "2\..*") ]; then net="netcoreapp2\.1";
fi
if [ "$net" != "0" ]; then
    sed -e "s/<TargetFramework>netcoreapp2\.1/<TargetFramework>$net/" -e "s/<TargetFramework>net5\.0/<TargetFramework>$net/g" -e "s/<TargetFramework>net6\.0/<TargetFramework>$net/g" -e "s/<TargetFramework>net7\.0/<TargetFramework>$net/g" -e "s/<TargetFramework>net8\.0/<TargetFramework>$net/g" -e "s/<TargetFramework>net9\.0/<TargetFramework>$net/g" ${TEST_NAME}.csproj > ${TEST_NAME}.tmp
    rm -f ${TEST_NAME}.csproj
    mv ${TEST_NAME}.tmp ${TEST_NAME}.csproj
fi
dotnet run
exit $?
