//---------------------------------------------------------------------------------------
// Copyright (c) 2001-2025 by Apryse Software Inc. All Rights Reserved.
// Consult legal.txt regarding legal and license information.
//---------------------------------------------------------------------------------------

#include <iostream>
#include <PDF/PDFNet.h>
#include <PDF/DataExtractionModule.h>
#include "../../LicenseKey/CPP/LicenseKey.h"

#include <PDF/PDFUA/PDFUAConformance.h>
#include <PDF/PDFUA/PDFUAOptions.h>


using namespace std;
using namespace pdftron;
using namespace pdftron::PDF;
using namespace pdftron::PDF::PDFUA;



//---------------------------------------------------------------------------------------
// The following sample illustrates how to make sure a file meets the PDF/UA standard, using the PDFUAConformance class object.
// Note: this feature is currently experimental and subject to change
//
// DataExtractionModule is required (Mac users can use StructuredOutputModule instead)
// https://docs.apryse.com/documentation/core/info/modules/#data-extraction-module
// https://docs.apryse.com/documentation/core/info/modules/#structured-output-module (Mac)
//---------------------------------------------------------------------------------------
int main(int argc, char *argv[])
{
	// Relative path to the folder containing test files.
	static UString input_path("../../TestFiles/");
	static UString output_path("../../TestFiles/Output/");

	// DataExtraction library location, replace if desired, should point to a folder that includes the contents of <DataExtractionModuleRoot>/Lib.
	// If using default, unzip the DataExtraction zip to the parent folder of Samples, and merge with existing "Lib" folder.
	static UString extraction_module_path("../../../Lib/");

	UString input_file1 = input_path + "autotag_input.pdf";
	UString input_file2 = input_path + "table.pdf";
	UString output_file1 = output_path + "autotag_pdfua.pdf";
	UString output_file2 = output_path + "table_pdfua_linearized.pdf";

	int ret = 0;
	try
	{
		PDFNet::Initialize(LicenseKey);

		cout << "AutoConverting..." << endl;

		PDFNet::AddResourceSearchPath(extraction_module_path);
		if (!DataExtractionModule::IsModuleAvailable(DataExtractionModule::e_DocStructure))
		{
			cout << endl;
			cout << "Unable to run PDFUATest: Apryse SDK Data Extraction module not available." << endl;
			cout << "---------------------------------------------------------------" << endl;
			cout << "The Data Extraction module is an optional add-on, available for download" << endl;
			cout << "at https://apryse.com/. If you have already downloaded this" << endl;
			cout << "module, ensure that the SDK is able to find the required files" << endl;
			cout << "using the PDFNet::AddResourceSearchPath() function." << endl << endl;
			return 1;
		}

		PDFUAConformance pdf_ua;

		cout << "Simple Conversion..." << endl;
		{
			// Perform conversion using default options
			pdf_ua.AutoConvert(input_file1, output_file1);
		}

		cout << "Converting With Options..." << endl;
		{
			PDFUAOptions pdf_ua_opts;
			pdf_ua_opts.SetSaveLinearized(true); // Linearize when saving output
			// Note: if file is password protected, you can use pdf_ua_opts.SetPassword()

			// Perform conversion using the options we specify
			pdf_ua.AutoConvert(input_file2, output_file2, pdf_ua_opts);
		}
	}
	catch (Common::Exception& e)
	{
		cout << e << endl;
		ret = 1;
	}
	catch (...) {
		cout << "Unknown Exception" << endl;
		ret = 1;
	}

	cout << "PDFUAConformance test completed." << endl;
	PDFNet::Terminate();
	return ret;
}