//
// Copyright (c) 2001-2025 by Apryse Software Inc. All Rights Reserved.
//

using System;
using pdftron;
using pdftron.SDF;
using pdftron.PDF;
using pdftron.PDF.PDFUA;

//---------------------------------------------------------------------------------------
// The following sample illustrates how to make sure a file meets the PDF/UA standard, using the PDFUAConformance class object.
// Note: this feature is currently experimental and subject to change
//
// DataExtractionModule is required (Mac users can use StructuredOutputModule instead)
// https://docs.apryse.com/documentation/core/info/modules/#data-extraction-module
// https://docs.apryse.com/documentation/core/info/modules/#structured-output-module (Mac)
//---------------------------------------------------------------------------------------
namespace PDFUATestCS
{
	class PDFUATest
	{
		private static pdftron.PDFNetLoader pdfNetLoader = pdftron.PDFNetLoader.Instance();
		static PDFUATest() {}
		
		// Relative path to the folder containing test files.
		static string input_path =  "../../TestFiles/";
		static string output_path = "../../TestFiles/Output/";

		// DataExtraction library location, replace if desired, should point to a folder that includes the contents of <DataExtractionModuleRoot>/Lib.
		// If using default, unzip the DataExtraction zip to the parent folder of Samples, and merge with existing "Lib" folder
		static string extraction_module_path = "../../../Lib/";


		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main(string[] args)
		{
			try {
				PDFNet.Initialize(PDFTronLicense.Key);

				String input_file1 = input_path + "autotag_input.pdf";
				String input_file2 = input_path + "table.pdf";
				String output_file1 = output_path + "autotag_pdfua.pdf";
				String output_file2 = output_path + "table_pdfua_linearized.pdf";

				//-----------------------------------------------------------
				// Example: PDF/UA Conversion
				//-----------------------------------------------------------
				Console.WriteLine("AutoConverting...");

				PDFNet.AddResourceSearchPath(extraction_module_path);
				if(!DataExtractionModule.IsModuleAvailable(DataExtractionModule.DataExtractionEngine.e_doc_structure))
				{
					Console.Error.WriteLine("Unable to run PDFUATest: Apryse SDK Data Extraction module not available.");
					Console.Error.WriteLine("---------------------------------------------------------------");
					Console.Error.WriteLine("The Data Extraction module is an optional add-on, available for download");
					Console.Error.WriteLine("at https://apryse.com/. If you have already downloaded this");
					Console.Error.WriteLine("module, ensure that the SDK is able to find the required files");
					Console.Error.WriteLine("using the PDFNet::AddResourceSearchPath() function.");
					Console.Error.WriteLine("");
					return;
				}

				PDFUAConformance pdf_ua = new PDFUAConformance();

				Console.WriteLine("Simple Conversion...");
				{
					// Perform conversion using default options
					pdf_ua.AutoConvert(input_file1, output_file1);
				}

				Console.WriteLine("Converting With Options...");
				{
					PDFUAOptions pdf_ua_opts = new PDFUAOptions();
					pdf_ua_opts.SetSaveLinearized(true); // Linearize when saving output
					// Note: if file is password protected, you can use pdf_ua_opts.setPassword()

					// Perform conversion using the options we specify
					pdf_ua.AutoConvert(input_file2, output_file2, pdf_ua_opts);
				}

			}
			catch (pdftron.Common.PDFNetException e)
			{
				Console.Error.WriteLine(e.GetMessage());
				Environment.Exit(-1);
			}
			finally
			{
				PDFNet.Terminate();
				Console.WriteLine("PDFUAConformance test completed.");
			}
		}
	}
}
