/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.pdf;

import com.pdftron.common.PDFNetException;
import com.pdftron.helpers.ReachabilityHelper;
import com.pdftron.pdf.Action;
import com.pdftron.pdf.Annot;
import com.pdftron.pdf.Field;
import com.pdftron.pdf.Page;

public class ActionParameter
implements AutoCloseable {
    private Action mAction;
    long impl;

    public ActionParameter(Action action, Field field) throws PDFNetException {
        this.impl = ActionParameter.ActionParameterCreateWithField(action.impl, field.impl);
        ReachabilityHelper.ensureReachable(field);
        this.mAction = action;
    }

    public ActionParameter(Action action, Annot annot) throws PDFNetException {
        this.impl = ActionParameter.ActionParameterCreateWithAnnot(action.impl, annot.impl);
        ReachabilityHelper.ensureReachable(annot);
        this.mAction = action;
    }

    public ActionParameter(Action action, Page page) throws PDFNetException {
        this.impl = ActionParameter.ActionParameterCreateWithPage(action.impl, page.impl);
        ReachabilityHelper.ensureReachable(page);
        this.mAction = action;
    }

    public ActionParameter(Action action) throws PDFNetException {
        this.impl = ActionParameter.ActionParameterCreate(action.impl);
        this.mAction = action;
    }

    public Action getAction() throws PDFNetException {
        return this.mAction;
    }

    public void destroy() throws PDFNetException {
        if (this.impl != 0L) {
            ActionParameter.Destroy(this.impl);
            this.impl = 0L;
        }
    }

    protected void finalize() throws Throwable {
        this.destroy();
    }

    ActionParameter(long l) {
        this.impl = l;
    }

    public static ActionParameter __Create(long l) {
        return new ActionParameter(l);
    }

    public long __GetHandle() {
        return this.impl;
    }

    @Override
    public void close() throws PDFNetException {
        this.destroy();
    }

    static native void Destroy(long var0);

    static native long ActionParameterCreateWithField(long var0, long var2);

    static native long ActionParameterCreateWithAnnot(long var0, long var2);

    static native long ActionParameterCreateWithPage(long var0, long var2);

    static native long ActionParameterCreate(long var0);
}

