/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.pdf;

import com.pdftron.common.PDFNetException;
import com.pdftron.helpers.ReachabilityHelper;
import com.pdftron.pdf.Action;
import com.pdftron.pdf.PDFDoc;
import com.pdftron.sdf.Obj;

public class Bookmark {
    long impl;
    Object ref;

    public static Bookmark create(PDFDoc pDFDoc, String string) throws PDFNetException {
        Bookmark bookmark = new Bookmark(Bookmark.Create(pDFDoc.__GetHandle(), string), pDFDoc);
        ReachabilityHelper.ensureReachable(pDFDoc);
        return bookmark;
    }

    public Bookmark() {
        this.impl = 0L;
        this.ref = null;
    }

    public Bookmark(Obj obj) {
        this.impl = obj.__GetHandle();
        this.ref = obj.__GetRefHandle();
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass().equals(this.getClass())) {
            return ((Bookmark)object).impl == this.impl;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.impl;
    }

    public boolean isValid() throws PDFNetException {
        return Bookmark.IsValid(this.impl);
    }

    public boolean hasChildren() throws PDFNetException {
        return Bookmark.HasChildren(this.impl);
    }

    public Bookmark getNext() throws PDFNetException {
        return new Bookmark(Bookmark.GetNext(this.impl), this.ref);
    }

    public Bookmark getPrev() throws PDFNetException {
        return new Bookmark(Bookmark.GetPrev(this.impl), this.ref);
    }

    public Bookmark getFirstChild() throws PDFNetException {
        return new Bookmark(Bookmark.GetFirstChild(this.impl), this.ref);
    }

    public Bookmark getLastChild() throws PDFNetException {
        return new Bookmark(Bookmark.GetLastChild(this.impl), this.ref);
    }

    public Bookmark getParent() throws PDFNetException {
        return new Bookmark(Bookmark.GetParent(this.impl), this.ref);
    }

    public Bookmark find(String string) throws PDFNetException {
        return new Bookmark(Bookmark.Find(this.impl, string), this.ref);
    }

    public Bookmark addChild(String string) throws PDFNetException {
        return new Bookmark(Bookmark.AddChild(this.impl, string), this.ref);
    }

    public void addChild(Bookmark bookmark) throws PDFNetException {
        Bookmark.AddChild(this.impl, bookmark.impl);
        ReachabilityHelper.ensureReachable(bookmark);
    }

    public Bookmark addNext(String string) throws PDFNetException {
        return new Bookmark(Bookmark.AddNext(this.impl, string), this.ref);
    }

    public void addNext(Bookmark bookmark) throws PDFNetException {
        Bookmark.AddNext(this.impl, bookmark.impl);
        ReachabilityHelper.ensureReachable(bookmark);
    }

    public Bookmark addPrev(String string) throws PDFNetException {
        return new Bookmark(Bookmark.AddPrev(this.impl, string), this.ref);
    }

    public void addPrev(Bookmark bookmark) throws PDFNetException {
        Bookmark.AddPrev(this.impl, bookmark.impl);
        ReachabilityHelper.ensureReachable(bookmark);
    }

    public void delete() throws PDFNetException {
        Bookmark.Delete(this.impl);
    }

    public void unlink() throws PDFNetException {
        Bookmark.Unlink(this.impl);
    }

    public int getIndent() throws PDFNetException {
        return Bookmark.GetIndent(this.impl);
    }

    public boolean isOpen() throws PDFNetException {
        return Bookmark.IsOpen(this.impl);
    }

    public void setOpen(boolean bl) throws PDFNetException {
        Bookmark.SetOpen(this.impl, bl);
    }

    public int getOpenCount() throws PDFNetException {
        return Bookmark.GetOpenCount(this.impl);
    }

    public String getTitle() throws PDFNetException {
        return Bookmark.GetTitle(this.impl);
    }

    public Obj getTitleObj() throws PDFNetException {
        return Obj.__Create(Bookmark.GetTitleObj(this.impl), this.ref);
    }

    public void setTitle(String string) throws PDFNetException {
        Bookmark.SetTitle(this.impl, string);
    }

    public Action getAction() throws PDFNetException {
        return new Action(Bookmark.GetAction(this.impl), this.ref);
    }

    public void setAction(Action action) throws PDFNetException {
        Bookmark.SetAction(this.impl, action.impl);
        ReachabilityHelper.ensureReachable(action);
    }

    public void removeAction() throws PDFNetException {
        Bookmark.RemoveAction(this.impl);
    }

    public int getFlags() throws PDFNetException {
        return Bookmark.GetFlags(this.impl);
    }

    public void setFlags(int n) throws PDFNetException {
        Bookmark.SetFlags(this.impl, n);
    }

    public double[] getColor() throws PDFNetException {
        return Bookmark.GetColor(this.impl);
    }

    public void setColor() throws PDFNetException {
        Bookmark.SetColor(this.impl, 0.0, 0.0, 0.0);
    }

    public void setColor(double d, double d2, double d3) throws PDFNetException {
        Bookmark.SetColor(this.impl, d, d2, d3);
    }

    public Obj getSDFObj() {
        return Obj.__Create(this.impl, this.ref);
    }

    Bookmark(long l, Object object) {
        this.impl = l;
        this.ref = object;
    }

    static native long Create(long var0, String var2);

    static native boolean IsValid(long var0);

    static native boolean HasChildren(long var0);

    static native long GetNext(long var0);

    static native long GetPrev(long var0);

    static native long GetFirstChild(long var0);

    static native long GetLastChild(long var0);

    static native long GetParent(long var0);

    static native long Find(long var0, String var2);

    static native long AddChild(long var0, String var2);

    static native void AddChild(long var0, long var2);

    static native long AddNext(long var0, String var2);

    static native void AddNext(long var0, long var2);

    static native long AddPrev(long var0, String var2);

    static native void AddPrev(long var0, long var2);

    static native void Delete(long var0);

    static native void Unlink(long var0);

    static native int GetIndent(long var0);

    static native boolean IsOpen(long var0);

    static native void SetOpen(long var0, boolean var2);

    static native int GetOpenCount(long var0);

    static native String GetTitle(long var0);

    static native long GetTitleObj(long var0);

    static native void SetTitle(long var0, String var2);

    static native long GetAction(long var0);

    static native void SetAction(long var0, long var2);

    static native void RemoveAction(long var0);

    static native int GetFlags(long var0);

    static native void SetFlags(long var0, int var2);

    static native double[] GetColor(long var0);

    static native void SetColor(long var0, double var2, double var4, double var6);
}

