/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.pdf;

import com.pdftron.common.PDFNetException;
import com.pdftron.helpers.ReachabilityHelper;
import com.pdftron.pdf.Page;
import com.pdftron.sdf.Obj;

public class Destination {
    public static final int e_XYZ = 0;
    public static final int e_Fit = 1;
    public static final int e_FitH = 2;
    public static final int e_FitV = 3;
    public static final int e_FitR = 4;
    public static final int e_FitB = 5;
    public static final int e_FitBH = 6;
    public static final int e_FitBV = 7;
    long impl;
    Object ref;

    public static Destination createXYZ(Page page, double d, double d2, double d3) throws PDFNetException {
        Destination destination = new Destination(Destination.CreateXYZ(page.impl, d, d2, d3), page.ref);
        ReachabilityHelper.ensureReachable(page);
        return destination;
    }

    public static Destination createFit(Page page) throws PDFNetException {
        Destination destination = new Destination(Destination.CreateFit(page.impl), page.ref);
        ReachabilityHelper.ensureReachable(page);
        return destination;
    }

    public static Destination createFitH(Page page, double d) throws PDFNetException {
        Destination destination = new Destination(Destination.CreateFitH(page.impl, d), page.ref);
        ReachabilityHelper.ensureReachable(page);
        return destination;
    }

    public static Destination createFitV(Page page, double d) throws PDFNetException {
        Destination destination = new Destination(Destination.CreateFitV(page.impl, d), page.ref);
        ReachabilityHelper.ensureReachable(page);
        return destination;
    }

    public static Destination createFitR(Page page, double d, double d2, double d3, double d4) throws PDFNetException {
        Destination destination = new Destination(Destination.CreateFitR(page.impl, d, d2, d3, d4), page.ref);
        ReachabilityHelper.ensureReachable(page);
        return destination;
    }

    public static Destination createFitB(Page page) throws PDFNetException {
        Destination destination = new Destination(Destination.CreateFitB(page.impl), page.ref);
        ReachabilityHelper.ensureReachable(page);
        return destination;
    }

    public static Destination createFitBH(Page page, double d) throws PDFNetException {
        Destination destination = new Destination(Destination.CreateFitBH(page.impl, d), page.ref);
        ReachabilityHelper.ensureReachable(page);
        return destination;
    }

    public static Destination createFitBV(Page page, double d) throws PDFNetException {
        Destination destination = new Destination(Destination.CreateFitBV(page.impl, d), page.ref);
        ReachabilityHelper.ensureReachable(page);
        return destination;
    }

    public Destination(Obj obj) {
        this.impl = Destination.Create(obj.__GetHandle());
        this.ref = obj.__GetRefHandle();
    }

    public boolean isValid() throws PDFNetException {
        return Destination.IsValid(this.impl);
    }

    public int getFitType() throws PDFNetException {
        return Destination.GetFitType(this.impl);
    }

    public Page getPage() throws PDFNetException {
        return new Page(Destination.GetPage(this.impl), this.ref);
    }

    public void setPage(Page page) throws PDFNetException {
        Destination.SetPage(this.impl, page.impl);
        ReachabilityHelper.ensureReachable(page);
    }

    public Obj getSDFObj() {
        return Obj.__Create(this.impl, this.ref);
    }

    public Obj getExplicitDestObj() throws PDFNetException {
        return Obj.__Create(Destination.GetExplicitDestObj(this.impl), this.ref);
    }

    Destination(long l, Object object) {
        this.impl = l;
        this.ref = object;
    }

    static native long CreateXYZ(long var0, double var2, double var4, double var6);

    static native long CreateFit(long var0);

    static native long CreateFitH(long var0, double var2);

    static native long CreateFitV(long var0, double var2);

    static native long CreateFitR(long var0, double var2, double var4, double var6, double var8);

    static native long CreateFitB(long var0);

    static native long CreateFitBH(long var0, double var2);

    static native long CreateFitBV(long var0, double var2);

    static native long Create(long var0);

    static native boolean IsValid(long var0);

    static native int GetFitType(long var0);

    static native long GetPage(long var0);

    static native void SetPage(long var0, long var2);

    static native long GetExplicitDestObj(long var0);
}

