/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.pdf;

import com.pdftron.common.PDFNetException;
import com.pdftron.helpers.ReachabilityHelper;
import com.pdftron.sdf.Doc;

public class HTML2PDF
implements AutoCloseable {
    long impl = HTML2PDF.HTML2PDFCreate();

    public static boolean convert(Doc doc, String string) throws PDFNetException {
        boolean bl = HTML2PDF.Convert(doc.__GetHandle(), string);
        ReachabilityHelper.ensureReachable(doc);
        return bl;
    }

    public static boolean convert(Doc doc, String string, WebPageSettings webPageSettings) throws PDFNetException {
        boolean bl = HTML2PDF.Convert(doc.__GetHandle(), string, webPageSettings.impl);
        ReachabilityHelper.ensureReachable(doc);
        ReachabilityHelper.ensureReachable(webPageSettings);
        return bl;
    }

    public void insertFromURL(String string) throws PDFNetException {
        HTML2PDF.InsertFromURL(this.impl, string);
    }

    public void insertFromURL(String string, WebPageSettings webPageSettings) throws PDFNetException {
        HTML2PDF.InsertFromURL(this.impl, string, webPageSettings.impl);
        ReachabilityHelper.ensureReachable(webPageSettings);
    }

    public void insertFromHtmlString(String string) throws PDFNetException {
        HTML2PDF.InsertFromHtmlString(this.impl, string);
    }

    public void insertFromHtmlString(String string, WebPageSettings webPageSettings) throws PDFNetException {
        HTML2PDF.InsertFromHtmlString(this.impl, string, webPageSettings.impl);
        ReachabilityHelper.ensureReachable(webPageSettings);
    }

    public void insertTOC() throws PDFNetException {
        HTML2PDF.InsertTOC(this.impl);
    }

    public void insertTOC(TOCSettings tOCSettings) throws PDFNetException {
        HTML2PDF.InsertTOC(this.impl, tOCSettings.impl);
        ReachabilityHelper.ensureReachable(tOCSettings);
    }

    public boolean convert(Doc doc) throws PDFNetException {
        boolean bl = HTML2PDF.Convert(this.impl, doc.__GetHandle());
        ReachabilityHelper.ensureReachable(doc);
        return bl;
    }

    public int getHTTPErrorCode() throws PDFNetException {
        return HTML2PDF.GetHTTPErrorCode(this.impl);
    }

    public void setQuiet(boolean bl) throws PDFNetException {
        HTML2PDF.SetQuiet(this.impl, bl);
    }

    public void setCompatibilityMode(boolean bl) throws PDFNetException {
        HTML2PDF.SetCompatibilityMode(this.impl, bl);
    }

    public void setSandbox(boolean bl) throws PDFNetException {
        HTML2PDF.SetSandbox(this.impl, bl);
    }

    public void setLogFilePath(String string) throws PDFNetException {
        HTML2PDF.SetLogFilePath(this.impl, string);
    }

    public String getLog() throws PDFNetException {
        return HTML2PDF.GetLog(this.impl);
    }

    public static void setModulePath(String string) throws PDFNetException {
        HTML2PDF.SetModulePath(string);
    }

    public static boolean isModuleAvailable() throws PDFNetException {
        return HTML2PDF.IsModuleAvailable();
    }

    public void setPaperSize(int n) throws PDFNetException {
        HTML2PDF.SetPaperSize(this.impl, n);
    }

    public void setPaperSize(String string, String string2) throws PDFNetException {
        HTML2PDF.SetPaperSize(this.impl, string, string2);
    }

    public void setLandscape(boolean bl) throws PDFNetException {
        HTML2PDF.SetLandscape(this.impl, bl);
    }

    public void setDPI(int n) throws PDFNetException {
        HTML2PDF.SetDPI(this.impl, n);
    }

    public void setOutline(boolean bl, int n) throws PDFNetException {
        HTML2PDF.SetOutline(this.impl, bl, n);
    }

    public void dumpOutline(String string) throws PDFNetException {
        HTML2PDF.DumpOutline(this.impl, string);
    }

    public void setPDFCompression(boolean bl) throws PDFNetException {
        HTML2PDF.SetPDFCompression(this.impl, bl);
    }

    public void setMargins(String string, String string2, String string3, String string4) throws PDFNetException {
        HTML2PDF.SetMargins(this.impl, string, string2, string3, string4);
    }

    public void setHeader(String string) throws PDFNetException {
        HTML2PDF.SetHeader(this.impl, string);
    }

    public void setFooter(String string) throws PDFNetException {
        HTML2PDF.SetFooter(this.impl, string);
    }

    public void setImageDPI(int n) throws PDFNetException {
        HTML2PDF.SetImageDPI(this.impl, n);
    }

    public void setImageQuality(int n) throws PDFNetException {
        HTML2PDF.SetImageQuality(this.impl, n);
    }

    public void setCookieJar(String string) throws PDFNetException {
        HTML2PDF.SetCookieJar(this.impl, string);
    }

    public void addCookie(String string, String string2) throws PDFNetException {
        HTML2PDF.AddCookie(this.impl, string, string2);
    }

    public void setCustomHeader(String string, String string2) throws PDFNetException {
        HTML2PDF.SetCustomHeader(this.impl, string, string2);
    }

    static native void AddCookie(long var0, String var2, String var3);

    static native void SetCustomHeader(long var0, String var2, String var3);

    protected void finalize() throws Throwable {
        this.destroy();
    }

    public void destroy() {
        if (this.impl != 0L) {
            HTML2PDF.Destroy(this.impl);
            this.impl = 0L;
        }
    }

    @Override
    public void close() throws PDFNetException {
        this.destroy();
    }

    static native void SetCookieJar(long var0, String var2);

    static native void SetImageQuality(long var0, int var2);

    static native void InsertFromURL(long var0, String var2);

    static native void InsertFromURL(long var0, String var2, long var3);

    static native void InsertFromHtmlString(long var0, String var2);

    static native void InsertFromHtmlString(long var0, String var2, long var3);

    static native void InsertTOC(long var0);

    static native void InsertTOC(long var0, long var2);

    static native boolean Convert(long var0, long var2);

    static native boolean Convert(long var0, String var2);

    static native boolean Convert(long var0, String var2, long var3);

    static native int GetHTTPErrorCode(long var0);

    static native void SetQuiet(long var0, boolean var2);

    static native void SetCompatibilityMode(long var0, boolean var2);

    static native void SetSandbox(long var0, boolean var2);

    static native void SetLogFilePath(long var0, String var2);

    static native String GetLog(long var0);

    static native void SetModulePath(String var0);

    static native boolean IsModuleAvailable();

    static native long HTML2PDFCreate();

    static native void Destroy(long var0);

    static native void SetPaperSize(long var0, int var2);

    static native void SetPaperSize(long var0, String var2, String var3);

    static native void SetLandscape(long var0, boolean var2);

    static native void SetDPI(long var0, int var2);

    static native void SetOutline(long var0, boolean var2, int var3);

    static native void DumpOutline(long var0, String var2);

    static native void SetPDFCompression(long var0, boolean var2);

    static native void SetMargins(long var0, String var2, String var3, String var4, String var5);

    static native void SetHeader(long var0, String var2);

    static native void SetFooter(long var0, String var2);

    static native void SetImageDPI(long var0, int var2);

    static native long WebPageSettingsCreate();

    static native void WebPageSettingsDestroy(long var0);

    static native void SetPrintBackground(long var0, boolean var2);

    static native void SetLoadImages(long var0, boolean var2);

    static native void SetAllowJavaScript(long var0, boolean var2);

    static native void SetSmartShrinking(long var0, boolean var2);

    static native void SetMinimumFontSize(long var0, int var2);

    static native void SetDefaultEncoding(long var0, String var2);

    static native void SetUserStyleSheet(long var0, String var2);

    static native void SetAllowPlugins(long var0, boolean var2);

    static native void SetPrintMediaType(long var0, boolean var2);

    static native void SetIncludeInOutline(long var0, boolean var2);

    static native void SetUsername(long var0, String var2);

    static native void SetPassword(long var0, String var2);

    static native void SetJavaScriptDelay(long var0, int var2);

    static native void SetConvertDelay(long var0, int var2);

    static native void SetTimeout(long var0, int var2);

    static native void SetZoom(long var0, double var2);

    static native void SetBlockLocalFileAccess(long var0, boolean var2);

    static native void SetStopSlowScripts(long var0, boolean var2);

    static native void SetDebugJavaScriptOutput(long var0, boolean var2);

    static native void SetLoadErrorHandling(long var0, int var2);

    static native void SetExternalLinks(long var0, boolean var2);

    static native void SetInternalLinks(long var0, boolean var2);

    static native void SetProduceForms(long var0, boolean var2);

    static native void SetProxy(long var0, long var2);

    static native long ProxyCreate();

    static native void ProxyDestroy(long var0);

    static native void ProxySetType(long var0, int var2);

    static native void ProxySetHost(long var0, String var2);

    static native void ProxySetPort(long var0, int var2);

    static native void ProxySetUsername(long var0, String var2);

    static native void ProxySetPassword(long var0, String var2);

    static native long TOCCreate();

    static native void TOCDestroy(long var0);

    static native void SetDottedLines(long var0, boolean var2);

    static native void SetLinks(long var0, boolean var2);

    static native void SetCaptionText(long var0, String var2);

    static native void SetLevelIndentation(long var0, int var2);

    static native void SetTextSizeShrink(long var0, double var2);

    static native void SetXsl(long var0, String var2);

    public static class TOCSettings
    implements AutoCloseable {
        long impl = HTML2PDF.TOCCreate();

        protected void finalize() throws Throwable {
            this.destroy();
        }

        public void destroy() {
            if (this.impl != 0L) {
                HTML2PDF.TOCDestroy(this.impl);
                this.impl = 0L;
            }
        }

        public void setDottedLines(boolean bl) throws PDFNetException {
            HTML2PDF.SetDottedLines(this.impl, bl);
        }

        public void setLinks(boolean bl) throws PDFNetException {
            HTML2PDF.SetLinks(this.impl, bl);
        }

        public void setCaptionText(String string) throws PDFNetException {
            HTML2PDF.SetCaptionText(this.impl, string);
        }

        public void setLevelIndentation(int n) throws PDFNetException {
            HTML2PDF.SetLevelIndentation(this.impl, n);
        }

        public void setTextSizeShrink(double d) throws PDFNetException {
            HTML2PDF.SetTextSizeShrink(this.impl, d);
        }

        public void setXsl(String string) throws PDFNetException {
            HTML2PDF.SetXsl(this.impl, string);
        }

        @Override
        public void close() throws PDFNetException {
            this.destroy();
        }
    }

    public static class WebPageSettings
    implements AutoCloseable {
        public static final int e_abort = 0;
        public static final int e_skip = 1;
        public static final int e_ignore = 2;
        long impl = HTML2PDF.WebPageSettingsCreate();

        protected void finalize() throws Throwable {
            this.destroy();
        }

        public void destroy() {
            if (this.impl != 0L) {
                HTML2PDF.WebPageSettingsDestroy(this.impl);
                this.impl = 0L;
            }
        }

        public void setPrintBackground(boolean bl) throws PDFNetException {
            HTML2PDF.SetPrintBackground(this.impl, bl);
        }

        public void setLoadImages(boolean bl) throws PDFNetException {
            HTML2PDF.SetLoadImages(this.impl, bl);
        }

        public void setAllowJavaScript(boolean bl) throws PDFNetException {
            HTML2PDF.SetAllowJavaScript(this.impl, bl);
        }

        public void setSmartShrinking(boolean bl) throws PDFNetException {
            HTML2PDF.SetSmartShrinking(this.impl, bl);
        }

        public void setMinimumFontSize(int n) throws PDFNetException {
            HTML2PDF.SetMinimumFontSize(this.impl, n);
        }

        public void setDefaultEncoding(String string) throws PDFNetException {
            HTML2PDF.SetDefaultEncoding(this.impl, string);
        }

        public void setUserStyleSheet(String string) throws PDFNetException {
            HTML2PDF.SetUserStyleSheet(this.impl, string);
        }

        public void setAllowPlugins(boolean bl) throws PDFNetException {
            HTML2PDF.SetAllowPlugins(this.impl, bl);
        }

        public void setPrintMediaType(boolean bl) throws PDFNetException {
            HTML2PDF.SetPrintMediaType(this.impl, bl);
        }

        public void setIncludeInOutline(boolean bl) throws PDFNetException {
            HTML2PDF.SetIncludeInOutline(this.impl, bl);
        }

        public void setUsername(String string) throws PDFNetException {
            HTML2PDF.SetUsername(this.impl, string);
        }

        public void setPassword(String string) throws PDFNetException {
            HTML2PDF.SetPassword(this.impl, string);
        }

        public void setJavaScriptDelay(int n) throws PDFNetException {
            HTML2PDF.SetJavaScriptDelay(this.impl, n);
        }

        public void setConvertDelay(int n) throws PDFNetException {
            HTML2PDF.SetConvertDelay(this.impl, n);
        }

        public void setTimeout(int n) throws PDFNetException {
            HTML2PDF.SetTimeout(this.impl, n);
        }

        public void setZoom(double d) throws PDFNetException {
            HTML2PDF.SetZoom(this.impl, d);
        }

        public void setBlockLocalFileAccess(boolean bl) throws PDFNetException {
            HTML2PDF.SetBlockLocalFileAccess(this.impl, bl);
        }

        public void setStopSlowScripts(boolean bl) throws PDFNetException {
            HTML2PDF.SetStopSlowScripts(this.impl, bl);
        }

        public void setDebugJavaScriptOutput(boolean bl) throws PDFNetException {
            HTML2PDF.SetDebugJavaScriptOutput(this.impl, bl);
        }

        public void setLoadErrorHandling(int n) throws PDFNetException {
            HTML2PDF.SetLoadErrorHandling(this.impl, n);
        }

        public void setExternalLinks(boolean bl) throws PDFNetException {
            HTML2PDF.SetExternalLinks(this.impl, bl);
        }

        public void setInternalLinks(boolean bl) throws PDFNetException {
            HTML2PDF.SetInternalLinks(this.impl, bl);
        }

        public void setProduceForms(boolean bl) throws PDFNetException {
            HTML2PDF.SetProduceForms(this.impl, bl);
        }

        public void setProxy(Proxy proxy) throws PDFNetException {
            HTML2PDF.SetProxy(this.impl, proxy.impl);
            ReachabilityHelper.ensureReachable(proxy);
        }

        @Override
        public void close() throws PDFNetException {
            this.destroy();
        }
    }

    public static class Proxy
    implements AutoCloseable {
        public static final int e_default = 0;
        public static final int e_none = 1;
        public static final int e_http = 2;
        public static final int e_socks5 = 3;
        long impl = HTML2PDF.ProxyCreate();

        protected void finalize() throws Throwable {
            this.destroy();
        }

        public void destroy() {
            if (this.impl != 0L) {
                HTML2PDF.ProxyDestroy(this.impl);
                this.impl = 0L;
            }
        }

        public void setType(int n) throws PDFNetException {
            HTML2PDF.ProxySetType(this.impl, n);
        }

        public void setHost(String string) throws PDFNetException {
            HTML2PDF.ProxySetHost(this.impl, string);
        }

        public void setPort(int n) throws PDFNetException {
            HTML2PDF.ProxySetPort(this.impl, n);
        }

        public void setUsername(String string) throws PDFNetException {
            HTML2PDF.ProxySetUsername(this.impl, string);
        }

        public void setPassword(String string) throws PDFNetException {
            HTML2PDF.ProxySetPassword(this.impl, string);
        }

        @Override
        public void close() throws PDFNetException {
            this.destroy();
        }
    }
}

