/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.pdf;

import com.pdftron.helpers.BitmapHelper;
import com.pdftron.helpers.ReachabilityHelper;
import com.pdftron.pdf.Annot;
import com.pdftron.pdf.Highlights;
import com.pdftron.pdf.Page;
import com.pdftron.pdf.Rect;
import com.pdftron.pdf.ocg.Context;
import com.pdftron.sdf.Obj;
import java.awt.Color;

public class TextExtractor
implements AutoCloseable {
    public static final int e_no_ligature_exp = 1;
    public static final int e_no_dup_remove = 2;
    public static final int e_punct_break = 4;
    public static final int e_remove_hidden_text = 8;
    public static final int e_no_invisible_text = 16;
    public static final int e_no_watermarks = 128;
    public static final int e_extract_using_zorder = 256;
    public static final int e_words_as_elements = 1;
    public static final int e_output_bbox = 2;
    public static final int e_output_style_info = 4;
    Object ref;
    Object ctx_ref = null;
    long impl = TextExtractor.TextExtractorCreate();

    public void destroy() {
        if (this.impl != 0L) {
            TextExtractor.Destroy(this.impl);
            this.impl = 0L;
        }
    }

    protected void finalize() throws Throwable {
        this.destroy();
    }

    @Override
    public void close() {
        this.destroy();
    }

    public void begin(Page page) {
        TextExtractor.Begin(this.impl, page.impl, 0L, 0);
        this.ref = page.ref;
    }

    public void begin(Page page, Rect rect) {
        long l = 0L;
        if (rect != null) {
            l = rect.impl;
        }
        TextExtractor.Begin(this.impl, page.impl, l, 0);
        ReachabilityHelper.ensureReachable(rect);
        this.ref = page.ref;
    }

    public void begin(Page page, Rect rect, int n) {
        long l = 0L;
        if (rect != null) {
            l = rect.impl;
        }
        TextExtractor.Begin(this.impl, page.impl, l, n);
        ReachabilityHelper.ensureReachable(rect);
        this.ref = page.ref;
    }

    public int getWordCount() {
        return TextExtractor.GetWordCount(this.impl);
    }

    public String getAsText() {
        return TextExtractor.GetAsText(this.impl, true);
    }

    public String getAsText(boolean bl) {
        return TextExtractor.GetAsText(this.impl, bl);
    }

    public String getTextUnderAnnot(Annot annot) {
        String string = TextExtractor.GetTextUnderAnnot(this.impl, annot.__GetHandle());
        ReachabilityHelper.ensureReachable(annot);
        return string;
    }

    public String getAsXML() {
        return TextExtractor.GetAsXML(this.impl, 0);
    }

    public Highlights getHighlights(CharRange[] charRangeArray) {
        int n = charRangeArray.length;
        int[] nArray = new int[n * 2];
        for (int i = 0; i < n; ++i) {
            nArray[i * 2] = charRangeArray[i].index;
            nArray[i * 2 + 1] = charRangeArray[i].length;
        }
        Highlights highlights = TextExtractor.GetHighlights(this.impl, nArray);
        highlights.ctx_ref = this;
        return highlights;
    }

    public String getAsXML(int n) {
        return TextExtractor.GetAsXML(this.impl, n);
    }

    public int getNumLines() {
        return TextExtractor.GetNumLines(this.impl);
    }

    public Line getFirstLine() {
        return new Line(TextExtractor.GetFirstLine(this.impl), this.ref);
    }

    public boolean getRightToLeftLanguage() {
        return TextExtractor.GetRightToLeftLanguage(this.impl);
    }

    public void setRightToLeftLanguage(boolean bl) {
        TextExtractor.SetRightToLeftLanguage(this.impl, bl);
    }

    public void setOCGContext(Context context) {
        this.ctx_ref = context;
        if (context == null) {
            TextExtractor.SetOCGContext(this.impl, 0L);
        } else {
            TextExtractor.SetOCGContext(this.impl, context.__GetHandle());
            ReachabilityHelper.ensureReachable(context);
        }
    }

    static native int LineGetNumWords(long var0);

    static native boolean LineIsSimpleLine(long var0);

    static native long LineGetBBox(long var0);

    static native double[] LineGetQuad(long var0);

    static native long LineGetFirstWord(long var0);

    static native long LineGetWord(long var0, int var2);

    static native long LineGetNextLine(long var0);

    static native int LineGetCurrentNum(long var0);

    static native long LineGetStyle(long var0);

    static native int LineGetParagraphID(long var0);

    static native int LineGetFlowID(long var0);

    static native boolean LineEndsWithHyphen(long var0);

    static native boolean LineEquals(long var0, long var2);

    static native boolean LineIsValid(long var0);

    static native void LineDestroy(long var0);

    static native long TextExtractorCreate();

    static native void Destroy(long var0);

    static native void Begin(long var0, long var2, long var4, int var6);

    static native int GetWordCount(long var0);

    static native String GetAsText(long var0, boolean var2);

    static native String GetAsXML(long var0, int var2);

    static native Highlights GetHighlights(long var0, int[] var2);

    static native int GetNumLines(long var0);

    static native long GetFirstLine(long var0);

    static native String GetTextUnderAnnot(long var0, long var2);

    static native boolean GetRightToLeftLanguage(long var0);

    static native void SetRightToLeftLanguage(long var0, boolean var2);

    static native long StyleGetFont(long var0);

    static native String StyleGetFontName(long var0);

    static native double StyleGetFontSize(long var0);

    static native int StyleGetWeight(long var0);

    static native boolean StyleIsItalic(long var0);

    static native boolean StyleIsSerif(long var0);

    static native int[] StyleGetColor(long var0);

    static native boolean StyleEquals(long var0, long var2);

    static native void StyleDestroy(long var0);

    static native int WordGetNumGlyphs(long var0);

    static native long WordGetBBox(long var0);

    static native double[] WordGetQuad(long var0);

    static native double[] WordGetGlyphQuad(long var0, int var2);

    static native long WordGetCharStyle(long var0, int var2);

    static native long WordGetStyle(long var0);

    static native int WordGetStringLen(long var0);

    static native String WordGetString(long var0);

    static native long WordGetNextWord(long var0);

    static native int WordGetCurrentNum(long var0);

    static native boolean WordEquals(long var0, long var2);

    static native boolean WordIsValid(long var0);

    static native void WordDestroy(long var0);

    static native void SetOCGContext(long var0, long var2);

    public static class Compat {
        public static void SetRightToLeftLanguage(long l, boolean bl) {
            TextExtractor.SetRightToLeftLanguage(l, bl);
        }

        public static boolean GetRightToLeftLanguage(long l) {
            return TextExtractor.GetRightToLeftLanguage(l);
        }
    }

    public class Line
    implements AutoCloseable {
        Object ref;
        long impl;

        public void destroy() {
            if (this.impl != 0L) {
                TextExtractor.LineDestroy(this.impl);
                this.impl = 0L;
            }
        }

        protected void finalize() throws Throwable {
            this.destroy();
        }

        public int getNumWords() {
            return TextExtractor.LineGetNumWords(this.impl);
        }

        public boolean isSimpleLine() {
            return TextExtractor.LineIsSimpleLine(this.impl);
        }

        public Rect getBBox() {
            return new Rect(TextExtractor.LineGetBBox(this.impl));
        }

        public double[] getQuad() {
            return TextExtractor.LineGetQuad(this.impl);
        }

        public Word getFirstWord() {
            return new Word(TextExtractor.LineGetFirstWord(this.impl), this.ref);
        }

        public Word getWord(int n) {
            return new Word(TextExtractor.LineGetWord(this.impl, n), this.ref);
        }

        public Line getNextLine() {
            return new Line(TextExtractor.LineGetNextLine(this.impl), this.ref);
        }

        public int getCurrentNum() {
            return TextExtractor.LineGetCurrentNum(this.impl);
        }

        public Style getStyle() {
            return new Style(TextExtractor.LineGetStyle(this.impl), this.ref);
        }

        public int getParagraphID() {
            return TextExtractor.LineGetParagraphID(this.impl);
        }

        public int getFlowID() {
            return TextExtractor.LineGetFlowID(this.impl);
        }

        public boolean endsWithHyphen() {
            return TextExtractor.LineEndsWithHyphen(this.impl);
        }

        public boolean equals(Object object) {
            if (object != null && object.getClass().equals(this.getClass())) {
                boolean bl = TextExtractor.LineEquals(this.impl, ((Word)object).impl);
                ReachabilityHelper.ensureReachable(object);
                return bl;
            }
            return false;
        }

        public boolean isValid() {
            if (this.impl != 0L) {
                return TextExtractor.LineIsValid(this.impl);
            }
            return false;
        }

        Line(long l, Object object) {
            this.impl = l;
            this.ref = object;
        }

        @Override
        public void close() {
            this.destroy();
        }
    }

    public class Word
    implements AutoCloseable {
        Object ref;
        long impl;

        public void destroy() {
            if (this.impl != 0L) {
                TextExtractor.WordDestroy(this.impl);
                this.impl = 0L;
            }
        }

        protected void finalize() throws Throwable {
            this.destroy();
        }

        public int getNumGlyphs() {
            return TextExtractor.WordGetNumGlyphs(this.impl);
        }

        public Rect getBBox() {
            return new Rect(TextExtractor.WordGetBBox(this.impl));
        }

        public double[] getQuad() {
            return TextExtractor.WordGetQuad(this.impl);
        }

        public double[] getGlyphQuad(int n) {
            return TextExtractor.WordGetGlyphQuad(this.impl, n);
        }

        public Style getCharStyle(int n) {
            return new Style(TextExtractor.WordGetCharStyle(this.impl, n), this.ref);
        }

        public Style getStyle() {
            return new Style(TextExtractor.WordGetStyle(this.impl), this.ref);
        }

        public int getStringLen() {
            return TextExtractor.WordGetStringLen(this.impl);
        }

        public String getString() {
            return TextExtractor.WordGetString(this.impl);
        }

        public Word getNextWord() {
            return new Word(TextExtractor.WordGetNextWord(this.impl), this.ref);
        }

        public int getCurrentNum() {
            return TextExtractor.WordGetCurrentNum(this.impl);
        }

        public boolean equals(Object object) {
            if (object != null && object.getClass().equals(this.getClass())) {
                boolean bl = TextExtractor.WordEquals(this.impl, ((Word)object).impl);
                ReachabilityHelper.ensureReachable(object);
                return bl;
            }
            return false;
        }

        public boolean isValid() {
            if (this.impl != 0L) {
                return TextExtractor.WordIsValid(this.impl);
            }
            return false;
        }

        Word(long l, Object object) {
            this.impl = l;
            this.ref = object;
        }

        @Override
        public void close() {
            this.destroy();
        }
    }

    public class Style
    implements AutoCloseable {
        Object ref;
        long impl;

        Style(long l, Object object) {
            this.impl = l;
            this.ref = object;
        }

        public void destroy() {
            if (this.impl != 0L) {
                TextExtractor.StyleDestroy(this.impl);
                this.impl = 0L;
            }
        }

        protected void finalize() throws Throwable {
            this.destroy();
        }

        public Obj getFont() {
            return Obj.__Create(TextExtractor.StyleGetFont(this.impl), this.ref);
        }

        public String getFontName() {
            return TextExtractor.StyleGetFontName(this.impl);
        }

        public double getFontSize() {
            return TextExtractor.StyleGetFontSize(this.impl);
        }

        public int getWeight() {
            return TextExtractor.StyleGetWeight(this.impl);
        }

        public boolean isItalic() {
            return TextExtractor.StyleIsItalic(this.impl);
        }

        public boolean isSerif() {
            return TextExtractor.StyleIsSerif(this.impl);
        }

        public Color getColor() {
            int[] nArray = TextExtractor.StyleGetColor(this.impl);
            return BitmapHelper.getColor(nArray);
        }

        public boolean equals(Object object) {
            if (object != null && object.getClass().equals(this.getClass())) {
                boolean bl = TextExtractor.StyleEquals(this.impl, ((Style)object).impl);
                ReachabilityHelper.ensureReachable(object);
                return bl;
            }
            return false;
        }

        @Override
        public void close() {
            this.destroy();
        }
    }

    public class CharRange {
        public int index;
        public int length;

        public CharRange(int n, int n2) {
            this.index = n;
            this.length = n2;
        }
    }
}

