//---------------------------------------------------------------------------------------
// Copyright (c) 2001-2025 by Apryse Software Inc. All Rights Reserved.
// Consult legal.txt regarding legal and license information.
//---------------------------------------------------------------------------------------
// !Warning! This file is autogenerated, modify the .codegen file, not this one
// (any changes here will be wiped out during the autogen process)

#ifndef PDFTRON_H_CPPPDFDocumentConversion
#define PDFTRON_H_CPPPDFDocumentConversion
#include <C/PDF/TRN_DocumentConversion.h>

#include <Common/BasicTypes.h>
#include <Common/UString.h>
#include <PDF/PDFDoc.h>

namespace pdftron { namespace PDF { 


/**
 * The class DocumentConversion.
 * Encapsulates the conversion of a single document from one format to another.
 *
 * DocumentConversion instances are created through methods belonging to
 * the Convert class. See Convert.WordToPDFConversion for an example.
 */
class DocumentConversion
{
public:
	enum Result {
		eSuccess = 0,
		eIncomplete = 1,
		eFailure = 2
	};
	DocumentConversion();
	DocumentConversion(const DocumentConversion& other);
	DocumentConversion(TRN_DocumentConversion impl);
	DocumentConversion& operator= (const DocumentConversion& other);
	~DocumentConversion();
	void Destroy();
	
	/**
	 * Perform the conversion. If the result of the conversion is failure, then GetErrorString will contain further information about the failure.
	 * 
	 * @return Indicates that the conversion succeeded, failed, or was cancelled.
	 */
	Result TryConvert();
	
	/**
	 * Perform the conversion. Will throw an exception on failure.
	 * 
	 */
	void Convert();
	
	/**
	 * Perform the conversion. Will throw an exception on failure. Does nothing if the conversion is already complete. Use GetConversionStatus() to check if there is remaining content to be converted.
	 * 
	 */
	void ConvertNextPage();
	
	/**
	 * Gets the PDFDoc from the conversion. Can be accessed at any time during or after conversion.
	 * 
	 * @return The conversion's PDFDoc.
	 */
	PDFDoc GetDoc();
	
	/**
	 * Get the state of the conversion process. Pair this with ConvertNextPage().
	 * 
	 * @return .
	 */
	Result GetConversionStatus() const;
	
	/**
	 * Cancel the current conversion, forcing TryConvert or Convert to return.
	 * 
	 */
	void CancelConversion();
	
	/**
	 * Has the conversion been cancelled?.
	 * 
	 * @return Returns true if CancelConversion has been called previously.
	 */
	bool IsCancelled() const;
	
	/**
	 * Determine whether this DocumentConversion has progress reporting capability.
	 * 
	 * @return True if GetProgress is expected to return usable values.
	 */
	bool HasProgressTracking() const;
	
	/**
	 * Returns a number from 0.0 to 1.0, representing the best estimate of conversion progress. This number is only an indicator, and should not be used to dictate program logic (in particular, it is possible for this method to return 1.0 while there is still work to be done. Use GetConversionStatus() to find out when the conversion is fully complete).
	 * 
	 * @return The conversion progress. Will never return a smaller number than a previous call.
	 */
	double GetProgress() const;
	
	/**
	 * Returns the label for the current conversion stage. May return a blank string. Warning: experimental interface; this method may be renamed or replaced with equivalent functionality in the future.
	 * 
	 * @return The stage label.
	 */
	UString GetProgressLabel() const;
	
	/**
	 * Returns the number of pages which have been added to the destination document. Will never decrease, and will not change after the conversion status becomes "complete".
	 * 
	 * @return The number of pages that have been converted.
	 */
	UInt32 GetNumConvertedPages() const;
	
	/**
	 * If the conversion finsihed with some kind of error, this returns the value of the error description; otherwise returns an empty string.
	 * 
	 * @return The error description. Will be blank unless GetConversionStatus returns Failure.
	 */
	UString GetErrorString() const;
	
	/**
	 * Return the number of warning strings generated during the conversion process. Warning: experimental interface; this method may be renamed or replaced with equivalent functionality in the future.
	 * 
	 * @return The number of stored warning strings.
	 */
	UInt32 GetNumWarnings() const;
	
	/**
	 * Retrieve warning strings that have been collected during the conversion process. Warning: experimental interface; this method may be renamed or replaced with equivalent functionality in the future.
	 * 
	 * @param index -- the index of the string to be retrieved. Must be less than GetNumWarnings().
	 * @return The value of the particular warning string.
	 */
	UString GetWarningString(UInt32 index) const;
	
	/**
	 * Retrieve the name of the Excel sheet placed on the last converted page if any.
	 * 
	 * @return The name of the Excel sheet.
	 */
	UString GetCurrentExcelSheetName() const;
	
	/**
	 * Retrieve the number of cells in the Excel sheet that will be converted next.
	 * 
	 * @return The number of cells.
	 */
	UInt32 GetNextExcelSheetCellCount() const;
	
	/**
	 * Skip the next Excel sheet. The sheet will not be converted.
	 * 
	 */
	void SkipNextExcelSheet();

	//for xamarin use only
	static DocumentConversion* CreateInternal(ptrdiff_t impl);
	ptrdiff_t GetHandleInternal();



#ifndef SWIGHIDDEN
	TRN_DocumentConversion m_impl;
#endif

private:

};

#include <Impl/DocumentConversion.inl>
} //end pdftron
} //end PDF


#endif //PDFTRON_H_CPPPDFDocumentConversion
