//---------------------------------------------------------------------------------------
// Copyright (c) 2001-2025 by Apryse Software Inc. All Rights Reserved.
// Consult legal.txt regarding legal and license information.
//---------------------------------------------------------------------------------------
// !Warning! This file is autogenerated, modify the .codegen file, not this one
// (any changes here will be wiped out during the autogen process)

#ifndef PDFTRON_H_CPPPDFWebFontDownloader
#define PDFTRON_H_CPPPDFWebFontDownloader
#include <C/PDF/TRN_WebFontDownloader.h>
#include <Common/BasicTypes.h>
#include <Common/UString.h>
#include <PDF/PDFDoc.h>

namespace pdftron { namespace PDF { 
class PDFDoc;

/**
 * The class WebFontDownloader.
 * static interface to control the behaviour of PDFNet web font downloading
 */
class WebFontDownloader
{
public:
	
	//methods:
	
	/**
	 * Find out whether the web font downloader is available in version of PDFNet.
	 * 
	 * @return returns true if web font downloading can be done.
	 */
	static bool IsAvailable();
	
	/**
	 * Allow PDFNet to access the network to download missing fonts when possible.
	 * 
	 */
	static void EnableDownloads();
	
	/**
	 * Prevent PDFNet from accessing the network to download missing fonts. It may still use previously downloaded fonts (which are cached on disk).
	 * 
	 */
	static void DisableDownloads();
	
	/**
	 * download and cache a base collection of fonts in a background thread. Will not do anything if downloading is currently disabled.
	 * 
	 */
	static void PreCacheAsync();
	
	/**
	 * clear any pre-cached font files residing in persistent storage.
	 * 
	 */
	static void ClearCache();
	
	/**
	 * Set the root path into which the web font downloader will make requests. Http paths are not allowed.
	 * 
	 * @param url -- The root path into which the web font downloader will make requests.
	 */
	static void SetCustomWebFontURL(UString url);

};

#include <Impl/WebFontDownloader.inl>
} //end pdftron
} //end PDF


#endif //PDFTRON_H_CPPPDFWebFontDownloader
