/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.crypto;

import com.pdftron.common.PDFNetException;
import com.pdftron.crypto.AlgorithmParams;
import com.pdftron.crypto.DigestAlgorithm;
import com.pdftron.crypto.ObjectIdentifier;
import com.pdftron.helpers.ReachabilityHelper;

public class AlgorithmIdentifier
implements AutoCloseable {
    private long mImpl;

    public void destroy() throws PDFNetException {
        if (this.mImpl != 0L) {
            AlgorithmIdentifier.Destroy(this.mImpl);
            this.mImpl = 0L;
        }
    }

    protected void finalize() throws Throwable {
        this.destroy();
    }

    public AlgorithmIdentifier(long l) {
        this.mImpl = l;
    }

    public AlgorithmIdentifier(ObjectIdentifier.Predefined predefined) throws PDFNetException {
        this.mImpl = AlgorithmIdentifier.CreateFromPredefined(predefined.getValue());
    }

    public AlgorithmIdentifier(ObjectIdentifier objectIdentifier) throws PDFNetException {
        this.mImpl = AlgorithmIdentifier.CreateFromObjectIdentifier(objectIdentifier.__GetHandle());
        ReachabilityHelper.ensureReachable(objectIdentifier);
    }

    public AlgorithmIdentifier(DigestAlgorithm digestAlgorithm) throws PDFNetException {
        this.mImpl = AlgorithmIdentifier.CreateFromDigestAlgorithm(digestAlgorithm.value);
    }

    public AlgorithmIdentifier(ObjectIdentifier.Predefined predefined, AlgorithmParams algorithmParams) throws PDFNetException {
        this.mImpl = AlgorithmIdentifier.CreateFromPredefinedAndParams(predefined.getValue(), algorithmParams.__GetHandle());
        ReachabilityHelper.ensureReachable(algorithmParams);
    }

    public AlgorithmIdentifier(ObjectIdentifier objectIdentifier, AlgorithmParams algorithmParams) throws PDFNetException {
        this.mImpl = AlgorithmIdentifier.CreateFromObjectIdentifierAndParams(objectIdentifier.__GetHandle(), algorithmParams.__GetHandle());
        ReachabilityHelper.ensureReachable(objectIdentifier);
        ReachabilityHelper.ensureReachable(algorithmParams);
    }

    public AlgorithmIdentifier(DigestAlgorithm digestAlgorithm, AlgorithmParams algorithmParams) throws PDFNetException {
        this.mImpl = AlgorithmIdentifier.CreateFromDigestAlgorithmAndParams(digestAlgorithm.value, algorithmParams.__GetHandle());
        ReachabilityHelper.ensureReachable(algorithmParams);
    }

    public long __GetHandle() {
        return this.mImpl;
    }

    @Override
    public void close() throws PDFNetException {
        this.destroy();
    }

    static native void Destroy(long var0);

    static native long CreateFromPredefined(int var0);

    static native long CreateFromObjectIdentifier(long var0);

    static native long CreateFromDigestAlgorithm(int var0);

    static native long CreateFromPredefinedAndParams(int var0, long var1);

    static native long CreateFromObjectIdentifierAndParams(long var0, long var2);

    static native long CreateFromDigestAlgorithmAndParams(int var0, long var1);
}

