/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.layout;

import com.pdftron.common.PDFNetException;
import com.pdftron.layout.ContentNode;
import com.pdftron.layout.LayoutHelpers;
import com.pdftron.layout.Paragraph;
import com.pdftron.layout.Table;
import java.util.HashMap;

public class TableCell
extends ContentNode {
    TableCell(long l) {
        super(l);
    }

    public Paragraph addParagraph() throws PDFNetException {
        return new Paragraph(TableCell.AddParagraph(this.mImpl));
    }

    public Paragraph addParagraph(String string) throws PDFNetException {
        Paragraph paragraph = new Paragraph(TableCell.AddParagraph(this.mImpl));
        paragraph.addText(string);
        return paragraph;
    }

    public Table addTable() throws PDFNetException {
        return new Table(TableCell.AddTable(this.mImpl));
    }

    public TableCell mergeCellsRight(int n) throws PDFNetException {
        return new TableCell(TableCell.MergeCellsRight(this.mImpl, n));
    }

    public TableCell mergeCellsDown(int n) throws PDFNetException {
        return new TableCell(TableCell.MergeCellsDown(this.mImpl, n));
    }

    public void setBackgroundColor(int n, int n2, int n3) throws IllegalArgumentException, PDFNetException {
        LayoutHelpers.checkRgbColor(n, n2, n3);
        TableCell.SetBackgroundColor(this.mImpl, n, n2, n3);
    }

    public void setBorder(double d, int n, int n2, int n3) throws PDFNetException {
        TableCell.SetBorder(this.mImpl, d, n, n2, n3);
    }

    public double getBorderThickness() throws PDFNetException {
        return TableCell.GetBorderThickness(this.mImpl);
    }

    public void setVerticalAlignment(CellAlignmentVerticalVals cellAlignmentVerticalVals) throws PDFNetException {
        TableCell.SetVerticalAlignment(this.mImpl, cellAlignmentVerticalVals.value);
    }

    public CellAlignmentVerticalVals getVerticalAlignment() throws PDFNetException {
        return CellAlignmentVerticalVals.valueToEnum(TableCell.GetVerticalAlignment(this.mImpl));
    }

    public void setHorizontalAlignment(CellAlignmentHorizontalVals cellAlignmentHorizontalVals) throws PDFNetException {
        TableCell.SetHorizontalAlignment(this.mImpl, cellAlignmentHorizontalVals.value);
    }

    public CellAlignmentHorizontalVals getHorizontalAlignment() throws PDFNetException {
        return CellAlignmentHorizontalVals.valueToEnum(TableCell.GetHorizontalAlignment(this.mImpl));
    }

    public void setHeight(double d) throws PDFNetException {
        TableCell.SetHeight(this.mImpl, d);
    }

    public double getHeight() throws PDFNetException {
        return TableCell.GetHeight(this.mImpl);
    }

    public void setWidth(double d) throws PDFNetException {
        TableCell.SetWidth(this.mImpl, d);
    }

    public double getWidth() throws PDFNetException {
        return TableCell.GetWidth(this.mImpl);
    }

    static native long AddParagraph(long var0) throws PDFNetException;

    static native long AddTable(long var0) throws PDFNetException;

    static native long MergeCellsRight(long var0, int var2) throws PDFNetException;

    static native long MergeCellsDown(long var0, int var2) throws PDFNetException;

    static native void SetBackgroundColor(long var0, int var2, int var3, int var4) throws PDFNetException;

    static native void SetBorder(long var0, double var2, int var4, int var5, int var6) throws PDFNetException;

    static native double GetBorderThickness(long var0) throws PDFNetException;

    static native void SetVerticalAlignment(long var0, int var2) throws PDFNetException;

    static native int GetVerticalAlignment(long var0) throws PDFNetException;

    static native void SetHorizontalAlignment(long var0, int var2) throws PDFNetException;

    static native int GetHorizontalAlignment(long var0) throws PDFNetException;

    static native void SetHeight(long var0, double var2) throws PDFNetException;

    static native double GetHeight(long var0) throws PDFNetException;

    static native void SetWidth(long var0, double var2) throws PDFNetException;

    static native double GetWidth(long var0) throws PDFNetException;

    public static enum CellAlignmentHorizontalVals {
        e_alignment_left(1),
        e_alignment_middle(2),
        e_alignment_right(3);

        final int value;
        private static HashMap<Integer, CellAlignmentHorizontalVals> cellaligmnent_horizontalvals_map;

        private CellAlignmentHorizontalVals(int n2) {
            this.value = n2;
        }

        static CellAlignmentHorizontalVals valueToEnum(int n) {
            return cellaligmnent_horizontalvals_map.get(n);
        }

        static {
            cellaligmnent_horizontalvals_map = new HashMap();
            for (CellAlignmentHorizontalVals cellAlignmentHorizontalVals : CellAlignmentHorizontalVals.values()) {
                cellaligmnent_horizontalvals_map.put(cellAlignmentHorizontalVals.value, cellAlignmentHorizontalVals);
            }
        }
    }

    public static enum CellAlignmentVerticalVals {
        e_alignment_top(1),
        e_alignment_center(2),
        e_alignment_bottom(3);

        final int value;
        private static HashMap<Integer, CellAlignmentVerticalVals> cellaligmnent_verticalvals_map;

        private CellAlignmentVerticalVals(int n2) {
            this.value = n2;
        }

        static CellAlignmentVerticalVals valueToEnum(int n) {
            return cellaligmnent_verticalvals_map.get(n);
        }

        static {
            cellaligmnent_verticalvals_map = new HashMap();
            for (CellAlignmentVerticalVals cellAlignmentVerticalVals : CellAlignmentVerticalVals.values()) {
                cellaligmnent_verticalvals_map.put(cellAlignmentVerticalVals.value, cellAlignmentVerticalVals);
            }
        }
    }
}

