/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.pdf;

import com.pdftron.common.PDFNetException;
import com.pdftron.helpers.BitmapHelper;
import com.pdftron.helpers.ReachabilityHelper;
import com.pdftron.pdf.ErrorReportProc;
import com.pdftron.pdf.Page;
import com.pdftron.pdf.Rect;
import com.pdftron.pdf.Separation;
import com.pdftron.pdf.__DelayDelete;
import com.pdftron.pdf.ocg.Context;
import com.pdftron.sdf.Obj;
import java.awt.Graphics;
import java.awt.image.BufferedImage;

public class PDFDraw
extends __DelayDelete
implements AutoCloseable {
    public static final int e_postprocess_none = 0;
    public static final int e_postprocess_invert = 1;
    public static final int e_rgba = 0;
    public static final int e_bgra = 1;
    public static final int e_rgb = 2;
    public static final int e_bgr = 3;
    public static final int e_gray = 4;
    public static final int e_gray_alpha = 5;
    long impl;
    long procdata;
    Object ctx_ref = null;
    BufferedImage bufferedBitmap = null;

    public PDFDraw() throws PDFNetException {
        this.impl = PDFDraw.PDFDrawCreate(92.0);
        this.procdata = 0L;
        this.clearList();
    }

    public PDFDraw(double d) throws PDFNetException {
        this.impl = PDFDraw.PDFDrawCreate(d);
        this.procdata = 0L;
        this.clearList();
    }

    @Override
    public void destroy() throws PDFNetException {
        if (this.impl != 0L) {
            PDFDraw.Destroy(this.impl, this.procdata);
            this.impl = 0L;
        }
    }

    @Override
    protected void finalize() throws Throwable {
        this.destroy();
    }

    public void setRasterizerType(int n) throws PDFNetException {
        PDFDraw.SetRasterizerType(this.impl, n);
    }

    public void setDPI(double d) throws PDFNetException {
        PDFDraw.SetDPI(this.impl, d);
    }

    public void setImageSize(int n, int n2) throws PDFNetException {
        PDFDraw.SetImageSize(this.impl, n, n2, true);
    }

    public void setImageSize(int n, int n2, boolean bl) throws PDFNetException {
        PDFDraw.SetImageSize(this.impl, n, n2, bl);
    }

    public void setPageBox(int n) throws PDFNetException {
        PDFDraw.SetPageBox(this.impl, n);
    }

    public void setClipRect(Rect rect) throws PDFNetException {
        PDFDraw.SetClipRect(this.impl, rect.impl);
        ReachabilityHelper.ensureReachable(rect);
    }

    public void setFlipYAxis(boolean bl) throws PDFNetException {
        PDFDraw.SetFlipYAxis(this.impl, bl);
    }

    public void setRotate(int n) throws PDFNetException {
        PDFDraw.SetRotate(this.impl, n);
    }

    public void setDrawAnnotations(boolean bl) throws PDFNetException {
        PDFDraw.SetDrawAnnotations(this.impl, bl);
    }

    public void setHighlightFields(boolean bl) {
        PDFDraw.SetHighlightFields(this.impl, bl);
    }

    public void setAntiAliasing(boolean bl) throws PDFNetException {
        PDFDraw.SetAntiAliasing(this.impl, bl);
    }

    public void setPathHinting(boolean bl) throws PDFNetException {
        PDFDraw.SetPathHinting(this.impl, bl);
    }

    public void setThinLineAdjustment(boolean bl, boolean bl2) {
        PDFDraw.SetThinLineAdjustment(this.impl, bl, bl2);
    }

    public void setImageSmoothing() throws PDFNetException {
        PDFDraw.SetImageSmoothing(this.impl, true, false);
    }

    public void setImageSmoothing(boolean bl) throws PDFNetException {
        PDFDraw.SetImageSmoothing(this.impl, bl, false);
    }

    public void setImageSmoothing(boolean bl, boolean bl2) throws PDFNetException {
        PDFDraw.SetImageSmoothing(this.impl, bl, bl2);
    }

    public void setCaching() throws PDFNetException {
        PDFDraw.SetCaching(this.impl, true);
    }

    public void setCaching(boolean bl) throws PDFNetException {
        PDFDraw.SetCaching(this.impl, bl);
    }

    public void setGamma(double d) throws PDFNetException {
        PDFDraw.SetGamma(this.impl, d);
    }

    public void setOCGContext(Context context) throws PDFNetException {
        this.ctx_ref = context;
        if (context == null) {
            PDFDraw.SetOCGContext(this.impl, 0L);
        } else {
            PDFDraw.SetOCGContext(this.impl, context.__GetHandle());
            ReachabilityHelper.ensureReachable(context);
        }
    }

    public void setPrintMode(boolean bl) throws PDFNetException {
        PDFDraw.SetPrintMode(this.impl, bl);
    }

    public void setDefaultPageColor(byte by, byte by2, byte by3) throws PDFNetException {
        PDFDraw.SetDefaultPageColor(this.impl, by, by2, by3);
    }

    public void setPageTransparent(boolean bl) throws PDFNetException {
        PDFDraw.SetPageTransparent(this.impl, bl);
    }

    public void setColorPostProcessMode(int n) {
        PDFDraw.SetColorPostProcessMode(this.impl, n);
    }

    public void setOverprint(int n) throws PDFNetException {
        PDFDraw.SetOverprint(this.impl, n);
    }

    public void export(Page page, String string) throws PDFNetException {
        PDFDraw.Export(this.impl, page.impl, string, "PNG", 0L);
        ReachabilityHelper.ensureReachable(page);
    }

    public void export(Page page, String string, String string2) throws PDFNetException {
        PDFDraw.Export(this.impl, page.impl, string, string2, 0L);
        ReachabilityHelper.ensureReachable(page);
    }

    public void export(Page page, String string, String string2, Obj obj) throws PDFNetException {
        PDFDraw.Export(this.impl, page.impl, string, string2, obj.__GetHandle());
        ReachabilityHelper.ensureReachable(page);
        ReachabilityHelper.ensureReachable(obj);
    }

    public BufferedImage getBitmap(Page page) {
        return this.getBitmap(page, null);
    }

    public BufferedImage getBitmap(Page page, BufferedImage bufferedImage) {
        long[] lArray = PDFDraw.GetBitmap(this.impl, page.impl);
        ReachabilityHelper.ensureReachable(page);
        long l = lArray[0];
        int n = (int)lArray[1];
        int n2 = (int)lArray[2];
        int n3 = n * n2;
        if (n3 == 0) {
            return null;
        }
        BitmapHelper.CustomBitmap customBitmap = new BitmapHelper.CustomBitmap(n, n2, bufferedImage);
        PDFDraw.SetDataBuf(this.impl, l, customBitmap.bitmapArray);
        customBitmap.create();
        return customBitmap.bitmap;
    }

    public byte[] getByteBuffer(Page page) {
        long[] lArray = PDFDraw.GetBitmap(this.impl, page.impl);
        ReachabilityHelper.ensureReachable(page);
        long l = lArray[0];
        long l2 = lArray[1];
        long l3 = lArray[2];
        long l4 = lArray[3];
        int n = (int)l3 * (int)l4;
        byte[] byArray = new byte[n];
        PDFDraw.SetDataBufByte(this.impl, l, byArray);
        return byArray;
    }

    public IntBufferData getIntBuffer(Page page) {
        long[] lArray = PDFDraw.GetBitmap(this.impl, page.impl);
        ReachabilityHelper.ensureReachable(page);
        long l = lArray[0];
        IntBufferData intBufferData = new IntBufferData();
        intBufferData.width = (int)lArray[1];
        intBufferData.height = (int)lArray[2];
        intBufferData.stride = (int)lArray[3];
        int n = intBufferData.width * intBufferData.height;
        intBufferData.data = new int[n];
        PDFDraw.SetDataBuf(this.impl, l, intBufferData.data);
        return intBufferData;
    }

    public void drawInRect(Graphics graphics, Page page, int n, int n2, int n3, int n4) {
        this.bufferedBitmap = this.getBitmap(page, this.bufferedBitmap);
        BitmapHelper.drawInRect(this.bufferedBitmap, graphics, n3, n4);
    }

    public void setErrorReportProc(ErrorReportProc errorReportProc, Object object) throws PDFNetException {
        if (this.procdata != 0L) {
            PDFDraw.DestroyProcData(this.procdata);
        }
        this.procdata = PDFDraw.SetErrorReportProc(this.impl, errorReportProc, object);
    }

    public Separation[] getSeparationBitmaps(Page page) throws PDFNetException {
        Separation[] separationArray = PDFDraw.GetSeparationBitmaps(this.impl, page.impl);
        ReachabilityHelper.ensureReachable(page);
        return separationArray;
    }

    @Override
    public void close() throws PDFNetException {
        this.destroy();
    }

    static native long PDFDrawCreate(double var0);

    static native void Destroy(long var0, long var2);

    static native void DestroyProcData(long var0);

    static native void SetRasterizerType(long var0, int var2);

    static native void SetDPI(long var0, double var2);

    static native void SetImageSize(long var0, int var2, int var3, boolean var4);

    static native void SetPageBox(long var0, int var2);

    static native void SetClipRect(long var0, long var2);

    static native void SetFlipYAxis(long var0, boolean var2);

    static native void SetRotate(long var0, int var2);

    static native void SetDrawAnnotations(long var0, boolean var2);

    static native void SetHighlightFields(long var0, boolean var2);

    static native void SetPathHinting(long var0, boolean var2);

    static native void SetAntiAliasing(long var0, boolean var2);

    static native void SetThinLineAdjustment(long var0, boolean var2, boolean var3);

    static native void SetImageSmoothing(long var0, boolean var2, boolean var3);

    static native void SetCaching(long var0, boolean var2);

    static native void SetGamma(long var0, double var2);

    static native void SetOCGContext(long var0, long var2);

    static native void SetPrintMode(long var0, boolean var2);

    static native void SetPageTransparent(long var0, boolean var2);

    static native void SetDefaultPageColor(long var0, byte var2, byte var3, byte var4);

    static native void SetOverprint(long var0, int var2);

    static native void SetColorPostProcessMode(long var0, int var2);

    static native void Export(long var0, long var2, String var4, String var5, long var6);

    static native long SetErrorReportProc(long var0, ErrorReportProc var2, Object var3);

    static native long[] GetBitmap(long var0, long var2);

    static native void SetDataBuf(long var0, long var2, int[] var4);

    static native void SetDataBufByte(long var0, long var2, byte[] var4);

    static native Separation[] GetSeparationBitmaps(long var0, long var2);

    public class IntBufferData {
        public int[] data;
        public int width = 0;
        public int height = 0;
        public int stride = 0;
    }
}

