/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.pdf;

import com.pdftron.common.PDFNetException;
import com.pdftron.sdf.Obj;
import com.pdftron.sdf.ObjSet;

public class ViewerOptimizedOptions {
    public static final int e_op_off = 0;
    public static final int e_op_on = 1;
    public static final int e_op_pdfx_on = 2;
    Obj m_obj;
    ObjSet m_objset;

    public ViewerOptimizedOptions() {
        try {
            this.m_objset = new ObjSet();
            this.m_obj = this.m_objset.createDict();
        }
        catch (PDFNetException pDFNetException) {
            System.err.println("Error Occurred when creating ViewerOptimizedOptions.");
        }
    }

    public void setThumbnailRenderingThreshold(int n) throws PDFNetException {
        this.m_obj.putNumber("COMPLEXITY_THRESHOLD", n);
    }

    public void setMinimumInitialThumbnails(int n) throws PDFNetException {
        this.m_obj.putNumber("MINIMUM_INITIAL_THUMBNAILS", n);
    }

    public void setThumbnailSize(int n) throws PDFNetException {
        this.m_obj.putNumber("THUMB_SIZE", n);
    }

    public void setOverprint(int n) throws PDFNetException {
        switch (n) {
            case 0: {
                this.m_obj.putName("OVERPRINT_MODE", "OFF");
                break;
            }
            case 1: {
                this.m_obj.putName("OVERPRINT_MODE", "ON");
                break;
            }
            case 2: {
                this.m_obj.putName("OVERPRINT_MODE", "PDFX");
            }
        }
    }
}

