/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.pdf.pdfa;

import com.pdftron.common.PDFNetException;
import com.pdftron.pdf.OptionsBase;
import com.pdftron.sdf.Obj;

public class PDFAOptions
extends OptionsBase {
    public PDFAOptions(int n) throws PDFNetException {
        this.setConformance(n);
    }

    public PDFAOptions(String string) throws PDFNetException {
        super(string);
    }

    long getObjHandle() throws PDFNetException {
        return this.mDict.__GetHandle();
    }

    public int getConformance() throws PDFNetException {
        Obj obj = this.mDict.findObj("Conformance");
        if (obj != null && !obj.isNull()) {
            return (int)obj.getNumber();
        }
        return 2;
    }

    public PDFAOptions setConformance(int n) throws PDFNetException {
        this.putNumber("Conformance", n);
        return this;
    }

    public int getDPI() throws PDFNetException {
        Obj obj = this.mDict.findObj("Dpi");
        if (obj != null && !obj.isNull()) {
            return (int)obj.getNumber();
        }
        return 300;
    }

    public PDFAOptions setDPI(int n) throws PDFNetException {
        this.putNumber("Dpi", n);
        return this;
    }

    public boolean getFirstStop() throws PDFNetException {
        Obj obj = this.mDict.findObj("FirstStop");
        if (obj != null && !obj.isNull()) {
            return obj.getBool();
        }
        return false;
    }

    public PDFAOptions setFirstStop(boolean bl) throws PDFNetException {
        this.putBool("FirstStop", bl);
        return this;
    }

    public boolean getFlattenTransparency() throws PDFNetException {
        Obj obj = this.mDict.findObj("Flatten");
        if (obj != null && !obj.isNull()) {
            return obj.getBool();
        }
        return false;
    }

    public PDFAOptions setFlattenTransparency(boolean bl) throws PDFNetException {
        this.putBool("Flatten", bl);
        return this;
    }

    public int getMaxRefObjs() throws PDFNetException {
        Obj obj = this.mDict.findObj("MaxRefObjs");
        if (obj != null && !obj.isNull()) {
            return (int)obj.getNumber();
        }
        return 10;
    }

    public PDFAOptions setMaxRefObjs(int n) throws PDFNetException {
        this.putNumber("MaxRefObjs", n);
        return this;
    }

    public String getPassword() throws PDFNetException {
        Obj obj = this.mDict.findObj("Password");
        if (obj != null && !obj.isNull()) {
            return obj.getAsPDFText();
        }
        return "";
    }

    public PDFAOptions setPassword(String string) throws PDFNetException {
        this.putText("Password", string);
        return this;
    }
}

