// This file is autogenerated: please see the codegen template "Options"
#ifndef PDFTRON_H_CPPPDFBarcodeOptions
#define PDFTRON_H_CPPPDFBarcodeOptions

#include <PDF/OptionsBase.h>

namespace pdftron{ namespace PDF{ 

class BarcodeOptions : public OptionsBase
{
public:
	/**
	* A set of flags used to specify a subset of barcode types. Can be
	* bitwise OR-ed to combine multiple groups.
	*/
	enum BarcodeTypeGroup
	{
		e_none = 0, 
		e_linear = 1, 
		e_post_net_planet = 2, 
		e_four_state = 4, 
		e_gs1_databar_stacked = 8, 
		e_qr = 16, 
		e_data_matrix = 32, 
		e_aztec = 64, 
		e_maxi = 128, 
		e_micro_qr = 256, 
		e_pdf417 = 512, 
		e_micro_pdf417 = 1024, 
		e_patch_code = 2048, 
		e_pharma_code = 4096 
	};

	/**
	* A set of flags used to specify the barcode orientation(s). Can be
	* bitwise OR-ed to search for multiple orientations. Orientation only
	* affects the following barcode types: e_linear, e_post_net_planet,
	* e_four_state, e_gs1_databar_stacked, e_pdf417, e_micro_pdf417,
	* e_patch_code and e_pharma_code.
	*/
	enum BarcodeOrientation
	{
		e_horizontal = 1, 
		e_vertical = 2, 
		e_diagonal = 4 
	};

	/**
	* An enumeration used to specify the barcode detection profile.
	*/
	enum BarcodeProfile
	{
		e_high_quality_source_profile = 1, ///< The default profile assumes an input quality of mediocre to high, such as vector graphics, or an average to high quality scan of a flat paper. This setting provides the fastest barcode read performance.
		e_low_quality_source_profile = 2, ///< This profile is useful for scanned paper of very poor quality, such as a very low resolution or a lot of noise. The barcode read performance is slightly slower.
		e_small_barcodes_profile = 3, ///< This profile is suitable for vector graphics or scanned paper containing an unusually small barcode. The barcode read performance is significantly slower.
		e_natural_picture_profile = 4 ///< This profile should be selected for natural pictures, such as photographs of real-world objects that contain a barcode. The barcode read performance is significantly slower.
	};

	/**
	* An enumeration used to specify the format of the data output.
	*/
	enum OutputFormat
	{
		e_auto = 0, ///< The default setting. The barcode data will be decoded to a string if possible. Otherwise, a Base64-encoded binary stream will be used.
		e_binary = 1 ///< The barcode data will be returned as a Base64-encoded binary stream.
	};

	BarcodeOptions();
	~BarcodeOptions();

	
	/**
	* Gets the value BarcodeOrientations from the options object.
	* Specifies a set of barcode orientations to be searched for in the
	* target PDF. This value can be created by bitwise OR-ing together
	* various values from BarcodeOrientation to select the orientations of
	* interest. By default, all orientations are searched for. Additional
	* search directions can have a modest impact on search time. Orientation
	* only affects the following barcode types: e_linear, e_post_net_planet,
	* e_four_state, e_gs1_databar_stacked, e_pdf417, e_micro_pdf417,
	* e_patch_code and e_pharma_code.
	* @return The current value for BarcodeOrientations.
	*/
	UInt32 GetBarcodeOrientations();

	/**
	* Sets the value for BarcodeOrientations in the options object.
	* Specifies a set of barcode orientations to be searched for in the
	* target PDF. This value can be created by bitwise OR-ing together
	* various values from BarcodeOrientation to select the orientations of
	* interest. By default, all orientations are searched for. Additional
	* search directions can have a modest impact on search time. Orientation
	* only affects the following barcode types: e_linear, e_post_net_planet,
	* e_four_state, e_gs1_databar_stacked, e_pdf417, e_micro_pdf417,
	* e_patch_code and e_pharma_code.
	* @param value The new value for BarcodeOrientations.
	* @return This object, for call chaining.
	*/
	BarcodeOptions& SetBarcodeOrientations(UInt32 value);

	
	/**
	* Gets the value BarcodeProfile from the options object.
	* Specifies the barcode detection profile. Depending on the type and
	* quality of the input, specialized profiles may return a better result
	* at the cost of a slight runtime performance penalty. Barcode detection
	* has the best runtime performance on high quality sources with the
	* default profile.
	* @return The current value for BarcodeProfile.
	*/
	BarcodeProfile GetBarcodeProfile();

	/**
	* Sets the value for BarcodeProfile in the options object.
	* Specifies the barcode detection profile. Depending on the type and
	* quality of the input, specialized profiles may return a better result
	* at the cost of a slight runtime performance penalty. Barcode detection
	* has the best runtime performance on high quality sources with the
	* default profile.
	* @param value The new value for BarcodeProfile.
	* @return This object, for call chaining.
	*/
	BarcodeOptions& SetBarcodeProfile(BarcodeProfile value);

	
	/**
	* Gets the value BarcodeSearchTypes from the options object.
	* Specifies a set of barcode types to be searched for in the target PDF.
	* This value can be created by bitwise OR-ing together various values
	* from BarcodeTypeGroup to select the types of interest. Searching for
	* barcodes takes approximately linear time in the number of barcode
	* types to be searched for. By specifying only the types of barcodes of
	* interest, runtime may be significantly improved. By default, all types
	* are searched for.
	* @return The current value for BarcodeSearchTypes.
	*/
	UInt32 GetBarcodeSearchTypes();

	/**
	* Sets the value for BarcodeSearchTypes in the options object.
	* Specifies a set of barcode types to be searched for in the target PDF.
	* This value can be created by bitwise OR-ing together various values
	* from BarcodeTypeGroup to select the types of interest. Searching for
	* barcodes takes approximately linear time in the number of barcode
	* types to be searched for. By specifying only the types of barcodes of
	* interest, runtime may be significantly improved. By default, all types
	* are searched for.
	* @param value The new value for BarcodeSearchTypes.
	* @return This object, for call chaining.
	*/
	BarcodeOptions& SetBarcodeSearchTypes(UInt32 value);

	
	/**
	* Gets the value DataOutputFormat from the options object.
	* Specifies the format of the data output. The default is "auto", which
	* will attempt to decode the barcode data to a string if possible.
	* Otherwise, a Base64-encoded binary stream will be used. If the data is
	* known to be binary, the output format can be set to "binary" to avoid
	* unnecessary decoding attempts. Data returned as binary will be stored
	* in the "data" field of the barcode object in the output JSON, while
	* decoded data will be stored in the "text" field.
	* @return The current value for DataOutputFormat.
	*/
	OutputFormat GetDataOutputFormat();

	/**
	* Sets the value for DataOutputFormat in the options object.
	* Specifies the format of the data output. The default is "auto", which
	* will attempt to decode the barcode data to a string if possible.
	* Otherwise, a Base64-encoded binary stream will be used. If the data is
	* known to be binary, the output format can be set to "binary" to avoid
	* unnecessary decoding attempts. Data returned as binary will be stored
	* in the "data" field of the barcode object in the output JSON, while
	* decoded data will be stored in the "text" field.
	* @param value The new value for DataOutputFormat.
	* @return This object, for call chaining.
	*/
	BarcodeOptions& SetDataOutputFormat(OutputFormat value);

	
	/**
	* Gets the value Pages from the options object.
	* Specifies a range of pages on which to perform barcode extraction,
	* such as "1-5", or "1-3,5,7-10". Open ended ranges are supported, e.g.,
	* "3-". By default all pages are converted. The first page is page
	* number 1.
	* @return The current value for Pages.
	*/
	UString GetPages();

	/**
	* Sets the value for Pages in the options object.
	* Specifies a range of pages on which to perform barcode extraction,
	* such as "1-5", or "1-3,5,7-10". Open ended ranges are supported, e.g.,
	* "3-". By default all pages are converted. The first page is page
	* number 1.
	* @param value The new value for Pages.
	* @return This object, for call chaining.
	*/
	BarcodeOptions& SetPages(const UString& value);

	
};

}
}

#include "../Impl/BarcodeOptions.inl"
#endif // PDFTRON_H_CPPPDFBarcodeOptions
