//---------------------------------------------------------------------------------------
// Copyright (c) 2001-2025 by Apryse Software Inc. All Rights Reserved.
// Consult legal.txt regarding legal and license information.
//---------------------------------------------------------------------------------------
// !Warning! This file is autogenerated, modify the .codegen file, not this one
// (any changes here will be wiped out during the autogen process)

#ifndef PDFTRON_H_CPPPDFTemplateDocument
#define PDFTRON_H_CPPPDFTemplateDocument
#include <C/PDF/TRN_TemplateDocument.h>

#include <Common/BasicTypes.h>
#include <Common/UString.h>
#include <PDF/PDFDoc.h>

namespace pdftron { namespace PDF { 


/**
 * The class TemplateDocument.
 * Encapsulates a template document that can merged with data to generate
 * any number of PDFs.
 *
 * TemplateDocument instances are created through the Convert class.  See
 * Convert.CreateOfficeTemplate.
 */
class TemplateDocument
{
public:
	enum Result
	{
		eSuccess = 0, 
		eIncomplete = 1, 
		eFailure = 2 
	};
	TemplateDocument();
	TemplateDocument(const TemplateDocument& other);
	TemplateDocument(TRN_TemplateDocument impl);
	TemplateDocument& operator= (const TemplateDocument& other);
	~TemplateDocument();
	void Destroy();
	
	/**
	 * Create a PDF by merging JSON data with this template document.
	 * 
	 * @param json A JSON dictionary mapping template keys to their replacement content.
	 * @return The PDFDoc from the template filling result.
	 */
	PDFDoc FillTemplateJson(UString json);
	
	/**
	 * Create an office file by merging JSON data with this template
	 * document.  This function currently only supports DOCX input.
	 * 
	 * @param json A JSON dictionary mapping template keys to their replacement content.
	 * @param output_path The path where the output file is written.
	 */
	void FillTemplateJsonToOffice(UString json, UString output_path);
	
	/**
	 * Create an office file by merging JSON data with this template
	 * document.  This function currently only supports DOCX input.
	 * 
	 * @param json A JSON dictionary mapping template keys to their replacement content.
	 * @param output_stream An output stream.
	 */
	void FillTemplateJsonToOfficeWithFilter(UString json, Filters::Filter& output_stream);
	
	/**
	 * Get information about the template keys present in the template
	 * document.  Returns a JSON dictionary following this form:
	 * https://www.pdftron.com/api/web/Core.html#.TemplateSchema.
	 * 
	 * @return The template keys info JSON dictionary, serialized into a string.
	 */
	UString GetTemplateKeysJson();
	
	/**
	 * If the template filling finsihed with some kind of error, this returns
	 * the value of the error description; otherwise returns an empty string.
	 * 
	 * @return The error description. Will be blank unless GetConversionStatus
	 * returns Failure.
	 */
	UString GetErrorString() const;
	
	/**
	 * Get the state of the template filling process.
	 * 
	 * @return 
	 */
	Result GetConversionStatus() const;
	
	/**
	 * Cancel the current template filling, forcing FillTemplateJson to
	 * return.
	 * 
	 */
	void CancelConversion();
	
	/**
	 * Has the template filling been cancelled?.
	 * 
	 * @return Returns true if CancelConversion has been called previously.
	 */
	bool IsCancelled() const;
	
	/**
	 * Return the number of warning strings generated during the template
	 * filling process. Warning: experimental interface; this method may be
	 * renamed or replaced with equivalent functionality in the future.
	 * 
	 * @return The number of stored warning strings.
	 */
	UInt32 GetNumWarnings() const;
	
	/**
	 * Retrieve warning strings that have been collected during the template
	 * filling process. Warning: experimental interface; this method may be
	 * renamed or replaced with equivalent functionality in the future.
	 * 
	 * @param index The index of the string to be retrieved. Must be less than
	 * GetNumWarnings().
	 * @return The value of the particular warning string.
	 */
	UString GetWarningString(UInt32 index) const;

	//for xamarin use only
	static TemplateDocument* CreateInternal(ptrdiff_t impl);
	ptrdiff_t GetHandleInternal();


#ifndef SWIGHIDDEN
	TRN_TemplateDocument m_impl;
#endif

private:

};

#include <Impl/TemplateDocument.inl>
} //end pdftron
} //end PDF


#endif //PDFTRON_H_CPPPDFTemplateDocument
