// This file is autogenerated: please see the codegen template "Options"
#ifndef PDFTRON_H_CPPPDFTransPDFOptions
#define PDFTRON_H_CPPPDFTransPDFOptions

#include <PDF/OptionsBase.h>

namespace pdftron{ namespace PDF{ 

class TransPDFOptions : public OptionsBase
{
public:
	TransPDFOptions();
	~TransPDFOptions();

	
	/**
	* Gets the value BatchSize from the options object.
	* The number of pages to process before saving an intermediate PDF to
	* free resources. A greater number of pages will increase memory usage,
	* and a smaller number will increase processing time. Default is 20.
	* @return The current value for BatchSize.
	*/
	UInt32 GetBatchSize();

	/**
	* Sets the value for BatchSize in the options object.
	* The number of pages to process before saving an intermediate PDF to
	* free resources. A greater number of pages will increase memory usage,
	* and a smaller number will increase processing time. Default is 20.
	* @param value The new value for BatchSize.
	* @return This object, for call chaining.
	*/
	TransPDFOptions& SetBatchSize(UInt32 value);

	
	/**
	* Gets the value Pages from the options object.
	* Specifies a set of pages to process, such as "1-5", or "1-3,5,7-10".
	* Open ended ranges are supported, e.g., "3-". By default all pages are
	* processed. The first page is page number 1. This option only affects XLIFF extraction.
	* @return The current value for Pages.
	*/
	UString GetPages();

	/**
	* Sets the value for Pages in the options object.
	* Specifies a set of pages to process, such as "1-5", or "1-3,5,7-10".
	* Open ended ranges are supported, e.g., "3-". By default all pages are
	* processed. The first page is page number 1. This option only affects XLIFF extraction.
	* @param value The new value for Pages.
	* @return This object, for call chaining.
	*/
	TransPDFOptions& SetPages(const UString& value);

	
	/**
	* Gets the value ResizeSingleLine from the options object.
	* If true, single line text boxes will grow and shrink to accommodate
	* translated text.
	* @return The current value for ResizeSingleLine.
	*/
	bool GetResizeSingleLine();

	/**
	* Sets the value for ResizeSingleLine in the options object.
	* If true, single line text boxes will grow and shrink to accommodate
	* translated text.
	* @param value The new value for ResizeSingleLine.
	* @return This object, for call chaining.
	*/
	TransPDFOptions& SetResizeSingleLine(bool value);

	
	/**
	* Gets the value SourceLanguage from the options object.
	* A language code as specified in [RFC 4646] that identifies the
	* language of the source PDF. This will be set as the 'source-language'
	* attribute of the file tag in the extracted XLIFF. Default is 'en'
	* (English).
	* @return The current value for SourceLanguage.
	*/
	UString GetSourceLanguage();

	/**
	* Sets the value for SourceLanguage in the options object.
	* A language code as specified in [RFC 4646] that identifies the
	* language of the source PDF. This will be set as the 'source-language'
	* attribute of the file tag in the extracted XLIFF. Default is 'en'
	* (English).
	* @param value The new value for SourceLanguage.
	* @return This object, for call chaining.
	*/
	TransPDFOptions& SetSourceLanguage(const UString& value);

	
};

}
}

#include "../Impl/TransPDFOptions.inl"
#endif // PDFTRON_H_CPPPDFTransPDFOptions
