//---------------------------------------------------------------------------------------
// Copyright (c) 2001-2025 by Apryse Software Inc. All Rights Reserved.
// Consult legal.txt regarding legal and license information.
//---------------------------------------------------------------------------------------

#import <OBJC/PDFNetOBJC.h>
#import <Foundation/Foundation.h>

// The following sample illustrates how to find and replace text in a document

int main(int argc, char *argv[])
{
    @autoreleasepool {
        int ret = 0;
        [PTPDFNet Initialize: 0];

        NSString *inputPath = @"../../TestFiles/";
        NSString *outputPath = @"../../TestFiles/Output/";

        @try
        {
            // Open a PDF document to edit
            PTPDFDoc *doc = [[PTPDFDoc alloc] initWithFilepath: [inputPath stringByAppendingString:@"find-replace-test.pdf"]];

            PTFindReplaceOptions* options = [[PTFindReplaceOptions alloc] init];

            // Set some find/replace options
            [options SetWholeWords: true];
            [options SetMatchCase: true];
            [options SetMatchMode: e_exact];
            [options SetReflowMode: e_para];
            [options SetAlignment: e_left];

            // Perform a Find/Replace finding "the" with "THE INCREDIBLE"
            [PTFindReplace FindReplaceText : doc from: @"the" to: @"THE INCREDIBLE" options: options];

            // Save the edited PDF
            [doc SaveToFile : [outputPath stringByAppendingString:@"find-replace-test-replaced.pdf"] flags: e_ptlinearized];
            [doc Close];
        }
        @catch(NSException *e)
        {
            NSLog(@"%@", e.reason);
            ret = 1;
        }

        [PTPDFNet Terminate: 0];
        return ret;
    }
}

