//---------------------------------------------------------------------------------------
// Copyright (c) 2001-2025 by Apryse Software Inc. All Rights Reserved.
// Consult legal.txt regarding legal and license information.
//---------------------------------------------------------------------------------------

#import <OBJC/PDFNetOBJC.h>
#import <Foundation/Foundation.h>

//------------------------------------------------------------------------------
// The following sample illustrates how to use the PTConvert utility class
// to convert MS Office files to PDF and replace templated tags present in the document
// with content supplied via json
//
// For a detailed specification of the template format and supported features,
// see: https://docs.apryse.com/documentation/core/guides/generate-via-template/data-model/
//
// This conversion is performed entirely within the PDFNet and has *no*
// external or system dependencies -- Conversion results will be
// the same whether on Windows, Linux or Android.
//
// Please contact us if you have any questions.
//------------------------------------------------------------------------------

int main(int argc, char *argv[])
{

    @autoreleasepool {

        [PTPDFNet Initialize: 0];

        NSString *input_path = @"../../TestFiles/";
        NSString *output_path = @"../../TestFiles/Output/";
        NSString *input_filename = @"SYH_Letter.docx";
        NSString *output_filename = @"SYH_Letter.pdf";
        NSString *json = [NSString stringWithFormat: @"{\"dest_given_name\": \"Janice N.\", "
            @"\"dest_street_address\": \"187 Duizelstraat\", \"dest_surname\": \"Symonds\", "
            @"\"dest_title\": \"Ms.\", \"land_location\": \"225 Parc St., Rochelle, QC \","
            @"\"lease_problem\": \"According to the city records, the lease was initiated in September 2010 and never terminated\", "
            @"\"logo\": {\"image_url\": \"%@logo_red.png\", \"width\" : 64, \"height\" : 64},"
            @"\"sender_name\": \"Arnold Smith\"}", input_path];

        PTOfficeToPDFOptions* options = [[PTOfficeToPDFOptions alloc] init];

	    // Create a TemplateDocument object from an input office file.
	    PTTemplateDocument *template_doc = [PTConvert CreateOfficeTemplate: [NSString stringWithFormat:@"%@/%@", input_path, input_filename]
		                                              options: options];

	    // Fill the template with data from a JSON string, producing a PDF document.
		PTPDFDoc *pdf_doc = [template_doc FillTemplateJson: json];

	    // Save the PDF to a file.
        [pdf_doc SaveToFile: [NSString stringWithFormat:@"%@/%@", output_path, output_filename]
                     flags: e_ptlinearized];

        NSLog(@"Saved %@\n", output_filename);
        NSLog(@"Done.\n");

        [PTPDFNet Terminate: 0];
        return 0;
    }
}
