//---------------------------------------------------------------------------------------
// Copyright (c) 2001-2025 by Apryse Software Inc. All Rights Reserved.
// Consult legal.txt regarding legal and license information.
//---------------------------------------------------------------------------------------

#import <OBJC/PDFNetOBJC.h>
#import <Foundation/Foundation.h>

//---------------------------------------------------------------------------------------
// The following sample illustrates how to make sure a file meets the PDF/UA standard, using the PDFUAConformance class object.
// Note: this feature is currently experimental and subject to change
//
// DataExtractionModule is required (Mac users can use StructuredOutputModule instead)
// https://docs.apryse.com/documentation/core/info/modules/#data-extraction-module
// https://docs.apryse.com/documentation/core/info/modules/#structured-output-module (Mac)
//---------------------------------------------------------------------------------------
int main(int argc, char *argv[])
{
    @autoreleasepool {

	    // Relative path to the folder containing test files.
	    NSString *input_path =  @"../../TestFiles/";
	    NSString *output_path = @"../../TestFiles/Output/";

	    // DataExtraction library location, replace if desired, should point to a folder that includes the contents of <DataExtractionModuleRoot>/Lib.
	    // If using default, unzip the DataExtraction zip to the parent folder of Samples, and merge with existing "Lib" folder
	    NSString *extraction_module_path = @"../../../Lib/";

	    NSString *input_file1 = [input_path stringByAppendingString: @"autotag_input.pdf"];
	    NSString *input_file2 = [input_path stringByAppendingString: @"table.pdf"];
	    NSString *output_file1 = [output_path stringByAppendingString: @"autotag_pdfua.pdf"];
	    NSString *output_file2 = [output_path stringByAppendingString: @"table_pdfua_linearized.pdf"];

	    int ret = 0;
	    @try
	    {
		    [PTPDFNet Initialize: 0];

		    NSLog(@"AutoConverting...");

		    [PTPDFNet AddResourceSearchPath: extraction_module_path];
		    if(![PTDataExtractionModule IsModuleAvailable: e_ptextract_doc_structure])
		    {
			    NSLog(@"");
			    NSLog(@"Unable to run PDFUATest: Apryse SDK Data Extraction module not available.");
			    NSLog(@"---------------------------------------------------------------");
			    NSLog(@"The Data Extraction module is an optional add-on, available for download");
			    NSLog(@"at https://apryse.com/. If you have already downloaded this");
			    NSLog(@"module, ensure that the SDK is able to find the required files");
			    NSLog(@"using the [PTPDFNet AddResourceSearchPath ...] function.");
			    NSLog(@"");
			    return 1;
		    }

		    PTPDFUAConformance *pdf_ua = [[PTPDFUAConformance alloc] init];

		    NSLog(@"Simple Conversion...");
		    {
			    // Perform conversion using default options
			    [pdf_ua AutoConvert: input_file1 dest_file: output_file1];
		    }

		    NSLog(@"Converting With Options...");
		    {
			    PTPDFUAOptions *pdf_ua_opts = [[PTPDFUAOptions alloc] init];
			    [pdf_ua_opts SetSaveLinearized: YES]; // Linearize when saving output
			    // Note: if file is password protected, you can use [pdf_ua_opts SetPassword: <PWD>]

			    // Perform conversion using the options we specify
			    [pdf_ua AutoConvertWithOptions: input_file2 dest_file: output_file2 options: pdf_ua_opts];
		    }
	    }
	    @catch (NSException *e)
	    {
		    NSLog(@"%@", e.reason);
		    ret = 1;
	    }

	    NSLog(@"PDFUAConformance test completed.");
	    [PTPDFNet Terminate: 0];
	    return ret;
    }
}
