//---------------------------------------------------------------------------------------
// Copyright (c) 2001-2025 by Apryse Software Inc. All Rights Reserved.
// Consult legal.txt regarding legal and license information.
//---------------------------------------------------------------------------------------

#import <OBJC/PDFNetOBJC.h>
#import <Foundation/Foundation.h>

// The following sample illustrates how to extract xlf from a PDF document for translation.
// It then applies a pre-prepared translated xlf file to the PDF to produce a translated PDF.

int main(int argc, char *argv[])
{
    @autoreleasepool {
        int ret = 0;
        [PTPDFNet Initialize: 0];

		NSString *inputPath = @"../../TestFiles/";
		NSString *outputPath = @"../../TestFiles/Output/";

        @try
        {
			// Open the PDF to translate
			PTPDFDoc *doc = [[PTPDFDoc alloc] initWithFilepath: [inputPath stringByAppendingString:@"find-replace-test.pdf"]];

			PTTransPDFOptions* options = [[PTTransPDFOptions alloc] init];

			// Set the source language in the options
			[options SetSourceLanguage: @"en"];

			// Set the number of pages to process in each batch
			[options SetBatchSize: 20];

			// Optionally, subset the pages to process
			// This PDF only has a single page, but you can specify a subset of pages like this
			// [options SetPages: "-2,5-6,9,11-"];

			// Extract the xlf to file and field the PDF for translation
			[PTTransPDF ExtractXLIFF: doc output_xliff: [outputPath stringByAppendingString:@"find-replace-test.xlf"] options: options];

			// Save the fielded PDF
			[doc SaveToFile : [outputPath stringByAppendingString:@"find-replace-test-fielded.pdf"] flags: e_ptlinearized];

			// The extracted xlf can be translated in a system of your choice.
			// In this sample a pre-prepared translated file is used - find-replace-test_(en_to_fr).xlf

			// Perform the translation using the pre-prepared translated xliff
			[PTTransPDF ApplyXLIFF: doc incoming_xliff : [inputPath stringByAppendingString:@"find-replace-test_(en_to_fr).xlf"] options: options];

			// Save the translated PDF
			[doc SaveToFile : [outputPath stringByAppendingString:@"find-replace-test-fr.pdf"] flags: e_ptlinearized];
			[doc Close];
        }
        @catch(NSException *e)
        {
            NSLog(@"%@", e.reason);
            ret = 1;
        }

        [PTPDFNet Terminate: 0];
        return ret;
    }
}

