/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.pdf;

import com.pdftron.common.PDFNetException;
import com.pdftron.helpers.ReachabilityHelper;
import com.pdftron.pdf.Destination;
import com.pdftron.pdf.FileSpec;
import com.pdftron.pdf.KeyStrokeActionResult;
import com.pdftron.pdf.KeyStrokeEventData;
import com.pdftron.pdf.PDFDoc;
import com.pdftron.sdf.Obj;

public class Action {
    public static final int e_GoTo = 0;
    public static final int e_GoToR = 1;
    public static final int e_GoToE = 2;
    public static final int e_Launch = 3;
    public static final int e_Thread = 4;
    public static final int e_URI = 5;
    public static final int e_Sound = 6;
    public static final int e_Movie = 7;
    public static final int e_Hide = 8;
    public static final int e_Named = 9;
    public static final int e_SubmitForm = 10;
    public static final int e_ResetForm = 11;
    public static final int e_ImportData = 12;
    public static final int e_JavaScript = 13;
    public static final int e_SetOCGState = 14;
    public static final int e_Rendition = 15;
    public static final int e_Trans = 16;
    public static final int e_GoTo3DView = 17;
    public static final int e_Unknown = 18;
    public static final int e_exclude = 0;
    public static final int e_include_no_value_fields = 1;
    public static final int e_export_format = 2;
    public static final int e_get_method = 3;
    public static final int e_submit_coordinates = 4;
    public static final int e_xfdf = 5;
    public static final int e_include_append_saves = 6;
    public static final int e_include_annotations = 7;
    public static final int e_submit_pdf = 8;
    public static final int e_canonical_format = 9;
    public static final int e_excl_non_user_annots = 10;
    public static final int e_excl_F_key = 11;
    public static final int e_embed_form = 13;
    long impl;
    Object ref;

    public static Action createGoto(Destination destination) throws PDFNetException {
        return new Action(Action.CreateGoto(destination.impl), destination.ref);
    }

    public static Action createGoto(byte[] byArray, Destination destination) throws PDFNetException {
        return new Action(Action.CreateGoto(byArray, destination.impl), destination.ref);
    }

    public static Action createGotoRemote(FileSpec fileSpec, int n) throws PDFNetException {
        return new Action(Action.CreateGotoRemote(fileSpec.impl, n), fileSpec.ref);
    }

    public static Action createGotoRemote(FileSpec fileSpec, int n, boolean bl) throws PDFNetException {
        return new Action(Action.CreateGotoRemote(fileSpec.impl, n, bl), fileSpec.ref);
    }

    public static Action createURI(PDFDoc pDFDoc, String string) throws PDFNetException {
        return new Action(Action.CreateURI(pDFDoc.__GetHandle(), string), pDFDoc);
    }

    public static Action createSubmitForm(FileSpec fileSpec) throws PDFNetException {
        return new Action(Action.CreateSubmitForm(fileSpec.impl), fileSpec.ref);
    }

    public static Action createLaunch(PDFDoc pDFDoc, String string) {
        return new Action(Action.CreateLaunch(pDFDoc.__GetHandle(), string), pDFDoc);
    }

    public static Action createHideField(PDFDoc pDFDoc, String[] stringArray) {
        return new Action(Action.CreateHideField(pDFDoc.__GetHandle(), stringArray), pDFDoc);
    }

    public static Action createImportData(PDFDoc pDFDoc, String string) {
        return new Action(Action.CreateImportData(pDFDoc.__GetHandle(), string), pDFDoc);
    }

    public static Action createResetForm(PDFDoc pDFDoc) {
        return new Action(Action.CreateResetForm(pDFDoc.__GetHandle()), pDFDoc);
    }

    public static Action createJavaScript(PDFDoc pDFDoc, String string) {
        return new Action(Action.CreateJavaScript(pDFDoc.__GetHandle(), string), pDFDoc);
    }

    public Action(Obj obj) throws PDFNetException {
        this.impl = obj.__GetHandle();
        this.ref = obj.__GetRefHandle();
    }

    public boolean needsWriteLock() throws PDFNetException {
        return Action.NeedsWriteLock(this.impl);
    }

    public KeyStrokeActionResult executeKeyStrokeAction(KeyStrokeEventData keyStrokeEventData) throws PDFNetException {
        KeyStrokeActionResult keyStrokeActionResult = new KeyStrokeActionResult(Action.ExecuteKeyStrokeAction(this.impl, keyStrokeEventData.impl));
        ReachabilityHelper.ensureReachable(keyStrokeEventData);
        return keyStrokeActionResult;
    }

    public void Execute() throws PDFNetException {
        Action.Execute(this.impl);
    }

    public Obj GetNext() throws PDFNetException {
        return Obj.__Create(Action.GetNext(this.impl), this.ref);
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass().equals(this.getClass())) {
            return this.impl == ((Action)object).impl;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.impl;
    }

    public boolean isValid() throws PDFNetException {
        return Action.IsValid(this.impl);
    }

    public int getType() throws PDFNetException {
        return Action.GetType(this.impl);
    }

    public Destination getDest() throws PDFNetException {
        return new Destination(Action.GetDest(this.impl), this.ref);
    }

    public int getFormActionFlag(int n) throws PDFNetException {
        return Action.GetFormActionFlag(this.impl, n);
    }

    public void setFormActionFlag(int n, boolean bl) throws PDFNetException {
        Action.SetFormActionFlag(this.impl, n, bl);
    }

    public Obj getSDFObj() {
        return Obj.__Create(this.impl, this.ref);
    }

    Action(long l, Object object) {
        this.impl = l;
        this.ref = object;
    }

    public static Action __Create(long l, Object object) {
        if (l == 0L) {
            return null;
        }
        return new Action(l, object);
    }

    public long __GetHandle() {
        return this.impl;
    }

    public Object __GetRefHandle() {
        return this.ref;
    }

    static native boolean NeedsWriteLock(long var0);

    static native long ExecuteKeyStrokeAction(long var0, long var2);

    static native long CreateGoto(long var0);

    static native long CreateGoto(byte[] var0, long var1);

    static native long CreateGotoRemote(long var0, int var2);

    static native long CreateGotoRemote(long var0, int var2, boolean var3);

    static native long CreateURI(long var0, String var2);

    static native long CreateSubmitForm(long var0);

    static native long CreateLaunch(long var0, String var2);

    static native long CreateHideField(long var0, String[] var2);

    static native long CreateImportData(long var0, String var2);

    static native long CreateResetForm(long var0);

    static native long CreateJavaScript(long var0, String var2);

    static native void Execute(long var0);

    static native boolean IsValid(long var0);

    static native int GetType(long var0);

    static native long GetDest(long var0);

    static native int GetFormActionFlag(long var0, int var2);

    static native void SetFormActionFlag(long var0, int var2, boolean var3);

    static native long GetNext(long var0);
}

