/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.pdf;

import com.pdftron.common.PDFNetException;
import com.pdftron.filters.Filter;
import com.pdftron.helpers.ReachabilityHelper;
import com.pdftron.pdf.ColorPt;
import com.pdftron.pdf.Function;
import com.pdftron.sdf.Doc;
import com.pdftron.sdf.Obj;

public class ColorSpace {
    public static final int e_device_gray = 0;
    public static final int e_device_rgb = 1;
    public static final int e_device_cmyk = 2;
    public static final int e_cal_gray = 3;
    public static final int e_cal_rgb = 4;
    public static final int e_lab = 5;
    public static final int e_icc = 6;
    public static final int e_indexed = 7;
    public static final int e_pattern = 8;
    public static final int e_separation = 9;
    public static final int e_device_n = 10;
    public static final int e_null = 11;
    long impl;
    Object ref;

    public static ColorSpace createDeviceGray() throws PDFNetException {
        return ColorSpace.__Create(ColorSpace.CreateDeviceGrayL(), null);
    }

    public static ColorSpace createDeviceRGB() throws PDFNetException {
        return ColorSpace.__Create(ColorSpace.CreateDeviceRGBL(), null);
    }

    public static ColorSpace createDeviceCMYK() throws PDFNetException {
        return ColorSpace.__Create(ColorSpace.CreateDeviceCMYKL(), null);
    }

    public static ColorSpace createPattern() throws PDFNetException {
        return ColorSpace.__Create(ColorSpace.CreatePatternL(), null);
    }

    public static ColorSpace createICCFromFile(Doc doc, String string) throws PDFNetException {
        ColorSpace colorSpace = ColorSpace.__Create(ColorSpace.CreateICCFromFile(doc.__GetHandle(), string), null);
        ReachabilityHelper.ensureReachable(doc);
        return colorSpace;
    }

    public static ColorSpace createICCFromFilter(Doc doc, Filter filter) throws PDFNetException {
        ColorSpace colorSpace = ColorSpace.__Create(ColorSpace.CreateICCFromFilter(doc.__GetHandle(), filter.__GetHandle()), null);
        ReachabilityHelper.ensureReachable(doc);
        ReachabilityHelper.ensureReachable(filter);
        return colorSpace;
    }

    public static ColorSpace createICCFromBuffer(Doc doc, byte[] byArray) throws PDFNetException {
        ColorSpace colorSpace = ColorSpace.__Create(ColorSpace.CreateICCFromBuffer(doc.__GetHandle(), byArray), null);
        ReachabilityHelper.ensureReachable(doc);
        return colorSpace;
    }

    public ColorSpace(Obj obj) {
        this.impl = obj.__GetHandle();
        this.ref = obj.__GetRefHandle();
    }

    public static int getComponentNum(int n, Obj obj) throws PDFNetException {
        int n2 = ColorSpace.GetComponentNum(n, obj.__GetHandle());
        ReachabilityHelper.ensureReachable(obj);
        return n2;
    }

    public static int getType(Obj obj) throws PDFNetException {
        int n = ColorSpace.GetTypeStatic(obj.__GetHandle());
        ReachabilityHelper.ensureReachable(obj);
        return n;
    }

    public int getType() throws PDFNetException {
        return ColorSpace.GetType(this.impl);
    }

    public Obj getSDFObj() {
        return Obj.__Create(this.impl, this.ref);
    }

    public int getComponentNum() throws PDFNetException {
        return ColorSpace.GetComponentNum(this.impl);
    }

    public void initColor(ColorPt colorPt) throws PDFNetException {
        ColorSpace.InitColor(this.impl, colorPt.impl);
        ReachabilityHelper.ensureReachable(colorPt);
    }

    public void initComponentRanges(double[] dArray, double[] dArray2) throws PDFNetException {
        int n = this.getComponentNum();
        if (n != dArray.length || n != dArray2.length) {
            throw new PDFNetException("", 0L, "", "", "Error: Arrays passed to InitComponentRanges must have a length\nequal to the number of components in the ColorSpace.");
        }
        ColorSpace.InitComponentRanges(this.impl, dArray, dArray2);
    }

    public ColorPt convert2Gray(ColorPt colorPt) throws PDFNetException {
        ColorPt colorPt2 = new ColorPt(ColorSpace.Convert2Gray(this.impl, colorPt.impl));
        ReachabilityHelper.ensureReachable(colorPt);
        return colorPt2;
    }

    public ColorPt convert2RGB(ColorPt colorPt) throws PDFNetException {
        ColorPt colorPt2 = new ColorPt(ColorSpace.Convert2RGB(this.impl, colorPt.impl));
        ReachabilityHelper.ensureReachable(colorPt);
        return colorPt2;
    }

    public ColorPt convert2CMYK(ColorPt colorPt) throws PDFNetException {
        ColorPt colorPt2 = new ColorPt(ColorSpace.Convert2CMYK(this.impl, colorPt.impl));
        ReachabilityHelper.ensureReachable(colorPt);
        return colorPt2;
    }

    public ColorSpace getAlternateColorSpace() throws PDFNetException {
        return ColorSpace.__Create(ColorSpace.GetAlternateColorSpace(this.impl), this.ref);
    }

    public ColorSpace getBaseColorSpace() throws PDFNetException {
        return ColorSpace.__Create(ColorSpace.GetBaseColorSpace(this.impl), this.ref);
    }

    public byte[] getLookupTable() throws PDFNetException {
        return ColorSpace.GetLookupTable(this.impl);
    }

    public ColorPt getBaseColor(byte by) throws PDFNetException {
        return new ColorPt(ColorSpace.GetBaseColor(this.impl, by));
    }

    public Function getTintFunction() throws PDFNetException {
        return Function.__Create(ColorSpace.GetTintFunction(this.impl), this.ref);
    }

    public boolean isAll() throws PDFNetException {
        return ColorSpace.IsAll(this.impl);
    }

    public boolean isNone() throws PDFNetException {
        return ColorSpace.IsNone(this.impl);
    }

    private ColorSpace(long l, Object object) {
        this.impl = l;
        this.ref = object;
    }

    public static ColorSpace __Create(long l, Object object) {
        if (l == 0L) {
            return null;
        }
        return new ColorSpace(l, object);
    }

    static native long CreateDeviceGrayL();

    static native long CreateDeviceRGBL();

    static native long CreateDeviceCMYKL();

    static native long CreatePatternL();

    static native long CreateICCFromFile(long var0, String var2);

    static native long CreateICCFromFilter(long var0, long var2);

    static native long CreateICCFromBuffer(long var0, byte[] var2);

    static native long ColorSpaceCreate(long var0);

    static native int GetComponentNum(int var0, long var1);

    static native int GetTypeStatic(long var0);

    static native int GetType(long var0);

    static native int GetComponentNum(long var0);

    static native void InitColor(long var0, long var2);

    static native void InitComponentRanges(long var0, double[] var2, double[] var3);

    static native long Convert2Gray(long var0, long var2);

    static native long Convert2RGB(long var0, long var2);

    static native long Convert2CMYK(long var0, long var2);

    static native long GetAlternateColorSpace(long var0);

    static native long GetBaseColorSpace(long var0);

    static native byte[] GetLookupTable(long var0);

    static native long GetBaseColor(long var0, byte var2);

    static native long GetTintFunction(long var0);

    static native boolean IsAll(long var0);

    static native boolean IsNone(long var0);
}

