/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.pdf;

import com.pdftron.common.Matrix2D;
import com.pdftron.common.PDFNetException;
import com.pdftron.helpers.ReachabilityHelper;
import com.pdftron.pdf.Element;
import com.pdftron.pdf.Font;
import com.pdftron.pdf.GState;
import com.pdftron.pdf.Image;
import com.pdftron.pdf.PDFDoc;
import com.pdftron.pdf.Page;
import com.pdftron.pdf.Shading;
import com.pdftron.pdf.ShapedText;
import com.pdftron.pdf.__DelayDelete;
import com.pdftron.sdf.Obj;

public class ElementBuilder
extends __DelayDelete
implements AutoCloseable {
    public ElementBuilder() throws PDFNetException {
        this.impl = ElementBuilder.ElementBuilderCreate();
        this.clearList();
    }

    @Override
    public void destroy() throws PDFNetException {
        if (this.impl != 0L) {
            ElementBuilder.Destroy(this.impl);
            this.impl = 0L;
        }
    }

    public void reset() throws PDFNetException {
        ElementBuilder.Reset(this.impl, 0L);
    }

    public void reset(GState gState) throws PDFNetException {
        ElementBuilder.Reset(this.impl, gState.impl);
        ReachabilityHelper.ensureReachable(gState);
    }

    public Element createImage(Image image) throws PDFNetException {
        return new Element(ElementBuilder.CreateImage(this.impl, image.impl), this, image.ref);
    }

    public Element createImage(Image image, Matrix2D matrix2D) throws PDFNetException {
        Element element = new Element(ElementBuilder.CreateImage(this.impl, image.impl, matrix2D.__GetHandle()), this, image.ref);
        ReachabilityHelper.ensureReachable(matrix2D);
        return element;
    }

    public Element createImage(Image image, double d, double d2, double d3, double d4) throws PDFNetException {
        return new Element(ElementBuilder.CreateImage(this.impl, image.impl, d, d2, d3, d4), this, image.ref);
    }

    public Element createGroupBegin() throws PDFNetException {
        return new Element(ElementBuilder.CreateGroupBegin(this.impl), this, null);
    }

    public Element createGroupEnd() throws PDFNetException {
        return new Element(ElementBuilder.CreateGroupEnd(this.impl), this, null);
    }

    public Element createShading(Shading shading) throws PDFNetException {
        return new Element(ElementBuilder.CreateShading(this.impl, shading.impl), this, shading.ref);
    }

    public Element createForm(Obj obj) throws PDFNetException {
        Element element = new Element(ElementBuilder.CreateFormObj(this.impl, obj.__GetHandle()), this, obj.__GetRefHandle());
        ReachabilityHelper.ensureReachable(obj);
        return element;
    }

    public Element createForm(Page page) throws PDFNetException {
        return new Element(ElementBuilder.CreateForm(this.impl, page.impl), this, page.ref);
    }

    public Element createForm(Page page, PDFDoc pDFDoc) throws PDFNetException {
        Element element = new Element(ElementBuilder.CreateForm(this.impl, page.impl, pDFDoc.__GetHandle()), this, pDFDoc);
        ReachabilityHelper.ensureReachable(page);
        return element;
    }

    public Element createTextBegin(Font font, double d) throws PDFNetException {
        return new Element(ElementBuilder.CreateTextBegin(this.impl, font.impl, d), this, font.ref);
    }

    public Element createTextBegin() throws PDFNetException {
        return new Element(ElementBuilder.CreateTextBegin(this.impl), this, null);
    }

    public Element createTextEnd() throws PDFNetException {
        return new Element(ElementBuilder.CreateTextEnd(this.impl), this, null);
    }

    public Element createTextRun(String string, Font font, double d) throws PDFNetException {
        return new Element(ElementBuilder.CreateTextRun(this.impl, string, font.impl, d), this, font.ref);
    }

    public Element createTextRun(String string) throws PDFNetException {
        return new Element(ElementBuilder.CreateTextRun(this.impl, string), this, null);
    }

    public Element createUnicodeTextRun(String string) throws PDFNetException {
        return new Element(ElementBuilder.CreateUnicodeTextRun(this.impl, string), this, null);
    }

    public Element createShapedTextRun(ShapedText shapedText) throws PDFNetException {
        Element element = new Element(ElementBuilder.CreateShapedTextRun(this.impl, shapedText.__GetHandle()), this, null);
        ReachabilityHelper.ensureReachable(shapedText);
        return element;
    }

    public Element createTextNewLine(double d, double d2) throws PDFNetException {
        return new Element(ElementBuilder.CreateTextNewLine(this.impl, d, d2), this, null);
    }

    public Element createTextNewLine() throws PDFNetException {
        return new Element(ElementBuilder.CreateTextNewLine(this.impl), this, null);
    }

    public Element createPath(double[] dArray, byte[] byArray) throws PDFNetException {
        return new Element(ElementBuilder.CreatePath(this.impl, dArray, byArray), this, null);
    }

    public Element createRect(double d, double d2, double d3, double d4) throws PDFNetException {
        return new Element(ElementBuilder.CreateRect(this.impl, d, d2, d3, d4), this, null);
    }

    public Element createEllipse(double d, double d2, double d3, double d4) throws PDFNetException {
        return new Element(ElementBuilder.CreateEllipse(this.impl, d, d2, d3, d4), this, null);
    }

    public void pathBegin() throws PDFNetException {
        ElementBuilder.PathBegin(this.impl);
    }

    public Element pathEnd() throws PDFNetException {
        return new Element(ElementBuilder.PathEnd(this.impl), this, null);
    }

    public void rect(double d, double d2, double d3, double d4) throws PDFNetException {
        ElementBuilder.Rect(this.impl, d, d2, d3, d4);
    }

    public void moveTo(double d, double d2) throws PDFNetException {
        ElementBuilder.MoveTo(this.impl, d, d2);
    }

    public void lineTo(double d, double d2) throws PDFNetException {
        ElementBuilder.LineTo(this.impl, d, d2);
    }

    public void curveTo(double d, double d2, double d3, double d4, double d5, double d6) throws PDFNetException {
        ElementBuilder.CurveTo(this.impl, d, d2, d3, d4, d5, d6);
    }

    public void arcTo(double d, double d2, double d3, double d4, double d5, double d6) throws PDFNetException {
        ElementBuilder.ArcTo(this.impl, d, d2, d3, d4, d5, d6);
    }

    public void arcTo(double d, double d2, double d3, boolean bl, boolean bl2, double d4, double d5) throws PDFNetException {
        ElementBuilder.ArcTo(this.impl, d, d2, d3, bl, bl2, d4, d5);
    }

    public void ellipse(double d, double d2, double d3, double d4) throws PDFNetException {
        ElementBuilder.Ellipse(this.impl, d, d2, d3, d4);
    }

    public void closePath() throws PDFNetException {
        ElementBuilder.ClosePath(this.impl);
    }

    public Element createMarkedContentBeginInlineProperties(String string) throws PDFNetException {
        return new Element(ElementBuilder.CreateMarkedContentBeginInlineProperties(this.impl, string), this, null);
    }

    public Element createMarkedContentBegin(String string, Obj obj) throws PDFNetException {
        Element element = new Element(ElementBuilder.CreateMarkedContentBegin(this.impl, string, obj.__GetHandle()), this, null);
        ReachabilityHelper.ensureReachable(obj);
        return element;
    }

    public Element createMarkedContentEnd() throws PDFNetException {
        return new Element(ElementBuilder.CreateMarkedContentEnd(this.impl), this, null);
    }

    public Element createMarkedContentPointInlineProperties(String string) throws PDFNetException {
        return new Element(ElementBuilder.CreateMarkedContentPointInlineProperties(this.impl, string), this, null);
    }

    public Element createMarkedContentPoint(String string, Obj obj) throws PDFNetException {
        Element element = new Element(ElementBuilder.CreateMarkedContentPoint(this.impl, string, obj.__GetHandle()), this, null);
        ReachabilityHelper.ensureReachable(obj);
        return element;
    }

    @Override
    public void close() throws PDFNetException {
        this.destroy();
    }

    static native long ElementBuilderCreate();

    static native void Destroy(long var0);

    static native void Reset(long var0, long var2);

    static native long CreateImage(long var0, long var2);

    static native long CreateImage(long var0, long var2, long var4);

    static native long CreateImage(long var0, long var2, double var4, double var6, double var8, double var10);

    static native long CreateGroupBegin(long var0);

    static native long CreateGroupEnd(long var0);

    static native long CreateShading(long var0, long var2);

    static native long CreateFormObj(long var0, long var2);

    static native long CreateForm(long var0, long var2);

    static native long CreateForm(long var0, long var2, long var4);

    static native long CreateTextBegin(long var0, long var2, double var4);

    static native long CreateTextBegin(long var0);

    static native long CreateTextEnd(long var0);

    static native long CreateTextRun(long var0, String var2, long var3, double var5);

    static native long CreateTextRun(long var0, String var2);

    static native long CreateUnicodeTextRun(long var0, String var2);

    static native long CreateShapedTextRun(long var0, long var2);

    static native long CreateTextNewLine(long var0, double var2, double var4);

    static native long CreateTextNewLine(long var0);

    static native long CreatePath(long var0, double[] var2, byte[] var3);

    static native long CreateRect(long var0, double var2, double var4, double var6, double var8);

    static native long CreateEllipse(long var0, double var2, double var4, double var6, double var8);

    static native void PathBegin(long var0);

    static native long PathEnd(long var0);

    static native void Rect(long var0, double var2, double var4, double var6, double var8);

    static native void MoveTo(long var0, double var2, double var4);

    static native void LineTo(long var0, double var2, double var4);

    static native void CurveTo(long var0, double var2, double var4, double var6, double var8, double var10, double var12);

    static native void ArcTo(long var0, double var2, double var4, double var6, double var8, double var10, double var12);

    static native void ArcTo(long var0, double var2, double var4, double var6, boolean var8, boolean var9, double var10, double var12);

    static native void Ellipse(long var0, double var2, double var4, double var6, double var8);

    static native void ClosePath(long var0);

    static native long CreateMarkedContentBeginInlineProperties(long var0, String var2);

    static native long CreateMarkedContentBegin(long var0, String var2, long var3);

    static native long CreateMarkedContentEnd(long var0);

    static native long CreateMarkedContentPointInlineProperties(long var0, String var2);

    static native long CreateMarkedContentPoint(long var0, String var2, long var3);
}

