/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.pdf;

import com.pdftron.common.PDFNetException;
import com.pdftron.helpers.ReachabilityHelper;
import com.pdftron.pdf.PDFDoc;

public class Flattener
implements AutoCloseable {
    public static final int e_very_strict = 0;
    public static final int e_strict = 1;
    public static final int e_default = 2;
    public static final int e_keep_most = 3;
    public static final int e_keep_all = 4;
    public static final int e_simple = 0;
    public static final int e_fast = 1;
    long impl = Flattener.FlattenerCreate();

    public void setDPI(int n) throws PDFNetException {
        Flattener.SetDPI(this.impl, n);
    }

    public void setMaximumImagePixels(int n) throws PDFNetException {
        Flattener.SetMaximumImagePixels(this.impl, n);
    }

    public void setPreferJPG(boolean bl) throws PDFNetException {
        Flattener.SetPreferJPG(this.impl, bl);
    }

    public void setJPGQuality(int n) throws PDFNetException {
        Flattener.SetJPGQuality(this.impl, n);
    }

    public void SetThreshold(int n) throws PDFNetException {
        Flattener.SetThreshold(this.impl, n);
    }

    public void Process(PDFDoc pDFDoc, int n) throws PDFNetException {
        Flattener.Process(this.impl, pDFDoc.__GetHandle(), n);
        ReachabilityHelper.ensureReachable(pDFDoc);
    }

    protected void finalize() throws Throwable {
        this.destroy();
    }

    public void destroy() {
        if (this.impl != 0L) {
            Flattener.Destroy(this.impl);
            this.impl = 0L;
        }
    }

    @Override
    public void close() throws PDFNetException {
        this.destroy();
    }

    static native long FlattenerCreate();

    static native void Destroy(long var0);

    static native void SetDPI(long var0, int var2);

    static native void SetMaximumImagePixels(long var0, int var2);

    static native void SetPreferJPG(long var0, boolean var2);

    static native void SetJPGQuality(long var0, int var2);

    static native void SetThreshold(long var0, int var2);

    static native void Process(long var0, long var2, int var4);
}

