/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.pdf;

import com.pdftron.helpers.ReachabilityHelper;
import com.pdftron.pdf.PDFDoc;

public class Optimizer {
    public static void optimize(PDFDoc pDFDoc) {
        Optimizer.TranslateOptimize(pDFDoc, new ImageSettings(), new ImageSettings(), new MonoImageSettings(), new TextSettings(), true);
    }

    public static void optimize(PDFDoc pDFDoc, OptimizerSettings optimizerSettings) {
        Optimizer.TranslateOptimize(pDFDoc, optimizerSettings.m_color_image_settings == null ? new ImageSettings() : optimizerSettings.m_color_image_settings, optimizerSettings.m_grayscale_image_settings == null ? new ImageSettings() : optimizerSettings.m_grayscale_image_settings, optimizerSettings.m_mono_image_settings == null ? new MonoImageSettings() : optimizerSettings.m_mono_image_settings, optimizerSettings.m_text_settings == null ? new TextSettings() : optimizerSettings.m_text_settings, optimizerSettings.m_remove_custom);
    }

    private static void TranslateOptimize(PDFDoc pDFDoc, ImageSettings imageSettings, ImageSettings imageSettings2, MonoImageSettings monoImageSettings, TextSettings textSettings, boolean bl) {
        Optimizer.Optimize(pDFDoc.__GetHandle(), imageSettings.m_compression_mode, imageSettings.m_downsample_mode, imageSettings.m_quality, imageSettings.m_max_dpi, imageSettings.m_resample_dpi, imageSettings.m_force_recompression, imageSettings.m_force_changes, imageSettings2.m_compression_mode, imageSettings2.m_downsample_mode, imageSettings2.m_quality, imageSettings2.m_max_dpi, imageSettings2.m_resample_dpi, imageSettings2.m_force_recompression, imageSettings2.m_force_changes, monoImageSettings.m_compression_mode, monoImageSettings.m_downsample_mode, monoImageSettings.m_max_dpi, monoImageSettings.m_resample_dpi, monoImageSettings.m_force_recompression, monoImageSettings.m_force_changes, textSettings.m_subset_fonts, textSettings.m_embed_fonts, bl, monoImageSettings.m_jbig2_threshold);
        ReachabilityHelper.ensureReachable(pDFDoc);
    }

    static native void Optimize(long var0, int var2, int var3, long var4, double var6, double var8, boolean var10, boolean var11, int var12, int var13, long var14, double var16, double var18, boolean var20, boolean var21, int var22, int var23, double var24, double var26, boolean var28, boolean var29, boolean var30, boolean var31, boolean var32, double var33);

    private Optimizer() {
    }

    public static class OptimizerSettings {
        private ImageSettings m_color_image_settings;
        private ImageSettings m_grayscale_image_settings;
        private MonoImageSettings m_mono_image_settings;
        private TextSettings m_text_settings;
        private boolean m_remove_custom = true;

        public void setColorImageSettings(ImageSettings imageSettings) {
            this.m_color_image_settings = imageSettings;
        }

        public void setGrayscaleImageSettings(ImageSettings imageSettings) {
            this.m_grayscale_image_settings = imageSettings;
        }

        public void setMonoImageSettings(MonoImageSettings monoImageSettings) {
            this.m_mono_image_settings = monoImageSettings;
        }

        public void setTextSettings(TextSettings textSettings) {
            this.m_text_settings = textSettings;
        }

        public void removeCustomEntries(boolean bl) {
            this.m_remove_custom = bl;
        }
    }

    public static class TextSettings {
        private boolean m_subset_fonts = false;
        private boolean m_embed_fonts = false;

        public void subsetFonts(boolean bl) {
            this.m_subset_fonts = bl;
        }

        public void embedFonts(boolean bl) {
            this.m_embed_fonts = bl;
        }
    }

    public static class MonoImageSettings {
        public static final int e_jbig2 = 0;
        public static final int e_flate = 1;
        public static final int e_none = 2;
        public static final int e_ccitt = 3;
        public static final int e_off = 0;
        public static final int e_default = 1;
        private int m_compression_mode = 3;
        private int m_downsample_mode = 1;
        private double m_max_dpi = 450.0;
        private double m_resample_dpi = 300.0;
        private double m_jbig2_threshold = 8.5;
        private boolean m_force_recompression = false;
        private boolean m_force_changes = false;

        public void setImageDPI(double d, double d2) {
            this.m_max_dpi = d;
            this.m_resample_dpi = d2;
        }

        public void setCompressionMode(int n) {
            this.m_compression_mode = n;
        }

        public void setDownsampleMode(int n) {
            this.m_downsample_mode = n;
        }

        public void forceRecompression(boolean bl) {
            this.m_force_recompression = bl;
        }

        public void forceChanges(boolean bl) {
            this.m_force_changes = bl;
        }

        public void setJBIG2Threshold(double d) {
            this.m_jbig2_threshold = d;
        }
    }

    public static class ImageSettings {
        public static final int e_retain = 0;
        public static final int e_flate = 1;
        public static final int e_jpeg = 2;
        public static final int e_jpeg2000 = 3;
        public static final int e_none = 4;
        public static final int e_off = 0;
        public static final int e_default = 1;
        private int m_compression_mode = 0;
        private int m_downsample_mode = 1;
        private long m_quality = 5L;
        private double m_max_dpi = 225.0;
        private double m_resample_dpi = 150.0;
        private boolean m_force_recompression = false;
        private boolean m_force_changes = false;

        public void setImageDPI(double d, double d2) {
            this.m_max_dpi = d;
            this.m_resample_dpi = d2;
        }

        public void setCompressionMode(int n) {
            this.m_compression_mode = n;
        }

        public void setDownsampleMode(int n) {
            this.m_downsample_mode = n;
        }

        public void setQuality(long l) {
            this.m_quality = l;
        }

        public void forceRecompression(boolean bl) {
            this.m_force_recompression = bl;
        }

        public void forceChanges(boolean bl) {
            this.m_force_changes = bl;
        }
    }
}

